/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc;

import com.pingidentity.common.util.TimerTaskBase;
import java.io.IOException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.util.RspList;
import org.sourceid.mgmt.AdminNodeConfigManager;
import org.sourceid.saml20.domain.SynchronizationData;
import org.sourceid.saml20.domain.SynchronizationRequest;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.service.ConfigSynchronizationService;
import org.sourceid.saml20.service.adminstate.AdminNodesStateManager;
import org.sourceid.saml20.service.adminstate.ConfigSyncStatus;
import org.sourceid.saml20.service.impl.grouprpc.BaseGroupRpc;
import org.sourceid.saml20.service.impl.grouprpc.QuietRpc;
import org.sourceid.saml20.service.util.Node;
import org.sourceid.saml20.service.util.NodeIndexRegistry;

public class ConfigSynchronizationServiceGroupRpcImpl
extends BaseGroupRpc
implements ConfigSynchronizationService {
    private static final Log log = LogFactory.getLog(ConfigSynchronizationServiceGroupRpcImpl.class);
    private static final String GET_SYNCHRONIZATION_DATA_NAME = "getSynchronizationData";
    private static final Class<?>[] GET_SYNCHRONIZATION_DATA_SIG = new Class[]{SynchronizationRequest.class};
    private final AdminNodesStateManager adminNodesStateManager;
    private final AdminNodeConfigManager adminNodeConfigManager;
    private final NodeIndexRegistry nodeIndexRegistry;
    private final Mediator mediator = MgmtFactory.getMediator();

    public ConfigSynchronizationServiceGroupRpcImpl() {
        this.adminNodesStateManager = MgmtFactory.getAdminNodesStateManager();
        this.adminNodeConfigManager = MgmtFactory.getAdminNodeConfigManager();
        this.nodeIndexRegistry = MgmtFactory.getNodeIndexRegistry();
        if (this.mediator.isConsole() && this.mediator.isDistributable()) {
            this.launchConfigSyncTask();
            this.launchConfigReloadTask();
        }
    }

    @Override
    public void init() {
    }

    private void launchConfigSyncTask() {
        TimerTaskBase configSyncTask = new TimerTaskBase(){

            @Override
            public void doTask() {
                ConfigSynchronizationServiceGroupRpcImpl.this.configurationSync();
            }
        };
        Timer timer = new Timer("PassiveConsoleConfigSyncTask", true);
        long syncIntervalMillis = (long)this.adminNodeConfigManager.getPassiveNodeDataSyncIntervalSecs() * 1000L;
        log.debug((Object)("Scheduling admin configuration data sync in " + syncIntervalMillis + " milliseconds"));
        timer.schedule((TimerTask)configSyncTask, syncIntervalMillis, syncIntervalMillis);
    }

    @Override
    public boolean configurationSync() {
        if (!this.adminNodeConfigManager.isPassiveNode()) {
            log.trace((Object)"This is not a passive admin console. Skipping retrieval of synchronization data.");
            return false;
        }
        List<Node> activeNodesList = this.adminNodesStateManager.getActiveNodesFromCluster();
        if (activeNodesList.isEmpty()) {
            log.trace((Object)"No active console available from which to pull synchronization data.");
            return false;
        }
        if (activeNodesList.size() > 1) {
            log.warn((Object)("Skipping synchronization due to multiple active consoles: " + activeNodesList));
            return false;
        }
        try {
            Node activeConsole = activeNodesList.get(0);
            log.trace((Object)("Retrieving synchronization data from active admin console: " + activeConsole.getAddress()));
            return this.retrieveAndDeploySyncData(activeConsole);
        }
        catch (Exception e) {
            log.error((Object)"Unexpected error occurred while synchronizing config", (Throwable)e);
            this.adminNodesStateManager.setSyncStatus(ConfigSyncStatus.FAILED);
            return false;
        }
    }

    @Override
    public boolean fullConfigurationSync() {
        if (!this.adminNodeConfigManager.isPassiveNode()) {
            log.trace((Object)"This is not a passive admin console. Skipping retrieval of synchronization data.");
            return false;
        }
        List<Node> activeNodesList = this.adminNodesStateManager.getActiveNodesFromCluster();
        if (activeNodesList.isEmpty()) {
            log.warn((Object)"No active console available from which to pull synchronization data.");
            return false;
        }
        if (activeNodesList.size() > 1) {
            log.warn((Object)("Skipping synchronization due to multiple active consoles: " + activeNodesList));
            return false;
        }
        try {
            Node activeConsole = activeNodesList.get(0);
            log.trace((Object)("Retrieving synchronization data from active admin console: " + activeConsole.getAddress()));
            Vector<Address> targets = new Vector<Address>();
            Address activeConsoleAddress = activeConsole.getAddress();
            targets.add(activeConsoleAddress);
            int synchronizationDataTimeoutMillis = this.adminNodeConfigManager.getSynchronizationDataTimeoutMillis();
            SynchronizationRequest synchronizationRequest = new SynchronizationRequest();
            Address localNodeAddress = this.nodeIndexRegistry.getLocalNodeAddress();
            if (localNodeAddress != null) {
                synchronizationRequest.setSourceNodeAddress(localNodeAddress.toString());
            }
            synchronizationRequest.setSourceNodeIndex(this.nodeIndexRegistry.getLocalNodeIndex());
            RspList rspList = this.callRemoteMethods(targets, GET_SYNCHRONIZATION_DATA_NAME, (Class[])GET_SYNCHRONIZATION_DATA_SIG, true, synchronizationDataTimeoutMillis, BaseGroupRpc.LogLevel.TRACE, synchronizationRequest);
            SynchronizationData payload = (SynchronizationData)rspList.getFirst();
            if (payload == null) {
                log.error((Object)("Failed to retrieve synchronization data from node " + activeConsoleAddress));
                this.adminNodesStateManager.setSyncStatus(ConfigSyncStatus.FAILED);
                return false;
            }
            this.logReceivedSynchronizationData(activeConsoleAddress, payload);
            this.adminNodesStateManager.setSyncStatus(ConfigSyncStatus.APPLYING);
            this.mediator.deploySynchronizationData(payload);
            this.adminNodesStateManager.setSyncStatus(ConfigSyncStatus.SUCCEEDED);
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Unexpected error occurred while synchronizing config", (Throwable)e);
            return false;
        }
    }

    private void launchConfigReloadTask() {
        int reloadIntervalSecs = this.adminNodeConfigManager.getPassiveNodeConfigReloadIntervalSecs();
        if (reloadIntervalSecs > 0) {
            TimerTaskBase configReloadTask = new TimerTaskBase(){

                @Override
                public void doTask() {
                    ConfigSynchronizationServiceGroupRpcImpl.this.configReload();
                }
            };
            long reloadIntervalMillis = (long)reloadIntervalSecs * 1000L;
            log.debug((Object)("Scheduling admin configuration reload in " + reloadIntervalMillis + " milliseconds"));
            Timer timer = new Timer("PassiveConsoleConfigReloadTask", true);
            timer.schedule((TimerTask)configReloadTask, reloadIntervalMillis, reloadIntervalMillis);
        }
    }

    private void configReload() {
        if (!this.adminNodeConfigManager.isPassiveNode()) {
            log.trace((Object)"This is not a passive admin console. Skipping configuration reload.");
            return;
        }
        log.trace((Object)"Performing periodic configuration reload on this passive admin console.");
        MgmtFactory.getMediator().reloadConfiguration();
    }

    private boolean retrieveAndDeploySyncData(Node activeConsole) {
        this.adminNodesStateManager.setSyncStatus(ConfigSyncStatus.RETRIEVING);
        Vector<Address> targets = new Vector<Address>();
        Address activeConsoleAddress = activeConsole.getAddress();
        targets.add(activeConsoleAddress);
        RspList rspList = this.callRemoteMethods(targets, GET_SYNCHRONIZATION_DATA_NAME, (Class[])GET_SYNCHRONIZATION_DATA_SIG, true, this.adminNodeConfigManager.getSynchronizationDataTimeoutMillis(), BaseGroupRpc.LogLevel.TRACE, this.mediator.makeSynchronizationRequest());
        SynchronizationData payload = (SynchronizationData)rspList.getFirst();
        if (payload == null) {
            log.error((Object)("Failed to retrieve synchronization data from node " + activeConsoleAddress));
            this.adminNodesStateManager.setSyncStatus(ConfigSyncStatus.FAILED);
            return false;
        }
        this.logReceivedSynchronizationData(activeConsoleAddress, payload);
        this.adminNodesStateManager.setSyncStatus(ConfigSyncStatus.APPLYING);
        this.mediator.deploySynchronizationData(payload);
        this.adminNodesStateManager.setSyncStatus(ConfigSyncStatus.SUCCEEDED);
        return true;
    }

    protected void logReceivedSynchronizationData(Address senderAddress, SynchronizationData data) {
        String msg = "Received synchronization data from node " + senderAddress + ": configSyncProfileId=" + data.getConfigSyncProfileId() + ", configSyncTimestamp=" + data.getConfigSyncTimestamp();
        log.trace((Object)msg);
    }

    public static class SynchronizationRequestHandler
    implements RpcTarget {
        private final Mediator mediator = MgmtFactory.getMediator();
        private final AdminNodesStateManager adminNodesStateManager = MgmtFactory.getAdminNodesStateManager();
        private final AdminNodeConfigManager adminNodeConfigManager = MgmtFactory.getAdminNodeConfigManager();

        @Override
        public SynchronizationData getSynchronizationData(SynchronizationRequest request) {
            int requesterNodeIndex = request.getSourceNodeIndex();
            String requesterAddress = request.getSourceNodeAddress();
            if (!this.mediator.isConsole() || this.adminNodeConfigManager.isPassiveNode()) {
                log.debug((Object)String.format("Received synchronization data request from [nodeIndex=%d, address=%s], but this node is not an active admin console.", requesterNodeIndex, requesterAddress));
                return null;
            }
            try {
                log.trace((Object)("Received synchronization data request, requestor's configSyncProfileId=" + request.getConfigSyncProfileId() + ", configSyncTimestamp=" + request.getConfigSyncTimestamp() + ", nodeIndex=" + requesterNodeIndex + ", address=" + requesterAddress));
                SynchronizationData synchronizationData = this.mediator.getSynchronizationData(request);
                log.trace((Object)("Returning synchronization data, local configSyncProfileId=" + synchronizationData.getConfigSyncProfileId() + ", configSyncTimestamp=" + synchronizationData.getConfigSyncTimestamp()));
                this.adminNodesStateManager.setSyncStatus(ConfigSyncStatus.SUCCEEDED);
                return synchronizationData;
            }
            catch (IOException e) {
                log.error((Object)"Unexpected error retrieving synchronization data", (Throwable)e);
                return null;
            }
        }
    }

    public static interface RpcTarget {
        @QuietRpc
        public SynchronizationData getSynchronizationData(SynchronizationRequest var1);
    }
}

