/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc;

import com.pingidentity.common.util.PropertyInfo;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.util.RspList;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AuthnSessionInfo;
import org.sourceid.saml20.service.AuthnSessionInfoImpl;
import org.sourceid.saml20.service.AuthnSessionInfoWithoutBeansImpl;
import org.sourceid.saml20.service.BeanFilter;
import org.sourceid.saml20.service.CachedSessionGroupInfo;
import org.sourceid.saml20.service.CachedSessionGroupStatus;
import org.sourceid.saml20.service.HasAuthnBeanForSsoResult;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.IdpSessionRegistry;
import org.sourceid.saml20.service.Session;
import org.sourceid.saml20.service.SessionInfoForPartnerSessionsResult;
import org.sourceid.saml20.service.SessionRegistryException;
import org.sourceid.saml20.service.impl.grouprpc.BasePreferredNodesGroupRpc;
import org.sourceid.saml20.service.impl.grouprpc.PreferredNodeGroup;
import org.sourceid.saml20.service.impl.grouprpc.ReplicationMode;
import org.sourceid.saml20.service.impl.grouprpc.RspUtil;
import org.sourceid.saml20.service.impl.localmemory.IdpSessionRegistryMapImpl;
import org.sourceid.saml20.service.session.AuthnSessionContextData;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.websso.servlet.ExtendedSri;
import org.sourceid.websso.servlet.SessionIdUtil;

public class IdpSessionRegistryGroupRpcImpl
extends BasePreferredNodesGroupRpc
implements IdpSessionRegistry {
    private IdpSessionRegistryMapImpl idpSessionRegistryMap;
    public static final String CONFIG_PROPS_FILENAME = "cluster-idp-session-registry.conf";
    private static final Class[] GET_REGED_BY_ASSERTION_IDS_SIG = new Class[]{Collection.class};
    private static final String GET_REGED_BY_ASSERTION_IDS = "getRegisteredByAssertionIds";
    private static final Class[] GET_ISSUED_SESSIONS_SIG = new Class[]{Collection.class};
    private static final String GET_ISSUED_SESSIONS = "getIssuedSessions";
    private static final Class[] GET_REGISTERED_SIG = new Class[]{String.class};
    private static final String GET_REGISTERED = "getRegistered";
    private static final Class[] UPDATE_CACHED_SESSION_GROUP_INFOS_SIG = new Class[]{String.class, Collection.class};
    private static final String UPDATE_CACHED_SESSION_GROUP_INFOS = "updateCachedSessionGroupInfos";
    private static final Class[] REGISTER_SESSION_SIG = new Class[]{String.class, String.class, Long.class, IdpHashableAuthnBean.class, Session.class, Collection.class};
    private static final String REGISTER_SESSION_NAME = "registerSessionIssued";
    private static final Class[] REGISTER_BEANS_SIG = new Class[]{String.class, String.class, Long.class, Long.class, Set.class, Collection.class, Collection.class, AuthnSessionContextData.class};
    private static final String REGISTER_BEANS_NAME = "registerBeans";
    private static final Class[] UNREGISTER_SESSION_SIG = new Class[]{Collection.class};
    private static final Class[] UNREGISTER_BEAN_SESSIONS_SIG = new Class[]{IdpHashableAuthnBean.class, Collection.class};
    private static final String UNREGISTER_SESSION_NAME = "unregisterSessions";
    private static final Class[] UNREGISTER_BEAN_SIG = new Class[]{IdpHashableAuthnBean.class};
    private static final String UNREGISTER_BEAN_NAME = "unregisterAuthnBean";
    private static final Class[] SET_BEANS_INVALID_FOR_SSO_SIG = new Class[]{Collection.class};
    private static final String SET_BEANS_INVALID_FOR_SSO_NAME = "setBeansInvalidForSso";
    private static final Class[] SET_BEANS_INVALID_FOR_LOGOUT_SIG = new Class[]{Collection.class};
    private static final String SET_BEANS_INVALID_FOR_LOGOUT_NAME = "setBeansInvalidForLogout";
    private static final Class[] GET_AUTHN_SESSION_INFO_SIG = new Class[]{String.class};
    private static final String GET_AUTHN_SESSION_INFO_NAME = "getAuthnSessionInfo";
    private static final Class[] GET_SESSION_IDS_FOR_PARTNER_SESSIONS_SIG = new Class[]{String.class, NameIDType.class, Collection.class};
    private static final String GET_SESSION_INFO_FOR_PARTNER_SESSIONS_NAME = "getSessionInfoForPartnerSessions";
    private static final String GET_AUTHN_SESSION_INFO_BY_SRI_NAME = "getAuthnSessionInfoBySri";
    private static final Class[] GET_AUTHN_SESSION_INFO_BY_SRI_SIG = new Class[]{String.class, Boolean.class, BeanFilter.class};
    private static final String GET_SRIS_FOR_UNIQUE_USER_KEY_NAME = "getSrisForUniqueUserKey";
    private static final Class[] GET_SRIS_FOR_UNIQUE_USER_KEY_SIG = new Class[]{String.class};
    private static final String REGISTER_SRI_TO_UNIQUE_USER_KEY_NAME = "registerSriToUniqueUserKey";
    private static final Class[] REGISTER_SRI_TO_UNIQUE_USER_KEY_SIG = new Class[]{String.class, String.class};
    private static final String UNREGISTER_SRI_FROM_UNIQUE_USER_KEY_NAME = "unregisterSriFromUniqueUserKey";
    private static final Class[] UNREGISTER_SRI_FROM_UNIQUE_USER_KEY_SIG = new Class[]{String.class, String.class};
    private static final String SET_BEAN_INVALID_FOR_SSO_NAME = "setBeanInvalidForSso";
    private static final Class[] SET_BEAN_INVALID_FOR_SSO_SIG = new Class[]{String.class, String.class};
    private static final String UPDATE_SESSION_CONTEXT_INFO = "updateSessionContextInfo";
    private static final Class[] UPDATE_SESSION_CONTEXT_INFO_SIG = new Class[]{String.class, AuthnSessionContextData.class};

    public IdpSessionRegistryGroupRpcImpl() throws Exception {
        super(CONFIG_PROPS_FILENAME, true, StateMgmtFactory.getAdaptiveClusteringConfig().isReplicateSessions());
        this.idpSessionRegistryMap = (IdpSessionRegistryMapImpl)this.muxRpcDispatcherMgr.getRpcInvocationTarget(IdpSessionRegistry.class);
    }

    @Override
    public Map<IdpHashableAuthnBean, Collection<Session>> getRegistered(String extendedSessionId) {
        RspList rspList = this.callRemoteMethods(GET_REGISTERED, GET_REGISTERED_SIG, true, ReplicationMode.CACHE_ACCESS, extendedSessionId);
        return RspUtil.aggregateMapRsp(rspList);
    }

    @Override
    public AuthnSessionInfo getAuthnSessionInfoBySri(String extendedSriStr, Boolean updateActivityTime, BeanFilter beanFilter) throws SessionRegistryException {
        Vector<Address> nodes;
        ExtendedSri extendedSri = this.getExtendedSri(extendedSriStr, "Error getting authn session info by SRI");
        if (!PropertyInfo.isAdaptiveClusteringEnabled()) {
            PreferredNodeGroup targetNodeGroup;
            String localGroupId;
            PreferredNodeGroup nodeGroup = this.getPreferredNodeGroup();
            String string = localGroupId = nodeGroup != null ? nodeGroup.getGroupId() : null;
            if (extendedSri.getGroupId() != null && !extendedSri.getGroupId().equals(localGroupId) && (targetNodeGroup = MgmtFactory.getNodeIndexRegistry().getIdpSessionRegistryNodeGroup(extendedSri.getGroupId())) != null) {
                RspList rspList = this.callRemoteMethods(targetNodeGroup.getAddresses(), GET_AUTHN_SESSION_INFO_BY_SRI_NAME, GET_AUTHN_SESSION_INFO_BY_SRI_SIG, true, this.getRpcTimeout(), new Object[]{extendedSriStr, updateActivityTime, beanFilter});
                return IdpSessionRegistryGroupRpcImpl.processRemoteMethodAuthnSessionInfoResults((RspList<AuthnSessionInfo>)rspList, beanFilter != BeanFilter.NO_BEANS);
            }
        }
        ReplicationMode replicationMode = updateActivityTime != false ? ReplicationMode.ASYNC : ReplicationMode.NOT_REPLICATED;
        RspList rspList = this.callRemoteMethods(GET_AUTHN_SESSION_INFO_BY_SRI_NAME, GET_AUTHN_SESSION_INFO_BY_SRI_SIG, extendedSri.getSri(), true, replicationMode, new Object[]{extendedSriStr, updateActivityTime, beanFilter});
        AuthnSessionInfo result = IdpSessionRegistryGroupRpcImpl.processRemoteMethodAuthnSessionInfoResults((RspList<AuthnSessionInfo>)rspList, beanFilter != BeanFilter.NO_BEANS);
        if (!result.getBeans().isEmpty()) {
            return result;
        }
        String groupId = extendedSri.getGroupId();
        if (groupId == null) {
            groupId = "";
        }
        if (PropertyInfo.isAdaptiveClusteringEnabled() && !groupId.equals(StateMgmtFactory.getAdaptiveClusteringConfig().getNodeGroupId()) && !(nodes = StateMgmtFactory.getDistributedStateCoordinator().getNodeGroupReplicas(groupId, extendedSri.getSri())).isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No authn session found in local node group, checking node group from SRI: " + groupId));
            }
            rspList = this.callRemoteMethods(nodes, GET_AUTHN_SESSION_INFO_BY_SRI_NAME, GET_AUTHN_SESSION_INFO_BY_SRI_SIG, true, this.getRpcTimeout(), new Object[]{extendedSriStr, updateActivityTime, beanFilter});
            result = IdpSessionRegistryGroupRpcImpl.processRemoteMethodAuthnSessionInfoResults((RspList<AuthnSessionInfo>)rspList, beanFilter != BeanFilter.NO_BEANS);
        }
        return result;
    }

    @Override
    public AuthnSessionInfo getAuthnSessionInfo(String extendedSessionId) {
        RspList rspList = this.callRemoteMethods(GET_AUTHN_SESSION_INFO_NAME, GET_AUTHN_SESSION_INFO_SIG, true, ReplicationMode.ASYNC, extendedSessionId);
        return this.processRemoteMethodAuthnSessionInfoResults((RspList<AuthnSessionInfo>)rspList);
    }

    static AuthnSessionInfo processRemoteMethodAuthnSessionInfoResults(RspList<AuthnSessionInfo> rspList, boolean includeBeans) {
        long sessionSeriesId = rspList.getResults().stream().map(AuthnSessionInfo::getSessionSeriesId).max(Long::compare).orElse(0L);
        String persistentSessionGroupId = null;
        long lastActivityTimeMillis = 0L;
        AuthnSessionContextData sessionContextData = null;
        AuthnSessionInfo mostRecent = IdpSessionRegistryGroupRpcImpl.getMostRecentlyActiveSessionInfo(rspList.getResults());
        Set uniqueUserKeys = rspList.getResults().stream().map(AuthnSessionInfo::getUniqueUserKeys).flatMap(Collection::stream).collect(Collectors.toCollection(HashSet::new));
        if (mostRecent != null) {
            persistentSessionGroupId = mostRecent.getPersistentSessionGroupId();
            lastActivityTimeMillis = mostRecent.getLastActivityTimeMillis();
            sessionContextData = mostRecent.getSessionContextData();
        }
        Collection<CachedSessionGroupStatus> mergedSessionGroupStatuses = IdpSessionRegistryGroupRpcImpl.mergeSessionGroupStatuses(rspList.getResults().stream().flatMap(info -> info.getSessionGroupStatuses().stream()).collect(Collectors.toList()));
        Set<String> indexKeysToRefresh = rspList.getResults().stream().map(AuthnSessionInfo::getIndexKeysToRefresh).flatMap(Collection::stream).collect(Collectors.toSet());
        if (includeBeans) {
            Set<IdpHashableAuthnBean> beans = rspList.getResults().stream().flatMap(info -> info.getBeans().stream()).collect(Collectors.toSet());
            return new AuthnSessionInfoImpl.Builder().setSessionSeriesId(sessionSeriesId).setBeans(beans).setPersistentSessionGroupId(persistentSessionGroupId).setSessionGroupStatuses(mergedSessionGroupStatuses).setLastActivityTimeMillis(lastActivityTimeMillis).setUniqueUserKeys(uniqueUserKeys).setSessionContextData(sessionContextData).setIndexKeysToRefresh(indexKeysToRefresh).build();
        }
        boolean hasAuthnSessions = rspList.getResults().stream().anyMatch(AuthnSessionInfo::hasAuthnSessions);
        return new AuthnSessionInfoWithoutBeansImpl.Builder().setSessionSeriesId(sessionSeriesId).setHasAuthnSessions(hasAuthnSessions).setPersistentSessionGroupId(persistentSessionGroupId).setSessionGroupStatuses(mergedSessionGroupStatuses).setLastActivityTimeMillis(lastActivityTimeMillis).setUniqueUserKeys(uniqueUserKeys).setSessionContextData(sessionContextData).setIndexKeysToRefresh(indexKeysToRefresh).build();
    }

    private AuthnSessionInfo processRemoteMethodAuthnSessionInfoResults(RspList<AuthnSessionInfo> rspList) {
        return IdpSessionRegistryGroupRpcImpl.processRemoteMethodAuthnSessionInfoResults(rspList, true);
    }

    @Override
    public void updateCachedSessionGroupInfos(String extendedSriStr, Collection<CachedSessionGroupInfo> sessionGroupInfos) throws SessionRegistryException {
        PreferredNodeGroup nodeGroup;
        ExtendedSri extendedSri = this.getExtendedSri(extendedSriStr, "Error updating stored last activity time");
        if (!PropertyInfo.isAdaptiveClusteringEnabled() && extendedSri.getGroupId() != null && (nodeGroup = MgmtFactory.getNodeIndexRegistry().getIdpSessionRegistryNodeGroup(extendedSri.getGroupId())) != null) {
            this.callRemoteMethods(nodeGroup.getAddresses(), UPDATE_CACHED_SESSION_GROUP_INFOS, UPDATE_CACHED_SESSION_GROUP_INFOS_SIG, false, this.preferredNodes.getTimeout(), extendedSriStr, sessionGroupInfos);
            return;
        }
        this.callRemoteMethods(UPDATE_CACHED_SESSION_GROUP_INFOS, UPDATE_CACHED_SESSION_GROUP_INFOS_SIG, extendedSri.getSri(), false, ReplicationMode.NOT_REPLICATED, extendedSriStr, sessionGroupInfos);
    }

    private ExtendedSri getExtendedSri(String extendedSriStr, String errMsg) throws SessionRegistryException {
        ExtendedSri extendedSri = null;
        try {
            extendedSri = new ExtendedSri(extendedSriStr);
        }
        catch (InvalidParameterException e) {
            throw new SessionRegistryException(errMsg, e);
        }
        return extendedSri;
    }

    @Override
    public void unregisterAuthnBean(IdpHashableAuthnBean authnBean) {
        this.callRemoteMethods(UNREGISTER_BEAN_NAME, UNREGISTER_BEAN_SIG, false, ReplicationMode.ASYNC, authnBean);
    }

    @Override
    public void registerSessionIssued(String oldExtendedSessionId, String newExtendedSessionId, Long sessionSeriesId, IdpHashableAuthnBean authnBean, Session session, Collection<String> uniqueUserKeys) {
        boolean synchronous = authnBean.isValidForSso();
        this.callRemoteMethods(REGISTER_SESSION_NAME, REGISTER_SESSION_SIG, synchronous, ReplicationMode.ASYNC, oldExtendedSessionId, newExtendedSessionId, sessionSeriesId, authnBean, session, uniqueUserKeys);
    }

    @Override
    public void registerBeans(String oldExtendedSessionId, String newExtendedSessionId, Long sessionSeriesId, Long lastActivityTime, Set<IdpHashableAuthnBean> authnBeans, Collection<CachedSessionGroupInfo> sessionGroupInfos, Collection<String> uniqueUserKeys, AuthnSessionContextData authnSessionContextData) {
        String sri = SessionIdUtil.getInstance().getSriFromExtendedId(newExtendedSessionId);
        this.callRemoteMethods(REGISTER_BEANS_NAME, REGISTER_BEANS_SIG, sri, true, ReplicationMode.ASYNC, oldExtendedSessionId, newExtendedSessionId, sessionSeriesId, lastActivityTime, authnBeans, sessionGroupInfos, uniqueUserKeys, authnSessionContextData);
    }

    @Override
    public IdpHashableAuthnBean setBeanInvalidForSso(String extendedSriStr, String authnBeanSerializedHash) throws SessionRegistryException {
        ExtendedSri extendedSri = this.getExtendedSri(extendedSriStr, "Error setting session bean as invalid for SSO due to invalid SRI");
        if (!PropertyInfo.isAdaptiveClusteringEnabled()) {
            PreferredNodeGroup targetNodeGroup;
            String localGroupId;
            PreferredNodeGroup nodeGroup = this.getPreferredNodeGroup();
            String string = localGroupId = nodeGroup != null ? nodeGroup.getGroupId() : null;
            if (extendedSri.getGroupId() != null && !extendedSri.getGroupId().equals(localGroupId) && (targetNodeGroup = MgmtFactory.getNodeIndexRegistry().getIdpSessionRegistryNodeGroup(extendedSri.getGroupId())) != null) {
                RspList rspList = this.callRemoteMethods(targetNodeGroup.getAddresses(), SET_BEAN_INVALID_FOR_SSO_NAME, SET_BEAN_INVALID_FOR_SSO_SIG, true, this.getRpcTimeout(), extendedSriStr, authnBeanSerializedHash);
                return RspUtil.getFirstNotNull(rspList, IdpHashableAuthnBean.class);
            }
        }
        RspList rspList = this.callRemoteMethods(SET_BEAN_INVALID_FOR_SSO_NAME, SET_BEAN_INVALID_FOR_SSO_SIG, extendedSri.getSri(), true, ReplicationMode.ASYNC, extendedSriStr, authnBeanSerializedHash);
        return RspUtil.getFirstNotNull(rspList, IdpHashableAuthnBean.class);
    }

    @Override
    public Map<IdpHashableAuthnBean, Collection<Session>> getIssuedSessions(Collection<IdpHashableAuthnBean> authnBeans) {
        RspList rspList = this.callRemoteMethods(GET_ISSUED_SESSIONS, GET_ISSUED_SESSIONS_SIG, true, ReplicationMode.CACHE_ACCESS, authnBeans);
        return RspUtil.aggregateMapRsp(rspList);
    }

    @Override
    public void unregisterSessions(Collection<String> assertionIds) {
        this.callRemoteMethods(UNREGISTER_SESSION_NAME, UNREGISTER_SESSION_SIG, false, ReplicationMode.ASYNC, assertionIds);
    }

    @Override
    public void unregisterSessions(IdpHashableAuthnBean authnBean, Collection<? extends Session> sessions) {
        this.callRemoteMethods(UNREGISTER_SESSION_NAME, UNREGISTER_BEAN_SESSIONS_SIG, false, ReplicationMode.ASYNC, authnBean, sessions);
    }

    @Override
    public Map<IdpHashableAuthnBean, Collection<Session>> getRegisteredByAssertionIds(Collection<String> assertionIds) {
        RspList rspList = this.callRemoteMethods(GET_REGED_BY_ASSERTION_IDS, GET_REGED_BY_ASSERTION_IDS_SIG, true, ReplicationMode.CACHE_ACCESS, assertionIds);
        return RspUtil.aggregateMapRsp(rspList);
    }

    @Override
    public void setBeansInvalidForSso(Collection<String> primarySessionIds) {
        this.callRemoteMethods(SET_BEANS_INVALID_FOR_SSO_NAME, SET_BEANS_INVALID_FOR_SSO_SIG, false, ReplicationMode.ASYNC, primarySessionIds);
    }

    @Override
    public void setBeansInvalidForLogout(Collection<IdpHashableAuthnBean> beans) {
        beans.stream().forEach(bean -> bean.setDoLogout(false));
        this.callRemoteMethods(SET_BEANS_INVALID_FOR_LOGOUT_NAME, SET_BEANS_INVALID_FOR_LOGOUT_SIG, false, ReplicationMode.ASYNC, beans);
    }

    @Override
    public SessionInfoForPartnerSessionsResult getSessionInfoForPartnerSessions(String partnerEntityId, NameIDType nameId, Collection<String> sessionIndices) {
        RspList rspList = this.callRemoteMethods(GET_SESSION_INFO_FOR_PARTNER_SESSIONS_NAME, GET_SESSION_IDS_FOR_PARTNER_SESSIONS_SIG, true, ReplicationMode.CACHE_ACCESS, partnerEntityId, nameId, sessionIndices);
        return IdpSessionRegistryGroupRpcImpl.mergeSessionInfoForPartnerSessionsResults(rspList.getResults());
    }

    protected static SessionInfoForPartnerSessionsResult mergeSessionInfoForPartnerSessionsResults(Collection<SessionInfoForPartnerSessionsResult> records) {
        HashSet<String> mergedSessionIds = new HashSet<String>();
        HashSet<String> mergedSessionGroupIds = new HashSet<String>();
        HashSet<IdpHashableAuthnBean> mergedBeans = new HashSet<IdpHashableAuthnBean>();
        for (SessionInfoForPartnerSessionsResult record : records) {
            mergedSessionIds.addAll(record.getPrimarySessionIds());
            mergedSessionGroupIds.addAll(record.getStoredSessionGroupIds());
            mergedBeans.addAll(record.getBeans());
        }
        return new SessionInfoForPartnerSessionsResult(mergedSessionIds, mergedSessionGroupIds, mergedBeans);
    }

    protected static Collection<CachedSessionGroupStatus> mergeSessionGroupStatuses(Collection<CachedSessionGroupStatus> received) {
        Map<String, CachedSessionGroupStatus> sessionGroupStatuses = received.stream().collect(Collectors.toMap(info -> info.getSessionGroupId(), info -> info, IdpSessionRegistryGroupRpcImpl::combineSessionGroupStatuses));
        return new ArrayList<CachedSessionGroupStatus>(sessionGroupStatuses.values());
    }

    @Override
    public int getSessionInfoMapSize() {
        return this.idpSessionRegistryMap.getSessionInfoMapSize();
    }

    protected static AuthnSessionInfo getMostRecentlyActiveSessionInfo(Collection<AuthnSessionInfo> infos) {
        return infos.stream().max((info1, info2) -> Long.compare(info1.getLastActivityTimeMillis(), info2.getLastActivityTimeMillis())).orElse(null);
    }

    protected static HasAuthnBeanForSsoResult mergeHasAuthnBeanForSsoResults(Collection<HasAuthnBeanForSsoResult> resultsToMerge) {
        boolean hasBean = resultsToMerge.stream().anyMatch(toMerge -> toMerge.hasBean());
        Collection<CachedSessionGroupStatus> sessionGroupInfos = IdpSessionRegistryGroupRpcImpl.mergeSessionGroupStatuses(resultsToMerge.stream().flatMap(toMerge -> toMerge.getSessionGroupStatuses().stream()).collect(Collectors.toList()));
        return new HasAuthnBeanForSsoResult(hasBean, sessionGroupInfos);
    }

    private static CachedSessionGroupStatus combineSessionGroupStatuses(CachedSessionGroupStatus info1, CachedSessionGroupStatus info2) {
        return new CachedSessionGroupStatus(info1.getSessionGroupId(), Math.max(info1.getIdleTimeoutFractionElapsed(), info2.getIdleTimeoutFractionElapsed()));
    }

    @Override
    public Collection<String> registerSriToUniqueUserKey(String uniqueUserKey, String extendedSri) {
        RspList rsps = this.callRemoteMethods(REGISTER_SRI_TO_UNIQUE_USER_KEY_NAME, REGISTER_SRI_TO_UNIQUE_USER_KEY_SIG, uniqueUserKey, true, ReplicationMode.ASYNC, uniqueUserKey, extendedSri);
        return RspUtil.aggregate(rsps);
    }

    @Override
    public void unregisterSriFromUniqueUserKey(String uniqueUserKey, String extendedSri) {
        this.callRemoteMethods(UNREGISTER_SRI_FROM_UNIQUE_USER_KEY_NAME, UNREGISTER_SRI_FROM_UNIQUE_USER_KEY_SIG, uniqueUserKey, false, ReplicationMode.ASYNC, uniqueUserKey, extendedSri);
    }

    @Override
    public Collection<String> getSrisForUniqueUserKey(String uniqueUserKey) {
        RspList rspList = this.callRemoteMethods(GET_SRIS_FOR_UNIQUE_USER_KEY_NAME, GET_SRIS_FOR_UNIQUE_USER_KEY_SIG, uniqueUserKey, true, ReplicationMode.NOT_REPLICATED, uniqueUserKey);
        return rspList.getResults().stream().flatMap(Collection::stream).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    public void updateSessionContextInfo(String extendedSessionId, AuthnSessionContextData sessionContextData) {
        this.callRemoteMethods(UPDATE_SESSION_CONTEXT_INFO, UPDATE_SESSION_CONTEXT_INFO_SIG, false, ReplicationMode.ASYNC, extendedSessionId, sessionContextData);
    }
}

