/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc;

import com.pingidentity.common.util.PropertyInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jgroups.Address;
import org.jgroups.util.RspList;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.InterRequestStateMgmt;
import org.sourceid.saml20.service.impl.grouprpc.BasePreferredNodesGroupRpc;
import org.sourceid.saml20.service.impl.grouprpc.ReplicationMode;
import org.sourceid.saml20.service.impl.grouprpc.RspUtil;
import org.sourceid.saml20.service.impl.localmemory.InterReqStateMgmtMapImpl;
import org.sourceid.saml20.service.util.NodeIndexRegistry;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateMgmtFactory;

public class InterRequestStateMgmtGroupRpcImpl
extends BasePreferredNodesGroupRpc
implements InterRequestStateMgmt {
    private ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.saml20.service.impl.grouprpc.InterRequestStateMgmtGroupRpcImpl");
    private static final Class[] SAVE_STATE_SIG = new Class[]{String.class, State.class};
    private static final String SAVE_STATE_NAME = "saveState";
    private static final Class[] RETRIEVE_SIG = new Class[]{String.class};
    private static final String RETRIEVE_NAME = "retrieveAndRemoveState";
    private static final Class[] SET_ATTR_SIG = new Class[]{String.class, String.class, String.class, Object.class};
    private static final String SET_ATTR_NAME = "setAttr";
    private static final Class[] REMOVE_ATTR_SIG = new Class[]{String.class, String.class};
    private static final String REMOVE_ATTR_NAME = "removeAttr";
    private static final Class[] GET_ATTR_SIG = new Class[]{String.class, String.class};
    private static final String GET_ATTR = "getAttr";
    private static final Class[] GET_ATTRS_SIG = new Class[]{String.class};
    private static final String GET_ATTRS = "getAttrs";
    private static final Class[] ADD_TO_SET_ATTR_SIG = new Class[]{String.class, Collection.class};
    private static final String ADD_TO_SET_ATTR_NAME = "addToSetAttr";
    private static final Class[] REMOVE_FROM_SET_ATTR_SIG = new Class[]{String.class, Collection.class};
    private static final String REMOVE_FROM_SET_ATTR_NAME = "removeFromSetAttr";
    private static final Class[] GET_SET_ATTR_SIG = new Class[]{String.class};
    private static final String GET_SET_ATTR_NAME = "getSetAttr";
    private static final int TIMEOUT = 1000;
    InterReqStateMgmtMapImpl interReqStateMgmtMap = (InterReqStateMgmtMapImpl)this.muxRpcDispatcherMgr.getRpcInvocationTarget(RpcTarget.class);
    private final NodeIndexRegistry nodeIndexRegistry = MgmtFactory.getNodeIndexRegistry();

    public InterRequestStateMgmtGroupRpcImpl() throws Exception {
        super("cluster-inter-request-state.conf", true, StateMgmtFactory.getAdaptiveClusteringConfig().isReplicateSessions());
    }

    @Override
    public void saveState(String stateKey, State state, HttpServletRequest req, HttpServletResponse resp) {
        ReplicationMode replicationMode = StateMgmtFactory.getAdaptiveClusteringConfig().isReplicateTransactionState() ? ReplicationMode.ASYNC : ReplicationMode.NOT_REPLICATED;
        this.callRemoteMethods(SAVE_STATE_NAME, SAVE_STATE_SIG, stateKey, true, replicationMode, stateKey, state);
    }

    @Override
    public State retrieveAndRemoveState(String stateKey, HttpServletRequest req, HttpServletResponse resp) {
        ReplicationMode replicationMode = StateMgmtFactory.getAdaptiveClusteringConfig().isReplicateTransactionState() ? ReplicationMode.ASYNC : ReplicationMode.NOT_REPLICATED;
        RspList rspList = this.callRemoteMethods(RETRIEVE_NAME, RETRIEVE_SIG, stateKey, true, replicationMode, stateKey);
        return RspUtil.getBest(rspList, State.COMPARE_BY_CREATED_TIME, State.class);
    }

    @Override
    public void setAttribute(String name, Object value, HttpServletRequest req, HttpServletResponse resp, boolean usedAsLoginCtx) {
        String[] keys = this.interReqStateMgmtMap.getKeys(req, resp, usedAsLoginCtx);
        this.callRemoteMethods(SET_ATTR_NAME, SET_ATTR_SIG, this.getAttrPartitionKey(req, resp), true, ReplicationMode.ASYNC, keys[0], keys[1], name, value);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (!PropertyInfo.isAdaptiveClusteringEnabled()) {
            Vector<Address> nodes = this.nodeIndexRegistry.getAddresses(null);
            this.callRemoteMethods(nodes, SET_ATTR_NAME, SET_ATTR_SIG, true, this.rpcResponseMode, null, 1000, key, key, "default.name", value);
        } else {
            this.callRemoteMethods(SET_ATTR_NAME, SET_ATTR_SIG, key, true, ReplicationMode.SYNC, key, key, "default.name", value);
        }
    }

    @Override
    public Object getAttribute(String name, HttpServletRequest req, HttpServletResponse resp) {
        String key = this.interReqStateMgmtMap.getKey(req, resp);
        Object attribute = null;
        if (!PropertyInfo.isAdaptiveClusteringEnabled() && this.isEnableLocalReadOptimization()) {
            attribute = this.interReqStateMgmtMap.getAttr(key, name);
        }
        if (attribute == null && key != null) {
            RspList rspList = this.callRemoteMethods(GET_ATTR, GET_ATTR_SIG, this.getAttrPartitionKey(req, resp), true, ReplicationMode.CACHE_ACCESS, key, name);
            attribute = RspUtil.getFirstNotNull(rspList, Object.class);
        }
        return attribute;
    }

    @Override
    public Map<String, Object> getAttributes(HttpServletRequest req, HttpServletResponse resp) {
        String key = this.interReqStateMgmtMap.getKey(req, resp);
        RspList rspList = this.callRemoteMethods(GET_ATTRS, GET_ATTRS_SIG, this.getAttrPartitionKey(req, resp), true, ReplicationMode.CACHE_ACCESS, key);
        return RspUtil.aggregateMapRsp(rspList);
    }

    @Override
    public Object getAttribute(String key) {
        Object attribute = null;
        if (!PropertyInfo.isAdaptiveClusteringEnabled() && this.isEnableLocalReadOptimization()) {
            attribute = this.interReqStateMgmtMap.getAttr(key, "default.name");
        }
        if (attribute == null && key != null) {
            RspList rspList = this.callRemoteMethods(GET_ATTR, GET_ATTR_SIG, key, true, ReplicationMode.ASYNC, key, "default.name");
            attribute = RspUtil.getFirstNotNull(rspList, Object.class);
        }
        return attribute;
    }

    @Override
    public Object removeAttribute(String name, HttpServletRequest req, HttpServletResponse resp) {
        String key = this.interReqStateMgmtMap.getKey(req, resp);
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        RspList rpsList = this.callRemoteMethods(REMOVE_ATTR_NAME, REMOVE_ATTR_SIG, this.getAttrPartitionKey(req, resp), true, ReplicationMode.ASYNC, key, name);
        return RspUtil.getFirstNotNull(rpsList, Object.class);
    }

    @Override
    public Object removeAttribute(String key) {
        RspList rpsList;
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        if (!PropertyInfo.isAdaptiveClusteringEnabled()) {
            Vector<Address> nodes = this.nodeIndexRegistry.getAddresses(null);
            rpsList = this.callRemoteMethods(nodes, REMOVE_ATTR_NAME, REMOVE_ATTR_SIG, true, this.rpcResponseMode, null, 1000, key, "default.name");
        } else {
            rpsList = this.callRemoteMethods(REMOVE_ATTR_NAME, REMOVE_ATTR_SIG, key, true, ReplicationMode.ASYNC, key, "default.name");
        }
        return RspUtil.getFirstNotNull(rpsList, Object.class);
    }

    @Override
    public <T> Set<T> addToSetAttribute(String key, Collection<T> items, Boolean synchronous) {
        RspList rspList;
        if (StringUtils.isBlank((String)key)) {
            return synchronous != false ? Collections.emptySet() : null;
        }
        if (!PropertyInfo.isAdaptiveClusteringEnabled()) {
            Vector<Address> nodes = this.nodeIndexRegistry.getAddresses(null);
            rspList = this.callRemoteMethods(nodes, ADD_TO_SET_ATTR_NAME, ADD_TO_SET_ATTR_SIG, (boolean)synchronous, this.rpcResponseMode, null, 1000, key, items);
        } else {
            rspList = this.callRemoteMethods(ADD_TO_SET_ATTR_NAME, ADD_TO_SET_ATTR_SIG, key, (boolean)synchronous, ReplicationMode.ASYNC, key, items);
        }
        if (synchronous.booleanValue()) {
            return RspUtil.aggregate(rspList);
        }
        return null;
    }

    @Override
    public <T> Set<T> removeFromSetAttribute(String key, Collection<T> items, Boolean synchronous) {
        RspList rspList;
        if (StringUtils.isBlank((String)key)) {
            return synchronous != false ? Collections.emptySet() : null;
        }
        if (!PropertyInfo.isAdaptiveClusteringEnabled()) {
            Vector<Address> nodes = this.nodeIndexRegistry.getAddresses(null);
            rspList = this.callRemoteMethods(nodes, REMOVE_FROM_SET_ATTR_NAME, REMOVE_FROM_SET_ATTR_SIG, (boolean)synchronous, this.rpcResponseMode, null, 1000, key, items);
        } else {
            rspList = this.callRemoteMethods(REMOVE_FROM_SET_ATTR_NAME, REMOVE_FROM_SET_ATTR_SIG, key, (boolean)synchronous, ReplicationMode.ASYNC, key, items);
        }
        if (synchronous.booleanValue()) {
            return RspUtil.aggregate(rspList);
        }
        return null;
    }

    @Override
    public <T> Set<T> getSetAttribute(String key) {
        if (StringUtils.isBlank((String)key)) {
            return Collections.emptySet();
        }
        RspList rspList = this.callRemoteMethods(GET_SET_ATTR_NAME, GET_SET_ATTR_SIG, key, true, ReplicationMode.ASYNC, key);
        return RspUtil.aggregate(rspList);
    }

    @Override
    public int getAttributeMapSize() {
        return this.interReqStateMgmtMap.getAttributeMapSize();
    }

    @Override
    public int getTransactionStateMapSize() {
        return this.interReqStateMgmtMap.getTransactionStateMapSize();
    }

    protected String getAttrPartitionKey(HttpServletRequest req, HttpServletResponse resp) {
        return StateMgmtFactory.getSri(req, resp);
    }

    protected boolean isEnableLocalReadOptimization() {
        return this.configStore.getBooleanValue("EnableLocalReadOptimization", true);
    }

    public static interface RpcTarget {
        public void saveState(String var1, State var2);

        public State retrieveState(String var1);

        public State retrieveAndRemoveState(String var1);

        public void setAttr(String var1, String var2, String var3, Object var4);

        public Object getAttr(String var1, String var2);

        public Map<String, Object> getAttrs(String var1);

        public Object removeAttr(String var1, String var2);

        public <T> Set<T> addToSetAttr(String var1, Collection<T> var2);

        public <T> Set<T> removeFromSetAttr(String var1, Collection<T> var2);

        public <T> Set<T> getSetAttr(String var1);
    }
}

