/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.jgroups.JGUtil;
import com.pingidentity.jgroups.MembershipListenerStub;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.MergeView;
import org.jgroups.View;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.mgmt.AdminNodeConfigManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;
import org.sourceid.saml20.service.impl.grouprpc.BaseGroupRpc;
import org.sourceid.saml20.service.impl.grouprpc.PreferredNodeGroup;
import org.sourceid.saml20.service.impl.grouprpc.QuietRpc;
import org.sourceid.saml20.service.util.Node;
import org.sourceid.saml20.service.util.NodeIndex;
import org.sourceid.saml20.service.util.NodeIndexRegistry;
import org.sourceid.saml20.service.util.NodeIndexRegistryListener;
import org.sourceid.saml20.state.StateAccepter;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.util.SystemUtil;

public class NodeIndexRegistryGroupRpcImpl
extends BaseGroupRpc
implements NodeIndexRegistry {
    private static Log log = LogFactory.getLog(NodeIndexRegistryGroupRpcImpl.class);
    private static final String REGISTRY_SYNC_INTERVAL_SECS = "RegistrySyncIntervalSecs";
    private static final String REGISTER_ON_STARTUP = "RegisterOnStartup";
    private static final String REGISTER_NAME = "register";
    private static final Class<?>[] REGISTER_SIG = new Class[]{Node.class};
    private static final String REGISTER_QUIET_NAME = "registerQuiet";
    private static final Class<?>[] REGISTER_QUIET_SIG = new Class[]{Node.class};
    private static final String REGISTER_ALL_NAME = "registerAll";
    private static final Class<?>[] REGISTER_ALL_SIG = new Class[]{Collection.class};
    private final AdminNodeConfigManager adminNodeConfigManager;
    private ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.saml20.service.impl.grouprpc.NodeIndexRegistryGroupRpcImpl");
    private Registry registry;
    private volatile boolean localNodeStateTracking = false;
    private int localNodeIndex = -1;
    private volatile Node.ReplicationStatus currentReplicationStatus = Node.ReplicationStatus.IDLE;

    public NodeIndexRegistryGroupRpcImpl() {
        super(ModeSupport.isDistributable());
        this.adminNodeConfigManager = MgmtFactory.getAdminNodeConfigManager();
        if (ModeSupport.isStandalone()) {
            log.debug((Object)"NodeIndexRegistryGroupRpcImpl is running in standalone mode");
            return;
        }
        this.registry = (Registry)this.muxRpcDispatcherMgr.getRpcInvocationTarget(RpcTarget.class);
        this.registry.validateIdpSessionRegistryNodeGroup(this.getLocalIdpSessionRegistryNodeGroup());
        this.allocateNodeIndex(this.rpcDispatcher.getChannel().getAddress());
        this.validateNoOtherActiveConsoles();
        this.muxRpcDispatcherMgr.addMembershipListener(new CleanUpListener());
        if (this.configStore.getBooleanValue(REGISTER_ON_STARTUP, true)) {
            log.info((Object)("Attempting to register my index: " + this.localNodeIndex + ". Current known index registry: " + this.registry));
            this.register(true);
        }
        MgmtFactory.getSingleThreadedExecutor().scheduleWithFixedDelay(this::periodicRegistrySync, this.getRegistrySyncIntervalSecs(), this.getRegistrySyncIntervalSecs(), TimeUnit.SECONDS);
    }

    private void validateNoOtherActiveConsoles() {
        if (this.adminNodeConfigManager.isEnabled() && this.adminNodeConfigManager.isActiveNode()) {
            ArrayList<Node> activeConsoles = new ArrayList<Node>();
            for (Node node : this.registry.getNodes()) {
                if (!node.isConsole() || !node.isActiveConsole() || node.getIndex() == this.localNodeIndex) continue;
                activeConsoles.add(node);
            }
            if (!activeConsoles.isEmpty()) {
                String msg = "Only one active console is allowed, but there are other active consoles found: " + activeConsoles;
                SystemUtil.hardShutdown(msg);
            }
        }
    }

    @Override
    public int getLocalNodeIndex() {
        return this.localNodeIndex;
    }

    @Override
    public Address getLocalNodeAddress() {
        return this.getAddress(this.localNodeIndex);
    }

    @Override
    public void addListener(NodeIndexRegistryListener listener) {
        this.registry.addListener(listener);
    }

    @Override
    public boolean isLocalNodeStateTracking() {
        return this.localNodeStateTracking;
    }

    @Override
    public void setLocalNodeStateTracking(boolean stateTracking) {
        if (this.localNodeStateTracking != stateTracking) {
            log.debug((Object)("Setting localNodeStateTracking to " + stateTracking));
            this.localNodeStateTracking = stateTracking;
            if (this.configStore.getBooleanValue(REGISTER_ON_STARTUP, true)) {
                this.asyncRegister();
            }
        }
    }

    @Override
    public PreferredNodeGroup getIdpSessionRegistryNodeGroup(String groupId) {
        return this.registry.getIdpSessionRegistryNodeGroup(groupId);
    }

    @Override
    public Address getAddress(int index) {
        Node holder = this.registry.get(index);
        return holder == null ? null : holder.getAddress();
    }

    @Override
    public Vector<Address> getAddresses(int[] indices) {
        Vector<Address> addresses;
        if (indices != null && indices.length > 0) {
            addresses = new Vector(indices.length);
            for (int idx : indices) {
                Node node = this.registry.get(idx);
                if (node == null) continue;
                addresses.add(node.getAddress());
            }
        } else {
            addresses = new Vector<Address>(this.registry.size());
            for (Address address : this.getViewAddresses()) {
                Node node = this.registry.getByAddress(address);
                if (node == null || node.isConsole()) continue;
                addresses.add(address);
            }
        }
        return addresses;
    }

    @Override
    public List<Node> getNodes() {
        return this.registry.getNodes();
    }

    @Override
    public Set<Node> getAdminNodes() {
        return this.registry.getNodes().stream().filter(node -> {
            if (this.adminNodeConfigManager.isEnabled()) {
                return node.isConsole() && node.isActiveConsole();
            }
            return node.isConsole();
        }).collect(Collectors.toSet());
    }

    @Override
    public Node getNode(Address addr) {
        return this.registry.getByAddress(addr);
    }

    @Override
    public void reregister() {
        this.register(true);
    }

    protected void periodicRegistrySync() {
        try {
            this.register(false);
            if (JGUtil.isLead(this.rpcDispatcher.getChannel())) {
                this.registerAll();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error during node registry synchronization", (Throwable)e);
        }
    }

    protected void registerAll() {
        Address localAddress = this.rpcDispatcher.getChannel().getAddress();
        if (localAddress != null) {
            List<Object> members = this.getViewAddresses();
            if (!(members = members.stream().filter(address -> !address.equals(localAddress)).collect(Collectors.toList())).isEmpty()) {
                log.trace((Object)"Broadcasting current registry state");
                this.callRemoteMethods(new Vector<Object>(members), REGISTER_ALL_NAME, (Class[])REGISTER_ALL_SIG, false, 0, BaseGroupRpc.LogLevel.TRACE, this.registry.getNodes());
            }
        } else {
            log.error((Object)"Unable to broadcast registry state because my local address is null");
        }
    }

    protected void register(boolean broadcast) {
        Address localAddress = this.rpcDispatcher.getChannel().getAddress();
        if (localAddress != null) {
            String channelName = this.rpcDispatcher.getChannel().getName();
            String version = PropertyInfo.getPingFederateVersion();
            String nodeTags = String.join((CharSequence)" ", PropertyInfo.getPingFederateNodeTags());
            Mediator mediator = MgmtFactory.getMediator();
            Node node = new Node(this.localNodeIndex, localAddress, mediator.getMode(), StringUtils.trim((String)PropertyInfo.getProvisionerMode()), channelName, this.getLocalIdpSessionRegistryNodeGroup(), this.localNodeStateTracking, StateMgmtFactory.getAdaptiveClusteringConfig().getNodeGroupId(), version, nodeTags, mediator.getConfigPublishDate(), this.currentReplicationStatus, this.adminNodeConfigManager.getSyncState(), this.adminNodeConfigManager.getRole(), this.adminNodeConfigManager.getRoleLastUpdateDate());
            Object[] args = new Object[]{node};
            if (broadcast) {
                log.debug((Object)"Sending my node information to the cluster");
                this.callRemoteMethods(REGISTER_NAME, REGISTER_SIG, false, 0, args);
            } else {
                Address coord = this.getCoord();
                if (coord != null) {
                    log.trace((Object)"Sending my node information to the coordinator");
                    Vector<Address> targets = new Vector<Address>();
                    targets.add(coord);
                    this.callRemoteMethods(targets, REGISTER_QUIET_NAME, (Class[])REGISTER_QUIET_SIG, false, 0, BaseGroupRpc.LogLevel.TRACE, args);
                }
            }
        } else {
            log.error((Object)"Unable to send my node information because my local address is null");
        }
    }

    @Override
    public void setLocalNodeReplicationStatus(Node.ReplicationStatus nodeStatus) {
        if (Node.ReplicationStatus.IDLE.equals((Object)nodeStatus) || !Node.ReplicationStatus.FAILED.equals((Object)this.currentReplicationStatus)) {
            this.currentReplicationStatus = nodeStatus;
            this.register(true);
        }
    }

    @Override
    public Node.ReplicationStatus getLocalNodeReplicationStatus() {
        Node node = this.registry.get(this.localNodeIndex);
        return node == null ? null : node.getReplicationStatus();
    }

    private int getRegistrySyncIntervalSecs() {
        return this.configStore.getIntValue(REGISTRY_SYNC_INTERVAL_SECS, 60);
    }

    private void allocateNodeIndex(Address localAddress) {
        int configuredNodeIndex = NodeIndex.getConfiguredNodeIndex();
        if (configuredNodeIndex > -1) {
            this.localNodeIndex = configuredNodeIndex;
        } else {
            String addressString = null;
            if (localAddress != null) {
                addressString = localAddress.toString();
            } else {
                log.warn((Object)"Unable to determine local address for node index");
            }
            int candidate = NodeIndex.generateCandidateNodeIndex(addressString, false);
            while (this.registry.get(candidate) != null) {
                candidate = NodeIndex.generateCandidateNodeIndex(addressString, true);
            }
            this.localNodeIndex = candidate;
            log.debug((Object)("Allocated node index " + this.localNodeIndex));
        }
    }

    private PreferredNodeGroup getLocalIdpSessionRegistryNodeGroup() {
        return StateMgmtFactory.getIdpSessionRegistry().getPreferredNodeGroup();
    }

    private void asyncRegister() {
        Thread t = new Thread(() -> {
            try {
                this.register(true);
            }
            catch (Exception e) {
                log.error((Object)"Unable to re-register my index.", (Throwable)e);
            }
        });
        t.start();
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    public static class Registry
    implements RpcTarget,
    StateAccepter,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Map<Integer, Node> map = new HashMap<Integer, Node>();
        private transient Set<NodeIndexRegistryListener> listeners = new HashSet<NodeIndexRegistryListener>();

        public synchronized void addListener(NodeIndexRegistryListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public synchronized void setState(StateAccepter other) {
            Registry otherRegistry = (Registry)other;
            this.map.putAll(otherRegistry.map);
            this.notifyRegistryChanged();
        }

        @Override
        public synchronized void registerQuiet(Node node) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Received register request from node: " + node));
            }
            this.doRegister(node);
        }

        @Override
        public synchronized void register(Node node) {
            log.debug((Object)("Received register request from node: " + node));
            this.doRegister(node);
        }

        @Override
        public synchronized void registerAll(Collection<Node> nodes) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Received current registry from coordinator: " + nodes));
            }
            boolean doNotify = false;
            for (Node node : nodes) {
                boolean changeOccurred = this.registerNode(node);
                doNotify = doNotify || changeOccurred;
            }
            List<Integer> toRemove = this.map.keySet().stream().filter(index -> !nodes.stream().anyMatch(node -> node.getIndex() == index.intValue())).collect(Collectors.toList());
            doNotify = doNotify || !toRemove.isEmpty();
            this.removeAll(toRemove);
            if (doNotify) {
                this.notifyRegistryChanged();
            }
        }

        public synchronized Node get(int idx) {
            return this.map.get(idx);
        }

        public synchronized int size() {
            return this.map.size();
        }

        public synchronized List<Node> getNodes() {
            return new ArrayList<Node>(this.map.values());
        }

        public synchronized Collection<Address> getAddresses() {
            HashSet<Address> addresses = new HashSet<Address>();
            for (Node node : this.map.values()) {
                addresses.add(node.getAddress());
            }
            return addresses;
        }

        public synchronized Node getByAddress(Address address) {
            if (address == null) {
                return null;
            }
            return this.map.values().stream().filter(node -> address.equals(node.getAddress())).findFirst().orElse(null);
        }

        public synchronized void handleViewUpdate(View view) {
            Collection<Node> currNodes = this.map.values();
            log.debug((Object)("Handling view update, current registry content: " + this.map));
            List members = view.getMembers();
            ArrayList<Integer> removedIndexes = new ArrayList<Integer>();
            for (Node node : currNodes) {
                if (members.contains(node.getAddress())) continue;
                removedIndexes.add(node.getIndex());
            }
            if (!removedIndexes.isEmpty()) {
                this.removeAll(removedIndexes);
                this.notifyRegistryChanged();
            }
            log.debug((Object)("New registry content: " + this.map));
        }

        public synchronized PreferredNodeGroup getIdpSessionRegistryNodeGroup(String groupId) {
            for (Node node : this.map.values()) {
                PreferredNodeGroup nodeGroup = node.getIdpSessionRegistryNodeGroup();
                if (nodeGroup == null || !nodeGroup.getGroupId().equals(groupId)) continue;
                return nodeGroup;
            }
            return null;
        }

        public synchronized void validateIdpSessionRegistryNodeGroup(PreferredNodeGroup nodeGroup) {
            if (nodeGroup == null) {
                return;
            }
            for (Node node : this.map.values()) {
                HashSet<Integer> set2;
                HashSet<Integer> set1;
                if (node.getIdpSessionRegistryNodeGroup() == null || !node.getIdpSessionRegistryNodeGroup().getGroupId().equals(nodeGroup.getGroupId()) || (set1 = new HashSet<Integer>(nodeGroup.getNodeIndices())).equals(set2 = new HashSet<Integer>(node.getIdpSessionRegistryNodeGroup().getNodeIndices()))) continue;
                String msg = "The node indices " + set1 + " for group ID " + nodeGroup.getGroupId() + " are different from those already registered in the cluster: " + set2 + ". Please check the preferred node indices in cluster-idp-session-registry.conf.";
                SystemUtil.hardShutdown(msg, null);
            }
        }

        public synchronized String toString() {
            return this.getClass().getSimpleName() + " " + this.map.toString();
        }

        protected synchronized ExecutorService getExecutorService() {
            return MgmtFactory.getSingleThreadedExecutor();
        }

        private synchronized void doRegister(Node node) {
            if (this.registerNode(node)) {
                this.notifyRegistryChanged();
            }
        }

        private synchronized boolean registerNode(Node node) {
            Node previousNode = this.map.get(node.getIndex());
            boolean changeOccurred = true;
            String action = NodeIndexRegistryGroupRpcImpl.REGISTER_NAME;
            if (previousNode != null) {
                action = "update";
                if (node.equals(previousNode)) {
                    changeOccurred = false;
                }
            }
            this.map.put(node.getIndex(), node);
            if (changeOccurred) {
                log.debug((Object)(action + ": " + node.getIndex() + "=" + node + ", registry content is now: " + this.map));
            }
            return changeOccurred;
        }

        private synchronized void removeAll(Collection<Integer> indices) {
            for (int index : indices) {
                this.remove(index);
            }
        }

        private synchronized void remove(int idx) {
            Node node = this.map.remove(idx);
            if (node != null) {
                log.debug((Object)("removed " + idx + "=" + node));
            }
        }

        private synchronized void notifyRegistryChanged() {
            HashSet<NodeIndexRegistryListener> listenersCopy = new HashSet<NodeIndexRegistryListener>(this.listeners);
            this.getExecutorService().execute(() -> {
                for (NodeIndexRegistryListener listener : listenersCopy) {
                    try {
                        listener.onNodeIndexRegistryChanged();
                    }
                    catch (Exception e) {
                        log.error((Object)"Unexpected error notifying listener of node index registry change", (Throwable)e);
                    }
                }
            });
        }
    }

    public static interface RpcTarget {
        public void register(Node var1);

        @QuietRpc
        public void registerQuiet(Node var1);

        @QuietRpc
        public void registerAll(Collection<Node> var1);
    }

    private class CleanUpListener
    extends MembershipListenerStub {
        private CleanUpListener() {
        }

        @Override
        public void viewAccepted(View newView) {
            super.viewAccepted(newView);
            NodeIndexRegistryGroupRpcImpl.this.registry.handleViewUpdate(newView);
            if (newView instanceof MergeView) {
                log.debug((Object)"Re-registering my index as a cluster merge has occurred.");
                NodeIndexRegistryGroupRpcImpl.this.asyncRegister();
            }
        }
    }
}

