/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc;

import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jgroups.Address;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class PreferredNodeGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String groupId;
    private ArrayList<Integer> nodeIndices;

    public PreferredNodeGroup(String groupId, List<Integer> nodeIndices) {
        this.groupId = groupId;
        this.nodeIndices = new ArrayList<Integer>(nodeIndices);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public List<Integer> getNodeIndices() {
        return this.nodeIndices;
    }

    public Vector<Address> getAddresses() {
        return MgmtFactory.getNodeIndexRegistry().getAddresses(Ints.toArray(this.nodeIndices));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.nodeIndices == null ? 0 : this.nodeIndices.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PreferredNodeGroup other = (PreferredNodeGroup)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.nodeIndices == null ? other.nodeIndices != null : !this.nodeIndices.equals(other.nodeIndices));
    }
}

