/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.util.RspList;
import org.sourceid.common.Util;

public class RspUtil {
    private static Log log = LogFactory.getLog(RspUtil.class);

    static <T, V> Map<T, V> aggregateMapRsp(RspList rspList) {
        HashMap aggregation = new HashMap();
        for (Object obj : rspList.getResults()) {
            try {
                Map result = (Map)obj;
                aggregation.putAll(result);
            }
            catch (ClassCastException e) {
                log.debug((Object)("Unexpected type returned in " + rspList + " so ignoring result " + e));
            }
        }
        return aggregation;
    }

    public static <T> Set<T> aggregate(RspList rspList) {
        return RspUtil.aggregate(rspList.getResults());
    }

    static <T> Set<T> aggregate(List results) {
        HashSet aggregation = new HashSet();
        for (Object o : results) {
            try {
                Collection result = (Collection)o;
                aggregation.addAll(result);
            }
            catch (ClassCastException e) {
                log.debug((Object)("Unexpected type returned in " + results + " so ignoring result " + e));
            }
        }
        return aggregation;
    }

    static Collection getFirstNotEmpty(RspList rspList) {
        Object o;
        Collection collection = null;
        Iterator iterator = rspList.getResults().iterator();
        while (iterator.hasNext() && Util.isEmpty(collection = (Collection)(o = iterator.next()))) {
        }
        return collection;
    }

    public static <T> T getFirstNotNull(RspList rspList, Class<T> type) {
        T object = null;
        for (Object o : rspList.getResults()) {
            if (o == null) continue;
            object = type.cast(o);
            break;
        }
        return object;
    }

    public static <T> T getBest(RspList rspList, Comparator<T> comparator, Class<T> type) {
        ArrayList<T> items = new ArrayList<T>(rspList.size());
        for (Object o : rspList.getResults()) {
            if (o == null) continue;
            T item = type.cast(o);
            items.add(item);
        }
        Collections.sort(items, comparator);
        return items.isEmpty() ? null : (T)items.iterator().next();
    }

    public static boolean getAnyTrue(RspList<?> rspList) {
        for (Object o : rspList.getResults()) {
            Boolean currRevoked;
            if (o == null || !(o instanceof Boolean) || !(currRevoked = (Boolean)o).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

