/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc;

import com.pingidentity.jgroups.MembershipListenerStub;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.MergeView;
import org.jgroups.View;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.sourceid.config.ConfigProps;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.RevokedSriInfo;
import org.sourceid.saml20.service.SessionRevocationService;
import org.sourceid.saml20.service.impl.grouprpc.BasePreferredNodesGroupRpc;
import org.sourceid.saml20.service.impl.grouprpc.RspUtil;
import org.sourceid.saml20.service.impl.localmemory.SessionRevocationServiceMapImpl;
import org.sourceid.saml20.service.util.Node;
import org.sourceid.saml20.service.util.NodeIndexRegistry;

public class SessionRevocationServiceGroupRpcImpl
extends BasePreferredNodesGroupRpc
implements SessionRevocationService {
    private static final Log log = LogFactory.getLog(SessionRevocationServiceGroupRpcImpl.class);
    private static final String FILENAME = "cluster-session-revocation.conf";
    private static final String ADD_REVOKED_SRI_NAME = "addRevokedSri";
    private static final Class<?>[] ADD_REVOKED_SRI_SIG = new Class[]{String.class};
    private static final Class<?>[] ADD_REVOKED_SRI_WITH_EXPIRY_SIG = new Class[]{String.class, Long.TYPE};
    private static final String GET_REVOKED_SRI_INFO_NAME = "getRevokedSriInfo";
    private static final Class<?>[] GET_REVOKED_SRI_INFO_SIG = new Class[]{String.class};
    private static final String GET_REVOKED_SRI_INFOS_NAME = "getRevokedSriInfos";
    private static final Class<?>[] GET_REVOKED_SRI_INFOS_SIG = new Class[0];
    private int bulkRevokedSrisTimeoutMillis;
    private boolean readLocalOnly = true;
    private SessionRevocationServiceMapImpl sessionRevocationServiceMapImpl;

    public SessionRevocationServiceGroupRpcImpl() {
        super(FILENAME);
        ConfigProps cfgProps = new ConfigProps(FILENAME);
        this.bulkRevokedSrisTimeoutMillis = cfgProps.getInt("bulk.revoked.sris.timeout", 10000);
        this.readLocalOnly = cfgProps.getBoolean("read.local.only");
        this.sessionRevocationServiceMapImpl = (SessionRevocationServiceMapImpl)this.muxRpcDispatcherMgr.getRpcInvocationTarget(RpcTarget.class);
        if (MgmtFactory.getMediator().isEngine()) {
            this.muxRpcDispatcherMgr.addMembershipListener(new MembershipListenerStub(){

                @Override
                public void viewAccepted(View newView) {
                    if (newView instanceof MergeView) {
                        MergeViewHandler handler = new MergeViewHandler((MergeView)newView);
                        log.debug((Object)"Starting a new thread to process MergeView");
                        Thread thread = new Thread(handler);
                        thread.setDaemon(true);
                        thread.start();
                    }
                }
            });
            this.downloadInitialRevokedSrisList();
        }
    }

    @Override
    public void addRevokedSri(String sri) {
        this.callRemoteMethods(ADD_REVOKED_SRI_NAME, (Class[])ADD_REVOKED_SRI_SIG, false, sri);
    }

    @Override
    public void addRevokedSri(String sri, long lifetimeMs) {
        this.callRemoteMethods(ADD_REVOKED_SRI_NAME, (Class[])ADD_REVOKED_SRI_WITH_EXPIRY_SIG, false, sri, lifetimeMs);
    }

    @Override
    public RevokedSriInfo getRevokedSriInfo(String sri) {
        RevokedSriInfo result = this.sessionRevocationServiceMapImpl.getRevokedSriInfo(sri);
        if (result == null && !this.readLocalOnly) {
            RspList rspList = this.callRemoteMethods(GET_REVOKED_SRI_INFO_NAME, (Class[])GET_REVOKED_SRI_INFO_SIG, true, sri);
            return RspUtil.getFirstNotNull(rspList, RevokedSriInfo.class);
        }
        return result;
    }

    @Override
    public RevokedSriInfo getRevokedSriInfoLocal(String sri) {
        return this.sessionRevocationServiceMapImpl.getRevokedSriInfo(sri);
    }

    private void downloadInitialRevokedSrisList() {
        Address engineAddr = this.findEngineNodeAddress();
        if (engineAddr == null) {
            log.debug((Object)"No engine node available for retrieving initial revoked SRI's list");
        } else {
            log.debug((Object)("Retrieving initial revoked SRI's list from " + engineAddr));
            Vector<Address> targets = new Vector<Address>();
            targets.add(engineAddr);
            this.downloadRevokedSrisList(targets);
        }
    }

    private void downloadRevokedSrisList(Vector<Address> targets) {
        try {
            RspList rspList = this.callRemoteMethods(targets, GET_REVOKED_SRI_INFOS_NAME, (Class[])GET_REVOKED_SRI_INFOS_SIG, true, this.bulkRevokedSrisTimeoutMillis, new Object[0]);
            for (Map.Entry entry : rspList.entrySet()) {
                Rsp rsp = (Rsp)entry.getValue();
                if (rsp.getValue() == null) {
                    log.error((Object)("Failed to retrieve revoked SRI's list from " + entry.getKey()));
                    continue;
                }
                log.debug((Object)("Received " + ((List)rsp.getValue()).size() + " revoked SRI's from " + entry.getKey()));
                this.sessionRevocationServiceMapImpl.importRevokedSriInfos((List)rsp.getValue());
            }
        }
        catch (RuntimeException e) {
            log.error((Object)("Error retrieving revoked SRI's from [" + StringUtils.join(targets, (String)",") + "]"), (Throwable)e);
        }
    }

    private Address findEngineNodeAddress() {
        NodeIndexRegistry nodeIndexRegistry = GlobalRegistry.getService(NodeIndexRegistry.class);
        for (Node node : nodeIndexRegistry.getNodes()) {
            if (node.isConsole() || node.getAddress().equals(this.rpcDispatcher.getChannel().getAddress())) continue;
            return node.getAddress();
        }
        return null;
    }

    public static interface RpcTarget {
        public void addRevokedSri(String var1);

        public void addRevokedSri(String var1, long var2);

        public RevokedSriInfo getRevokedSriInfo(String var1);

        public List<RevokedSriInfo> getRevokedSriInfos();
    }

    private class MergeViewHandler
    implements Runnable {
        private final Log log = LogFactory.getLog(MergeViewHandler.class);
        private MergeView mergeView;

        public MergeViewHandler(MergeView mergeView) {
            this.mergeView = mergeView;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(SessionRevocationServiceGroupRpcImpl.this.preferredNodes.getTimeout() * 2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.log.isDebugEnabled()) {
                this.logMergeViewReceived(this.mergeView);
            }
            NodeIndexRegistry nodeIndexRegistry = GlobalRegistry.getService(NodeIndexRegistry.class);
            Address localAddress = SessionRevocationServiceGroupRpcImpl.this.rpcDispatcher.getChannel().getAddress();
            List subgroups = this.mergeView.getSubgroups();
            Vector<Address> targets = new Vector<Address>();
            block2: for (View subgroup : subgroups) {
                if (subgroup.containsMember(localAddress)) continue;
                for (Address addr : subgroup.getMembers()) {
                    Node node = nodeIndexRegistry.getNode(addr);
                    if (node == null || node.isConsole()) continue;
                    targets.add(node.getAddress());
                    continue block2;
                }
            }
            if (!targets.isEmpty()) {
                this.log.debug((Object)("Retrieving revoked SRI's list from [" + StringUtils.join(targets, (String)",") + "]"));
                SessionRevocationServiceGroupRpcImpl.this.downloadRevokedSrisList(targets);
            }
        }

        private void logMergeViewReceived(MergeView view) {
            ArrayList<CallSite> subgroupStrings = new ArrayList<CallSite>();
            for (View subgroup : view.getSubgroups()) {
                subgroupStrings.add((CallSite)((Object)("[" + StringUtils.join((Collection)subgroup.getMembers(), (String)", ") + "]")));
            }
            this.log.debug((Object)("Processing MergeView: {" + StringUtils.join(subgroupStrings, (String)", ") + "}"));
        }
    }
}

