/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc;

import java.util.Collection;
import java.util.Map;
import org.jgroups.util.RspList;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.service.SpSessionRegistry;
import org.sourceid.saml20.service.WebSsoSession;
import org.sourceid.saml20.service.impl.grouprpc.BasePreferredNodesGroupRpc;
import org.sourceid.saml20.service.impl.grouprpc.ReplicationMode;
import org.sourceid.saml20.service.impl.grouprpc.RspUtil;
import org.sourceid.saml20.service.impl.localmemory.SpSessionRegistryMapImpl;
import org.sourceid.saml20.state.StateMgmtFactory;

public class SpSessionRegistryGroupRpcImpl
extends BasePreferredNodesGroupRpc
implements SpSessionRegistry {
    private static final Class[] REGISTER_SIG = new Class[]{SpHashableAuthnBean.class, WebSsoSession.class};
    private static final String REGISTER_NAME = "registerSessionReceived";
    private static final Class[] UNREGISTER_SIG = new Class[]{Collection.class};
    private static final String UNREGISTER_NAME = "unregisterSessionsReceived";
    private static final Class[] LOOKUP_BEANS_SIG = new Class[]{String.class};
    private static final String LOOKUP_BEANS = "lookupAuthnBeansAndSessions";

    public SpSessionRegistryGroupRpcImpl() throws Exception {
        super("cluster-sp-session-registry.conf", true, StateMgmtFactory.getAdaptiveClusteringConfig().isReplicateSessions());
    }

    @Override
    public void registerSessionReceived(SpHashableAuthnBean authnBean, WebSsoSession session) {
        this.callRemoteMethods(REGISTER_NAME, REGISTER_SIG, false, ReplicationMode.ASYNC, authnBean, session);
    }

    @Override
    public void unregisterSessionsReceived(Collection<SpHashableAuthnBean> authnBeans) {
        this.callRemoteMethods(UNREGISTER_NAME, UNREGISTER_SIG, false, ReplicationMode.ASYNC, authnBeans);
    }

    @Override
    public Map<SpHashableAuthnBean, WebSsoSession> lookupAuthnBeansAndSessions(String sessionIdentifier) {
        RspList rspList = this.callRemoteMethods(LOOKUP_BEANS, LOOKUP_BEANS_SIG, true, ReplicationMode.CACHE_ACCESS, sessionIdentifier);
        return RspUtil.aggregateMapRsp(rspList);
    }

    @Override
    public int getSessionInfoMapSize() {
        SpSessionRegistryMapImpl spSessionRegistryMap = (SpSessionRegistryMapImpl)this.muxRpcDispatcherMgr.getRpcInvocationTarget(SpSessionRegistry.class);
        return spSessionRegistryMap.getSessionInfoMapSize();
    }
}

