/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc.adaptive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.sourceid.saml20.service.StateServiceId;
import org.sourceid.saml20.service.impl.grouprpc.adaptive.DownloadBatch;
import org.sourceid.saml20.service.impl.grouprpc.adaptive.RangeAndReplicas;

public class RangesByService {
    private Map<StateServiceId, List<RangeAndReplicas>> rangesByService = new TreeMap<StateServiceId, List<RangeAndReplicas>>();

    public void addRanges(StateServiceId serviceId, Collection<RangeAndReplicas> rangesAndReplicas) {
        List<RangeAndReplicas> existing = this.rangesByService.get((Object)serviceId);
        if (existing == null) {
            existing = new ArrayList<RangeAndReplicas>();
            this.rangesByService.put(serviceId, existing);
        }
        for (RangeAndReplicas rangeAndReplicas : rangesAndReplicas) {
            this.insert(existing, rangeAndReplicas);
        }
    }

    public DownloadBatch removeDownloadBatch() {
        Iterator<Map.Entry<StateServiceId, List<RangeAndReplicas>>> iterator = this.rangesByService.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<StateServiceId, List<RangeAndReplicas>> entry = iterator.next();
            iterator.remove();
            return new DownloadBatch(entry.getKey(), (Collection<RangeAndReplicas>)entry.getValue());
        }
        return null;
    }

    public boolean isEmpty() {
        return this.rangesByService.isEmpty();
    }

    private void insert(List<RangeAndReplicas> list, RangeAndReplicas rangeAndReplicas) {
        int index = 0;
        for (RangeAndReplicas item : list) {
            if (item.getRange().getStart() > rangeAndReplicas.getRange().getStart()) {
                list.add(index, rangeAndReplicas);
                return;
            }
            ++index;
        }
        list.add(index, rangeAndReplicas);
    }
}

