/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc.adaptive;

import com.pingidentity.common.util.consistent.HashRingNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.service.StateServiceId;
import org.sourceid.saml20.service.impl.grouprpc.adaptive.DownloadBatch;
import org.sourceid.saml20.service.impl.grouprpc.adaptive.RangeAndReplicas;
import org.sourceid.saml20.service.impl.grouprpc.adaptive.RangesByService;

public class RangesToDownload {
    private static final Log log = LogFactory.getLog(RangesToDownload.class);
    private Map<HashRingNode, RangesByService> rangesByNode = new TreeMap<HashRingNode, RangesByService>();

    public void addRanges(StateServiceId serviceId, Collection<RangeAndReplicas> rangesAndReplicas) {
        for (RangeAndReplicas rangeAndReplicas : rangesAndReplicas) {
            if (!rangeAndReplicas.hasReplicas()) {
                log.trace((Object)("No more replicas for service " + serviceId + " and range " + rangeAndReplicas.getRange() + ", range will not be downloaded"));
                continue;
            }
            ArrayList<HashRingNode> replicas = new ArrayList<HashRingNode>(rangeAndReplicas.getReplicas());
            Iterator iterator = replicas.iterator();
            HashRingNode node = (HashRingNode)iterator.next();
            iterator.remove();
            this.addRanges(node, serviceId, Collections.singleton(new RangeAndReplicas(rangeAndReplicas.getRange(), replicas)));
        }
    }

    public void addRanges(HashRingNode node, StateServiceId serviceId, Collection<RangeAndReplicas> rangesAndReplicas) {
        RangesByService rangesByService = this.rangesByNode.get(node);
        if (rangesByService == null) {
            rangesByService = new RangesByService();
            this.rangesByNode.put(node, rangesByService);
        }
        rangesByService.addRanges(serviceId, rangesAndReplicas);
    }

    public void reallocateRanges(HashRingNode node) {
        log.debug((Object)("Reallocating ranges for node " + node));
        RangesByService ranges = this.rangesByNode.remove(node);
        if (ranges != null) {
            DownloadBatch downloadBatch = ranges.removeDownloadBatch();
            while (downloadBatch != null) {
                this.addRanges(downloadBatch.getServiceId(), downloadBatch.getRangesAndReplicas());
                downloadBatch = ranges.removeDownloadBatch();
            }
        }
    }

    public DownloadBatch removeDownloadBatch() {
        Iterator<Map.Entry<HashRingNode, RangesByService>> iterator = this.rangesByNode.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<HashRingNode, RangesByService> entry = iterator.next();
            DownloadBatch result = entry.getValue().removeDownloadBatch();
            if (entry.getValue().isEmpty()) {
                iterator.remove();
            }
            result.setNode(entry.getKey());
            return result;
        }
        return null;
    }
}

