/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc.lock;

import com.pingidentity.jgroups.NodeAddress;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.impl.grouprpc.BaseGroupRpc;
import org.sourceid.saml20.service.impl.grouprpc.MockRpcDispatcher;
import org.sourceid.saml20.service.impl.grouprpc.lock.ClusterLockClient;
import org.sourceid.saml20.service.impl.grouprpc.lock.ClusterLockConfig;
import org.sourceid.saml20.service.impl.grouprpc.lock.ClusterLockServerRpcs;

@SuppressFBWarnings(value={"MS_PKGPROTECT"})
public class ClusterLockServer
extends BaseGroupRpc
implements ClusterLockServerRpcs {
    public static final String REQUEST_LOCK = "requestLock";
    public static final Class<?>[] REQUEST_LOCK_SIG = new Class[]{NodeAddress.class, String.class, Boolean.class};
    public static final String RELEASE_LOCK = "releaseLock";
    public static final Class<?>[] RELEASE_LOCK_SIG = new Class[]{NodeAddress.class, String.class};
    private Map<String, LockInfo> locks = new HashMap<String, LockInfo>();
    private Clock clock = Clock.systemDefaultZone();
    private ClusterLockConfig lockConfig = new ClusterLockConfig();

    public ClusterLockServer() {
        super(false);
        new ScanForExpiredLocksTask().schedule();
    }

    public ClusterLockServer(MockRpcDispatcher mockRpcDispatcher) {
        super(mockRpcDispatcher);
    }

    @Override
    public synchronized void requestLock(NodeAddress nodeAddr, String lockName, Boolean grantRequired) {
        Address requester = nodeAddr.getAddress();
        if (grantRequired.booleanValue()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Lock " + lockName + " requested by " + requester));
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Lock " + lockName + " refreshed by " + requester));
        }
        boolean granted = false;
        LockInfo lockInfo = this.locks.get(lockName);
        if (lockInfo != null) {
            if (lockInfo.getOwner().getAddress().equals(requester)) {
                lockInfo.getOwner().updateRefreshTime();
                granted = true;
            } else {
                lockInfo.addRequester(requester);
            }
        } else {
            lockInfo = new LockInfo(lockName, requester);
            this.locks.put(lockName, lockInfo);
            granted = true;
        }
        if (granted && grantRequired.booleanValue()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Lock " + lockName + " granted to " + requester));
            }
            this.sendLockRequestGrantedRpc(requester, lockName);
        }
    }

    @Override
    public synchronized void releaseLock(NodeAddress nodeAddr, String lockName) {
        Address requester = nodeAddr.getAddress();
        LockInfo lockInfo = this.locks.get(lockName);
        if (lockInfo == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Lock " + lockName + ": release requested by " + requester + " but lock is already released"));
            }
            return;
        }
        if (!lockInfo.getOwner().getAddress().equals(requester)) {
            if (lockInfo.removeRequester(requester)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Lock " + lockName + ": removed pending request for " + requester));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Lock " + lockName + ": release requested by " + requester + ", but requester does not own lock and no pending request found"));
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Lock " + lockName + " released by " + requester));
        }
        this.doReleaseLock(lockInfo);
    }

    public synchronized void scanForExpiredLocks() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Scanning for expired locks");
        }
        ArrayList<LockInfo> toRelease = new ArrayList<LockInfo>();
        for (LockInfo info : this.locks.values()) {
            if (!info.getOwner().isRequestValid()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Lock " + info.getLockName() + " has not been refreshed by owner " + info.getOwner() + " for " + info.getOwner().millisSinceRefresh() + " milliseconds and will be released"));
                }
                toRelease.add(info);
                continue;
            }
            if (this.getViewAddresses().contains(info.getOwner().getAddress())) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Owner " + info.getOwner() + " is no longer in cluster, lock " + info.getLockName() + " will be released"));
            }
            toRelease.add(info);
        }
        for (LockInfo expiredInfo : toRelease) {
            this.doReleaseLock(expiredInfo);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Finished scanning for expired locks");
        }
    }

    protected synchronized void setClock(Clock clock) {
        this.clock = clock;
    }

    protected synchronized boolean hasLocks() {
        return !this.locks.isEmpty();
    }

    protected void doReleaseLock(LockInfo lockInfo) {
        RequesterInfo requester = lockInfo.removeFirstRequester();
        if (requester == null) {
            this.locks.remove(lockInfo.getLockName());
            return;
        }
        lockInfo.setOwner(requester);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Lock " + lockInfo.getLockName() + " granted to " + lockInfo.getOwner()));
        }
        this.sendLockRequestGrantedRpc(lockInfo.getOwner().getAddress(), lockInfo.getLockName());
    }

    protected void sendLockRequestGrantedRpc(Address address, String lockName) {
        Vector<Address> nodes = new Vector<Address>();
        nodes.add(address);
        this.callRemoteMethods(nodes, "lockRequestGranted", (Class[])ClusterLockClient.LOCK_REQUEST_GRANTED_SIG, false, 0, lockName);
    }

    private class ScanForExpiredLocksTask
    implements Runnable {
        private ScanForExpiredLocksTask() {
        }

        @Override
        public void run() {
            try {
                ClusterLockServer.this.scanForExpiredLocks();
            }
            catch (Throwable t) {
                ClusterLockServer.this.log.error((Object)"Error while scanning for expired locks", t);
            }
            this.schedule();
        }

        public void schedule() {
            MgmtFactory.getSingleThreadedExecutor().schedule(this, ClusterLockServer.this.lockConfig.getLockCheckIntervalMillis(), TimeUnit.MILLISECONDS);
        }
    }

    protected class RequesterInfo {
        private Address address;
        private long refreshTime;

        public RequesterInfo(Address address) {
            this.refreshTime = ClusterLockServer.this.clock.millis();
            this.address = address;
        }

        public Address getAddress() {
            return this.address;
        }

        public void updateRefreshTime() {
            this.refreshTime = ClusterLockServer.this.clock.millis();
        }

        public boolean isRequestValid() {
            return this.millisSinceRefresh() < (long)ClusterLockServer.this.lockConfig.getLockExpiryCheckIntervals() * ClusterLockServer.this.lockConfig.getLockCheckIntervalMillis();
        }

        public long millisSinceRefresh() {
            return ClusterLockServer.this.clock.millis() - this.refreshTime;
        }

        public String toString() {
            return this.address.toString();
        }
    }

    protected class LockInfo {
        private String lockName;
        private RequesterInfo owner;
        private Queue<RequesterInfo> requesters = new LinkedList<RequesterInfo>();

        public LockInfo(String lockName, Address owner) {
            this.lockName = lockName;
            this.owner = new RequesterInfo(owner);
        }

        public String getLockName() {
            return this.lockName;
        }

        public void addRequester(Address address) {
            boolean found = false;
            for (RequesterInfo info : this.requesters) {
                if (!info.getAddress().equals(address)) continue;
                found = true;
                info.updateRefreshTime();
                break;
            }
            if (!found) {
                this.requesters.add(new RequesterInfo(address));
            }
        }

        public boolean removeRequester(Address address) {
            return this.requesters.removeIf(requester -> requester.getAddress().equals(address));
        }

        public RequesterInfo removeFirstRequester() {
            RequesterInfo requester = this.requesters.poll();
            while (requester != null && !requester.isRequestValid()) {
                requester = this.requesters.poll();
            }
            return requester;
        }

        public RequesterInfo getOwner() {
            return this.owner;
        }

        public void setOwner(RequesterInfo owner) {
            this.owner = owner;
        }
    }
}

