/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc.lock;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.service.ClusterLockService;

public class LockRequest {
    private static final Log log = LogFactory.getLog(LockRequest.class);
    private ClusterLockService lockService;
    private String lockName;
    private boolean granted = false;

    public LockRequest(ClusterLockService lockService, String lockName) {
        this.lockService = lockService;
        this.lockName = lockName;
    }

    public synchronized String getLockName() {
        return this.lockName;
    }

    public synchronized void waitForLock() throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Waiting for lock " + this.lockName));
        }
        while (!this.granted) {
            this.wait();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lock " + this.lockName + " was acquired"));
        }
    }

    public synchronized void grantLock() {
        this.granted = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lock " + this.lockName + " was granted"));
        }
        this.notifyAll();
    }

    public synchronized boolean isGranted() {
        return this.granted;
    }

    public synchronized void releaseLock() {
        this.lockService.releaseLock(this.lockName);
    }

    public synchronized void cancel() {
        this.releaseLock();
    }
}

