/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.localmemory;

import com.pingidentity.common.util.Cache;
import com.pingidentity.common.util.CachePurgeBeforeExpiryTracker;
import com.pingidentity.common.util.DistributableCache;
import com.pingidentity.common.util.PropertyInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.time.Clock;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;
import org.sourceid.saml20.service.InterRequestStateMgmt;
import org.sourceid.saml20.service.StateService;
import org.sourceid.saml20.service.StateServiceId;
import org.sourceid.saml20.service.impl.grouprpc.InterRequestStateMgmtGroupRpcImpl;
import org.sourceid.saml20.state.ConsistentHashTracker;
import org.sourceid.saml20.state.SizeLimitProps;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateAccepter;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.websso.servlet.ExtendedSessionIdListener;
import org.sourceid.websso.servlet.ExtendedSessionIdManager;
import org.sourceid.websso.servlet.SessionIdUtil;

public class InterReqStateMgmtMapImpl
implements InterRequestStateMgmt,
StateAccepter,
Serializable,
InterRequestStateMgmtGroupRpcImpl.RpcTarget,
ExtendedSessionIdListener {
    private static final long serialVersionUID = 1L;
    private static final int BIG = 1000;
    private static final float LOAD_FACTOR = 0.75f;
    private transient Log log = LogFactory.getLog(this.getClass());
    protected StateMap keyToStateMap;
    private static final int MIN_STACK_DEPTH = 1;
    static final String SET_ATTRIBUTE_NAME = "set.attribute";
    private int maxStackDepth;
    private int maxSessionAttrs;
    protected AttributeMap attributeMap;
    private SessionIdUtil sessionIdUtil;
    private long tombstoneStorageMillis;
    private long tombstoneCleanupIntervalMillis;
    private Clock clock = Clock.systemDefaultZone();
    private SizeLimitProps sizeLimitProps = new SizeLimitProps();

    public InterReqStateMgmtMapImpl() {
        int maxSizeState = this.sizeLimitProps.getIrsmMaxSizeStateMap();
        int maxSizeAttrs = this.sizeLimitProps.getIrsmMaxSizeAttrMap();
        int depth = this.sizeLimitProps.getIrsmMaxDepthStateStack();
        int maxSessionAttrs = this.sizeLimitProps.getIrsmMaxSessionAttrs();
        int expiryPeriodMinsStateMap = this.sizeLimitProps.getIrsmExpiryMinsStateMap();
        int expiryPeriodMinsAttrMap = this.sizeLimitProps.getIrsmExpiryMinsAttrMap();
        int tombstoneStorageMins = this.sizeLimitProps.getIrsmTombstoneRetentionMins();
        int tombstoneCleanupIntervalMins = this.sizeLimitProps.getIrsmTombstoneCleanupIntervalMins();
        this.initialize(maxSizeState, maxSizeAttrs, depth, maxSessionAttrs, expiryPeriodMinsStateMap, expiryPeriodMinsAttrMap, SessionIdUtil.getInstance(), StateMgmtFactory.makeConsistentHashTracker(true, true), StateMgmtFactory.makeConsistentHashTracker(false, true), tombstoneStorageMins, tombstoneCleanupIntervalMins);
    }

    public InterReqStateMgmtMapImpl(int maxSize1, int maxSize2, int stackDepth, int maxSessionAttrs, int expiryPeriodMinsStateMap, int expiryPeriodMinsAttrMap, SessionIdUtil sessionIdUtil, ConsistentHashTracker stateStackTracker, ConsistentHashTracker attrTracker, int tombstoneStorageMins, int tombstoneCleanupIntervalMins) {
        this.initialize(maxSize1, maxSize2, stackDepth, maxSessionAttrs, expiryPeriodMinsStateMap, expiryPeriodMinsAttrMap, sessionIdUtil, stateStackTracker, attrTracker, tombstoneStorageMins, tombstoneCleanupIntervalMins);
    }

    private void initialize(int maxSizeState, int maxSizeAttrs, int stackDepth, int maxSessionAttrs, int expiryPeriodMinsStateMap, int expiryPeriodMinsAttrMap, SessionIdUtil sessionIdUtil, ConsistentHashTracker stateStackTracker, ConsistentHashTracker attrTracker, int tombstoneStorageMins, int tombstoneCleanupIntervalMins) {
        ExtendedSessionIdManager.getInstance().addListener(this);
        this.sessionIdUtil = sessionIdUtil;
        if (stackDepth < 1) {
            this.log.debug((Object)("configured max state stack depth (" + stackDepth + ") must be >= 1"));
            stackDepth = 1;
        }
        this.maxStackDepth = stackDepth;
        this.maxSessionAttrs = maxSessionAttrs;
        this.log.debug((Object)("max state stack depth: " + this.maxStackDepth));
        this.log.debug((Object)("max state entries: " + maxSizeState + " max attribute entries: " + maxSizeAttrs));
        this.log.debug((Object)("max attributes per entry: " + this.maxSessionAttrs));
        this.keyToStateMap = new StateMap((long)expiryPeriodMinsStateMap * 60L * 1000L, maxSizeState, this.sizeLimitProps.getStatsLogIntervalMins(), stateStackTracker);
        this.attributeMap = new AttributeMap((long)expiryPeriodMinsAttrMap * 60L * 1000L, maxSizeAttrs, this.sizeLimitProps.getStatsLogIntervalMins(), attrTracker);
        this.tombstoneStorageMillis = TimeUnit.MINUTES.toMillis(tombstoneStorageMins);
        this.tombstoneCleanupIntervalMillis = TimeUnit.MINUTES.toMillis(tombstoneCleanupIntervalMins);
        StateMgmtFactory.getStateServiceRegistry().registerService(new AttributeStateService());
        StateMgmtFactory.getStateServiceRegistry().registerService(new StateStackStateService());
    }

    @Override
    public void saveState(String stateKey, State state) {
        this.saveState(stateKey, state, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveState(String stateKey, State state, HttpServletRequest req, HttpServletResponse resp) {
        StateMap stateMap = this.keyToStateMap;
        synchronized (stateMap) {
            ArrayDeque<State> stack = (ArrayDeque<State>)this.keyToStateMap.get(stateKey);
            if (stack == null) {
                stack = new ArrayDeque<State>();
                this.keyToStateMap.put(stateKey, stack);
            }
            stack.push(state);
            if (stack.size() > this.maxStackDepth) {
                stack.removeLast();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public State retrieveState(String stateKey) {
        StateMap stateMap = this.keyToStateMap;
        synchronized (stateMap) {
            State state = null;
            Deque stack = (Deque)this.keyToStateMap.getIfNotExpired(stateKey);
            if (stack != null) {
                state = (State)stack.peek();
            }
            return state;
        }
    }

    @Override
    public State retrieveAndRemoveState(String stateKey) {
        return this.retrieveAndRemoveState(stateKey, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public State retrieveAndRemoveState(String stateKey, HttpServletRequest req, HttpServletResponse resp) {
        StateMap stateMap = this.keyToStateMap;
        synchronized (stateMap) {
            State state = null;
            Deque stack = (Deque)this.keyToStateMap.getIfNotExpired(stateKey);
            if (stack != null) {
                state = (State)stack.pop();
                if (stack.isEmpty()) {
                    this.keyToStateMap.remove(stateKey);
                }
            }
            return state;
        }
    }

    @Override
    public void setState(StateAccepter other) {
        this.setState((InterReqStateMgmtMapImpl)other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(InterReqStateMgmtMapImpl other) {
        Serializable serializable;
        Serializable serializable2 = this;
        synchronized (serializable2) {
            serializable = other;
            synchronized (serializable) {
                this.attributeMap.clear();
                this.attributeMap.putAll(other.attributeMap);
            }
        }
        serializable2 = this.keyToStateMap;
        synchronized (serializable2) {
            serializable = other.keyToStateMap;
            synchronized (serializable) {
                this.keyToStateMap.clear();
                this.keyToStateMap.putAll(other.keyToStateMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String toString() {
        StateMap stateMap = this.keyToStateMap;
        synchronized (stateMap) {
            return this.getClass().getSimpleName() + ", state map size: " + this.keyToStateMap.size() + ", attributes map size: " + this.attributeMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttr(String oldKey, String newKey, String attrName, Object value) {
        InterReqStateMgmtMapImpl interReqStateMgmtMapImpl = this;
        synchronized (interReqStateMgmtMapImpl) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("setAttr(oldKey: " + this.sessionIdUtil.hashIdForLog(oldKey) + ", newKey: " + this.sessionIdUtil.hashIdForLog(newKey) + ", name: " + attrName + ")"));
            }
            this.cleanTombstones(oldKey);
            AttributeInfo attributeInfo = (AttributeInfo)this.attributeMap.remove(oldKey);
            if (attributeInfo == null) {
                attributeInfo = new AttributeInfo();
            }
            this.putInAttrMap(newKey, attributeInfo);
            this.putInSessionAttrMap(attributeInfo.getAttributes(), attrName, value);
            attributeInfo.getTombstones().remove(attrName);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("setAttr: new size of attribute map=" + this.attributeMap.size()));
            }
        }
        ExtendedSessionIdManager.getInstance().notifyExtendedSessionIdUpdated(this, oldKey, newKey);
    }

    @Override
    public synchronized void onExtendedSessionIdUpdated(ExtendedSessionIdListener sender, String oldKey, String newKey) {
        AttributeInfo attributeInfo;
        if (sender.equals(this)) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("onExtendedSessionIdUpdated(oldKey: " + this.sessionIdUtil.hashIdForLog(oldKey) + ", newKey: " + this.sessionIdUtil.hashIdForLog(newKey) + ")"));
        }
        if ((attributeInfo = (AttributeInfo)this.attributeMap.remove(oldKey)) != null) {
            this.attributeMap.put(newKey, attributeInfo);
        }
    }

    private void putInAttrMap(String newKey, AttributeInfo attributeInfo) {
        if (newKey != null) {
            this.attributeMap.put(newKey, attributeInfo);
        }
    }

    @Override
    public void setAttribute(String name, Object value, HttpServletRequest req, HttpServletResponse resp, boolean usedAsLoginCtx) {
        String[] keys = this.getKeys(req, resp, usedAsLoginCtx);
        this.setAttr(keys[0], keys[1], name, value);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.setAttr(key, key, "default.name", value);
    }

    @Override
    public <T> Set<T> addToSetAttribute(String key, Collection<T> items, Boolean synchronous) {
        Set<T> result = this.addToSetAttr(key, items);
        return synchronous != false ? result : null;
    }

    @Override
    public <T> Set<T> removeFromSetAttribute(String key, Collection<T> items, Boolean synchronous) {
        Set<T> result = this.removeFromSetAttr(key, items);
        return synchronous != false ? result : null;
    }

    @Override
    public <T> Set<T> getSetAttribute(String key) {
        return this.getSetAttr(key);
    }

    @Override
    public synchronized <T> Set<T> addToSetAttr(String key, Collection<T> items) {
        LinkedList list;
        Object existingObj = this.getAttr(key, SET_ATTRIBUTE_NAME);
        if (existingObj == null || !(existingObj instanceof LinkedList)) {
            list = new LinkedList();
            this.setAttr(key, key, SET_ATTRIBUTE_NAME, list);
        } else {
            list = (LinkedList)existingObj;
        }
        this.addToSetAttributeList(list, items);
        return Collections.unmodifiableSet(new HashSet(list));
    }

    private <T> void addToSetAttributeList(LinkedList<T> list, Collection<T> items) {
        for (T item : items) {
            list.remove(item);
            list.addFirst(item);
        }
        while (list.size() > this.sizeLimitProps.getIrsmMaxItemsInSetAttribute()) {
            list.removeLast();
        }
    }

    @Override
    public synchronized <T> Set<T> removeFromSetAttr(String key, Collection<T> items) {
        Object existingObj = this.getAttr(key, SET_ATTRIBUTE_NAME);
        if (existingObj == null || !(existingObj instanceof LinkedList)) {
            return Collections.emptySet();
        }
        LinkedList list = (LinkedList)existingObj;
        list.removeAll(items);
        if (list.isEmpty()) {
            this.removeAttr(key, SET_ATTRIBUTE_NAME);
        }
        return Collections.unmodifiableSet(new HashSet(list));
    }

    @Override
    public synchronized <T> Set<T> getSetAttr(String key) {
        Object existingObj = this.getAttr(key, SET_ATTRIBUTE_NAME);
        if (existingObj == null || !(existingObj instanceof LinkedList)) {
            return Collections.emptySet();
        }
        LinkedList list = (LinkedList)existingObj;
        return Collections.unmodifiableSet(new HashSet(list));
    }

    private synchronized void cleanTombstones(String key) {
        Map.Entry<String, Long> entry;
        Long timestamp;
        if (!this.isAdaptiveClusteringMode()) {
            return;
        }
        AttributeInfo attributeInfo = (AttributeInfo)this.attributeMap.get(key);
        if (attributeInfo == null) {
            return;
        }
        if (attributeInfo.getTombstones().isEmpty() || attributeInfo.getTombtoneLastCheckedTimestamp() + this.tombstoneCleanupIntervalMillis > this.clock.millis()) {
            return;
        }
        Iterator<Map.Entry<String, Long>> entryIterator = attributeInfo.getTombstones().entrySet().iterator();
        while (entryIterator.hasNext() && (timestamp = (entry = entryIterator.next()).getValue()) + this.tombstoneStorageMillis < this.clock.millis()) {
            entryIterator.remove();
        }
        if (attributeInfo.getAttributes().isEmpty() && attributeInfo.getTombstones().isEmpty()) {
            this.attributeMap.remove(key);
        }
        attributeInfo.setTombstoneLastCheckedTimestamp(this.clock.millis());
    }

    private synchronized void putInSessionAttrMap(Map<String, Object> map, String key, Object value) {
        map.put(key, value);
        if (map.size() > this.maxSessionAttrs) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Session attribute map size " + map.size() + " exceeds limit, removing least-recently-accessed entry"));
            }
            map.remove(map.keySet().iterator().next());
        }
    }

    @Override
    public synchronized Object getAttr(String key, String name) {
        this.cleanTombstones(key);
        AttributeInfo attributeInfo = (AttributeInfo)this.attributeMap.get(key);
        Object attr = null;
        if (attributeInfo != null) {
            attr = attributeInfo.getAttributes().get(name);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getAttr(key: " + this.sessionIdUtil.hashIdForLog(key) + ", name: " + name + ")"));
        }
        return attr;
    }

    @Override
    public synchronized Map<String, Object> getAttrs(String key) {
        this.cleanTombstones(key);
        Map<String, Object> result = Collections.emptyMap();
        AttributeInfo attributeInfo = (AttributeInfo)this.attributeMap.get(key);
        if (attributeInfo != null) {
            result = new HashMap<String, Object>(attributeInfo.getAttributes());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getAttrs(key: " + this.sessionIdUtil.hashIdForLog(key) + ") returning " + result.size() + " attrs"));
        }
        return result;
    }

    @Override
    public Object getAttribute(String name, HttpServletRequest req, HttpServletResponse resp) {
        String key = this.getKey(req, resp);
        return key != null ? this.getAttr(key, name) : null;
    }

    @Override
    public Map<String, Object> getAttributes(HttpServletRequest req, HttpServletResponse resp) {
        String key = this.getKey(req, resp);
        return key != null ? this.getAttrs(key) : Collections.emptyMap();
    }

    @Override
    public Object getAttribute(String key) {
        return key != null ? this.getAttr(key, "default.name") : null;
    }

    @Override
    public synchronized Object removeAttr(String key, String attrName) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        Object object = null;
        AttributeInfo attributeInfo = (AttributeInfo)this.attributeMap.get(key);
        if (attributeInfo != null) {
            object = attributeInfo.getAttributes().remove(attrName);
        }
        if (this.isAdaptiveClusteringMode()) {
            if (attributeInfo == null) {
                attributeInfo = new AttributeInfo();
                this.attributeMap.put(key, attributeInfo);
            }
            attributeInfo.getTombstones().put(attrName, this.clock.millis());
        }
        if (attributeInfo != null && attributeInfo.getAttributes().isEmpty() && attributeInfo.getTombstones().isEmpty()) {
            this.attributeMap.remove(key);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Object removeAttr(key: " + this.sessionIdUtil.hashIdForLog(key) + ", name: " + attrName + ")"));
        }
        return object;
    }

    @Override
    public Object removeAttribute(String name, HttpServletRequest req, HttpServletResponse resp) {
        String key = this.getKey(req, resp);
        return this.removeAttr(key, name);
    }

    @Override
    public Object removeAttribute(String key) {
        return key != null ? this.removeAttr(key, "default.name") : null;
    }

    public synchronized void updateCacheAccessTime(String extendedSessionId) {
        AttributeInfo info = (AttributeInfo)this.attributeMap.get(extendedSessionId);
        if (info != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("updateCacheAccessTime(extendedSessionId: " + this.sessionIdUtil.hashIdForLog(extendedSessionId) + ")"));
        }
    }

    public String[] getKeys(HttpServletRequest req, HttpServletResponse resp, boolean doCycle) {
        String oldKey = this.getKey(req, resp);
        String newKey = doCycle || StringUtils.isBlank((String)oldKey) ? this.sessionIdUtil.cycleExtendedSessionId(req, resp) : oldKey;
        return new String[]{oldKey, newKey};
    }

    public String getKey(HttpServletRequest req, HttpServletResponse resp) {
        return this.sessionIdUtil.getExtendedSessionId(req, resp);
    }

    @Override
    public synchronized int getAttributeMapSize() {
        return this.attributeMap.size();
    }

    @Override
    public synchronized int getTransactionStateMapSize() {
        return this.keyToStateMap.size();
    }

    public synchronized void importAttributeRecords(Collection<AttributeEntry> attributeEntries) {
        for (AttributeEntry attributeEntry : attributeEntries) {
            String key = attributeEntry.getKey();
            AttributeInfo attributeInfo = (AttributeInfo)this.attributeMap.get(key);
            if (attributeInfo == null) {
                attributeInfo = new AttributeInfo();
            }
            long timestamp = attributeEntry.getTimestamp();
            long existingTimestamp = this.attributeMap.getTimestampForKey(key);
            if (existingTimestamp > 0L && existingTimestamp > attributeEntry.getTimestamp()) {
                timestamp = existingTimestamp;
            }
            if (!this.attributeMap.tryPutWithTimestamp(key, attributeInfo, timestamp)) continue;
            for (Map.Entry<String, Object> entry : attributeEntry.getValue().entrySet()) {
                Map<String, Object> map = attributeInfo.getAttributes();
                if (attributeInfo.getTombstones().containsKey(entry.getKey())) continue;
                if (map.get(entry.getKey()) == null) {
                    this.putInSessionAttrMap(map, entry.getKey(), entry.getValue());
                    continue;
                }
                if (!entry.getKey().equals(SET_ATTRIBUTE_NAME)) continue;
                Object existingObj = map.get(entry.getKey());
                Object incomingObj = entry.getValue();
                if (!(existingObj instanceof LinkedList) || !(incomingObj instanceof LinkedList)) continue;
                LinkedList existingList = (LinkedList)existingObj;
                LinkedList incomingList = (LinkedList)incomingObj;
                this.addToSetAttributeList(incomingList, existingList);
                this.putInSessionAttrMap(map, entry.getKey(), incomingList);
            }
        }
    }

    public synchronized Collection<AttributeEntry> getAttributeRecords(int startHash, int endHashExclusive) {
        ArrayList<AttributeEntry> result = new ArrayList<AttributeEntry>();
        Collection rangeEntries = this.attributeMap.getEntriesForRange(startHash, endHashExclusive);
        for (Cache.Entry rangeEntry : rangeEntries) {
            AttributeInfo attributeInfo = (AttributeInfo)rangeEntry.getValue();
            if (attributeInfo == null || attributeInfo.getAttributes().isEmpty()) continue;
            AttributeEntry entry = new AttributeEntry(rangeEntry.getKey(), new LinkedHashMap<String, Object>(attributeInfo.getAttributes()), rangeEntry.getTimestamp());
            result.add(entry);
        }
        return result;
    }

    public synchronized void purgeAttributeRecords(int startHash, int endHashExclusive) {
        Collection<String> keys = this.attributeMap.getKeysForRange(startHash, endHashExclusive);
        for (String key : keys) {
            this.attributeMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importStateStackRecords(Collection<StateStackEntry> stateStackEntries) {
        StateMap stateMap = this.keyToStateMap;
        synchronized (stateMap) {
            for (StateStackEntry entry : stateStackEntries) {
                long existingTimestamp = this.keyToStateMap.getTimestampForKey(entry.getKey());
                if (existingTimestamp >= entry.getTimestamp()) continue;
                this.keyToStateMap.tryPutWithTimestamp(entry.getKey(), entry.getStateStack(), entry.getTimestamp());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<StateStackEntry> getStateStackRecords(int startHash, int endHashExclusive) {
        StateMap stateMap = this.keyToStateMap;
        synchronized (stateMap) {
            ArrayList<StateStackEntry> result = new ArrayList<StateStackEntry>();
            Collection rangeEntries = this.keyToStateMap.getEntriesForRange(startHash, endHashExclusive);
            for (Cache.Entry rangeEntry : rangeEntries) {
                Deque stateStack = (Deque)rangeEntry.getValue();
                if (stateStack == null) continue;
                StateStackEntry entry = new StateStackEntry(rangeEntry.getKey(), new ArrayDeque<State>(stateStack), rangeEntry.getTimestamp());
                result.add(entry);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeStateStackRecords(int startHash, int endHashExclusive) {
        StateMap stateMap = this.keyToStateMap;
        synchronized (stateMap) {
            Collection<String> keys = this.keyToStateMap.getKeysForRange(startHash, endHashExclusive);
            for (String key : keys) {
                this.keyToStateMap.remove(key);
            }
        }
    }

    private static DistributableCache.PartitionKeyMapper getPartitionKeyMapper(SessionIdUtil sessionIdUtil) {
        return key -> {
            if (key != null && key.startsWith("KeyValue:")) {
                return key;
            }
            return sessionIdUtil.getSriFromExtendedId(key);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void setClock(Clock clock) {
        this.clock = clock;
        StateMap stateMap = this.keyToStateMap;
        synchronized (stateMap) {
            this.keyToStateMap.setClock(clock);
        }
        this.attributeMap.setClock(clock);
    }

    protected boolean isAdaptiveClusteringMode() {
        return ModeSupport.isDistributable() && PropertyInfo.isAdaptiveClusteringEnabled();
    }

    static class StateStackEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String key;
        private Deque<State> stateStack;
        private long timestamp;

        StateStackEntry(String key, Deque<State> stateStack, long timestamp) {
            this.key = key;
            this.stateStack = stateStack;
            this.timestamp = timestamp;
        }

        public String getKey() {
            return this.key;
        }

        public Deque<State> getStateStack() {
            return this.stateStack;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    static class AttributeEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String key;
        private Map<String, Object> value;
        private long timestamp;

        AttributeEntry(String key, Map<String, Object> value, long timestamp) {
            this.key = key;
            this.value = value;
            this.timestamp = timestamp;
        }

        public String getKey() {
            return this.key;
        }

        public Map<String, Object> getValue() {
            return this.value;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    static class AttributeInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, Object> attributes = new LinkedHashMap<String, Object>(16, 0.75f, true);
        private Map<String, Long> tombstones = new LinkedHashMap<String, Long>();
        private long tombstoneLastCheckedTimestamp;

        AttributeInfo() {
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public Map<String, Long> getTombstones() {
            return this.tombstones;
        }

        public void setTombstoneLastCheckedTimestamp(long timestamp) {
            this.tombstoneLastCheckedTimestamp = timestamp;
        }

        public long getTombtoneLastCheckedTimestamp() {
            return this.tombstoneLastCheckedTimestamp;
        }
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Though it implements Serializable, class is never serialized so non-serializable field is okay")
    static class StateMap
    extends DistributableCache<Deque<State>> {
        private static final long serialVersionUID = 1L;
        private CachePurgeBeforeExpiryTracker purgeBeforeExpiryTracker;

        public StateMap(long expiryPeriodMillis, int maxSize, float purgeLogIntervalMins, ConsistentHashTracker tracker) {
            super(expiryPeriodMillis, maxSize, true, tracker);
            String remedyMessage = "Consider increasing InterReqStateMgmtMapImpl.max.size.state.map or decreasing InterReqStateMgmtMapImpl.expiry.mins.state.map in size-limits.conf. Increasing the size of the map will increase PingFederate heap usage. Decreasing the expiry period will reduce the idle timeout for SSO/SLO transactions.";
            this.purgeBeforeExpiryTracker = new CachePurgeBeforeExpiryTracker(expiryPeriodMillis, "IRSM State Map", remedyMessage, purgeLogIntervalMins, "transaction.state.map.purge.unexpired");
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        protected void onEntryPurged(String key, Deque<State> value, boolean expired, long timestamp) {
            this.purgeBeforeExpiryTracker.checkLogEntriesPurgedBeforeExpiry();
            if (!expired) {
                this.purgeBeforeExpiryTracker.trackEntryPurgedBeforeExpiry(timestamp);
            }
        }
    }

    class AttributeMap
    extends DistributableCache<AttributeInfo> {
        private static final long serialVersionUID = 1L;
        private CachePurgeBeforeExpiryTracker purgeBeforeExpiryTracker;

        public AttributeMap(long expiryPeriodMillis, int maxSize, float purgeLogIntervalMins, ConsistentHashTracker tracker) {
            super(expiryPeriodMillis, maxSize, 1000, 0.75f, true, tracker, InterReqStateMgmtMapImpl.getPartitionKeyMapper(InterReqStateMgmtMapImpl.this.sessionIdUtil));
            String remedyMessage = "Consider increasing InterReqStateMgmtMapImpl.max.size.attr.map or decreasing InterReqStateMgmtMapImpl.expiry.mins.attr.map in size-limits.conf. Increasing the size of the map will increase PingFederate heap usage. Decreasing the expiry period will reduce the maximum idle timeout for adapter session attributes.";
            this.purgeBeforeExpiryTracker = new CachePurgeBeforeExpiryTracker(expiryPeriodMillis, "IRSM Attribute Map", remedyMessage, purgeLogIntervalMins, "session.state.attribute.map.purge.unexpired");
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        protected void onEntryPurged(String key, AttributeInfo value, boolean expired, long timestamp) {
            this.purgeBeforeExpiryTracker.checkLogEntriesPurgedBeforeExpiry();
            if (!expired) {
                this.purgeBeforeExpiryTracker.trackEntryPurgedBeforeExpiry(timestamp);
            }
        }
    }

    public class StateStackStateService
    implements StateService<StateStackEntry> {
        @Override
        public StateServiceId getServiceId() {
            return StateServiceId.INTER_REQUEST_STATE_MGMT_STATE_STACK;
        }

        @Override
        public void importRecords(Collection<StateStackEntry> records) {
            InterReqStateMgmtMapImpl.this.importStateStackRecords(records);
        }

        @Override
        public Collection<StateStackEntry> getRecords(int startHash, int endHashExclusive) {
            return InterReqStateMgmtMapImpl.this.getStateStackRecords(startHash, endHashExclusive);
        }

        @Override
        public void purgeRecords(int startHash, int endHashExclusive) {
            InterReqStateMgmtMapImpl.this.purgeStateStackRecords(startHash, endHashExclusive);
        }
    }

    public class AttributeStateService
    implements StateService<AttributeEntry> {
        @Override
        public StateServiceId getServiceId() {
            return StateServiceId.INTER_REQUEST_STATE_MGMT_ATTRIBUTES;
        }

        @Override
        public void importRecords(Collection<AttributeEntry> records) {
            InterReqStateMgmtMapImpl.this.importAttributeRecords(records);
        }

        @Override
        public Collection<AttributeEntry> getRecords(int startHash, int endHashExclusive) {
            return InterReqStateMgmtMapImpl.this.getAttributeRecords(startHash, endHashExclusive);
        }

        @Override
        public void purgeRecords(int startHash, int endHashExclusive) {
            InterReqStateMgmtMapImpl.this.purgeAttributeRecords(startHash, endHashExclusive);
        }
    }
}

