/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.localmemory;

import com.pingidentity.common.util.SerialHashable;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.common.IDGenerator;
import org.sourceid.saml20.service.PseudonymService;
import org.sourceid.saml20.service.PseudonymServiceException;

public class PseudonymServiceMapImpl
implements PseudonymService {
    private Map<CompositeKey, String> pseudoMap = new HashMap<CompositeKey, String>();

    @Override
    public synchronized String getPseudonym(String localIdentification, String spEntityId, boolean allowCreate) throws PseudonymServiceException {
        CompositeKey compositeKey = this.getKey(localIdentification, spEntityId);
        String pseudonym = this.pseudoMap.get(compositeKey);
        if (pseudonym == null && allowCreate) {
            byte[] rndBytes = IDGenerator.generateBytes(20);
            pseudonym = HashUtil.hashToHexString((byte[])rndBytes, (HashAlgorithm)HashAlgorithm.SHA1);
            this.pseudoMap.put(compositeKey, pseudonym);
        }
        return pseudonym;
    }

    public synchronized void terminatePseudonym(String pseudonym, String spEntityId) {
        Iterator<Map.Entry<CompositeKey, String>> i = this.pseudoMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<CompositeKey, String> entry = i.next();
            String spId = entry.getKey().getSpEntityId();
            if (!spId.equals(spEntityId) || !pseudonym.equals(entry.getValue())) continue;
            i.remove();
            break;
        }
    }

    private CompositeKey getKey(String localIdentification, String spEntityId) throws PseudonymServiceException {
        try {
            return new CompositeKey(localIdentification, spEntityId);
        }
        catch (IOException e) {
            throw new PseudonymServiceException(e);
        }
    }

    private class CompositeKey
    extends SerialHashable {
        private static final long serialVersionUID = 20050515L;
        String localIdentification;
        String spEntityId;

        public CompositeKey(String localIdentification, String spEntityId) throws IOException {
            super(new Serializable[]{localIdentification, spEntityId});
            this.localIdentification = localIdentification;
            this.spEntityId = spEntityId;
        }

        public String getLocalIdentification() {
            return this.localIdentification;
        }

        public String getSpEntityId() {
            return this.spEntityId;
        }

        @Override
        public String toString() {
            return this.localIdentification + " / " + this.spEntityId;
        }
    }
}

