/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.session;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.service.session.SessionGroupMetadata;

public class SessionGroupMetadataUtil {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().serializationInclusion(JsonInclude.Include.NON_NULL)).deactivateDefaultTyping()).build();

    public String sessionGroupMetaDataToString(SessionGroupMetadata sessionGroupMetadata) {
        if (sessionGroupMetadata == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsString((Object)sessionGroupMetadata);
        }
        catch (JsonProcessingException e) {
            this.log.error((Object)"Error serializing session group metadata to string.", (Throwable)e);
            return null;
        }
    }

    public SessionGroupMetadata dsMetadataToSessionGroupMetadata(String dataStoreMetadata) {
        if (dataStoreMetadata == null) {
            return null;
        }
        try {
            return (SessionGroupMetadata)this.objectMapper.readerFor(SessionGroupMetadata.class).readValue(dataStoreMetadata);
        }
        catch (IOException e) {
            this.log.error((Object)"Error deserializing metadata to Java object.", (Throwable)e);
            return null;
        }
    }
}

