/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.session;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.sdk.DeviceSharingType;
import java.io.Serializable;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.AuthnSessionSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AssertionReplayPreventionService;
import org.sourceid.saml20.service.BearerAssertionReplayPreventionServiceException;
import org.sourceid.saml20.service.CachedSessionGroupInfo;
import org.sourceid.saml20.service.CachedSessionGroupStatus;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.session.AuthnSessionContextData;
import org.sourceid.saml20.service.session.SessionGroupAndSessions;
import org.sourceid.saml20.service.session.SessionGroupInfo;
import org.sourceid.saml20.service.session.StoredSessionService;
import org.sourceid.saml20.service.session.data.AuthnSessionData;
import org.sourceid.saml20.service.session.data.SessionGroupAndSessionsData;
import org.sourceid.saml20.service.session.data.SessionGroupData;
import org.sourceid.saml20.service.session.data.SessionStorageException;
import org.sourceid.saml20.service.session.data.SessionStorageManager;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.servlet.BaseSessionIdUtil;
import org.sourceid.websso.servlet.PersistentSessionIdUtil;

public class StoredSessionServiceImpl
implements StoredSessionService {
    private static final Log log = LogFactory.getLog(StoredSessionServiceImpl.class);
    private ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.saml20.service.session.StoredSessionServiceImpl");
    private static final String CFG_EMPTY_SESSION_REPLAY_RETENTION_SECS = "EmptySessionReplayRetentionSecs";
    private static final String KEY_SESSION_GROUP_AND_USER_IDS = "SSS.SessionGroupAndUserIds";
    static final String MAX_SESSION_GROUPS_PER_UNIQUE_USER_KEY = "MaxSessionGroupsPerUniqueUserKey";
    static final String MAX_SESSION_GROUPS_TO_REMOVE = "MaxSessionGroupsToRemove";
    static final int MAX_SESSION_GROUPS_PER_UNIQUE_USER_KEY_DEFAULT = -1;
    static final int MAX_SESSION_GROUPS_TO_REMOVE_DEFAULT = 50;
    private static final String DATA_STORE_ACCESS_LOOKUP = "lookup";
    private static final String DATA_STORE_ACCESS_DELETE = "delete";
    private SessionStorageManager storageMgr;
    private PersistentSessionIdUtil persistentSessionIdUtil = PersistentSessionIdUtil.getInstance();
    private Clock clock = Clock.systemDefaultZone();

    public StoredSessionServiceImpl() {
        this.storageMgr = StateMgmtFactory.getSessionStorageManager();
    }

    public StoredSessionServiceImpl(SessionStorageManager storageMgr) {
        this.storageMgr = storageMgr;
    }

    @Override
    public Collection<CachedSessionGroupInfo> checkUpdateCachedSessionGroupInfos(Collection<CachedSessionGroupStatus> cachedSessionGroupStatuses, Map<String, Object> params) throws SessionStorageException {
        ArrayList<CachedSessionGroupInfo> updates = new ArrayList<CachedSessionGroupInfo>();
        for (CachedSessionGroupStatus cachedGroupStatus : cachedSessionGroupStatuses) {
            SessionGroupAndSessions groupAndSessions;
            if (!(cachedGroupStatus.getIdleTimeoutFractionElapsed() >= (double)this.getIdleTimeoutExtensionThreshold())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("checkUpdateCachedSessionGroupInfos: idleTimeoutFractionElapsed for session group ID " + cachedGroupStatus.getSessionGroupId() + " is " + cachedGroupStatus.getIdleTimeoutFractionElapsed() + " which exceeds threshold of " + this.getIdleTimeoutExtensionThreshold()));
            }
            if ((groupAndSessions = this.getSessionGroupAndSessions(cachedGroupStatus.getSessionGroupId(), true, params, true)) != null) {
                updates.add(new CachedSessionGroupInfo(groupAndSessions.getSessionGroupInfo()));
                continue;
            }
            updates.add(CachedSessionGroupInfo.makeDeletedInfo(cachedGroupStatus.getSessionGroupId()));
        }
        return updates;
    }

    @Override
    public SessionGroupAndSessions getSessionGroupAndSessions(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws SessionStorageException {
        String hashedSessionId = StateMgmtFactory.getHashedPersistentSessionId(req, resp);
        if (hashedSessionId == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getSessionGroupAndSessions: returning null as no session ID was found in request");
            }
            return null;
        }
        if (!MgmtFactory.getAuthnSessionPolicyManager().isAnyStoredSessionEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getSessionGroupAndSessions: returning null as stored sessions are not enabled");
            }
            return null;
        }
        SessionGroupAndSessions result = null;
        if (!this.checkRepeatedDataStoreAccess(hashedSessionId, DATA_STORE_ACCESS_LOOKUP)) {
            result = this.getSessionGroupAndSessions(hashedSessionId, false, params, true);
        }
        if (result == null) {
            this.persistentSessionIdUtil.clearValue(req, resp);
        }
        return result;
    }

    private boolean checkRepeatedDataStoreAccess(String hashedSessionId, String accessType) {
        if (this.persistentSessionIdUtil.getFormat() == BaseSessionIdUtil.Format.JWT) {
            AssertionReplayPreventionService replayPrevSvc = StateMgmtFactory.getBearerAssertionReplayPreventionSvc();
            Calendar expiry = Calendar.getInstance();
            expiry.add(13, this.configStore.getIntValue(CFG_EMPTY_SESSION_REPLAY_RETENTION_SECS, 300));
            try {
                String replayKey = accessType + "-" + hashedSessionId;
                if (replayPrevSvc.isReplay(replayKey, expiry)) {
                    log.warn((Object)("Repeated data store " + accessType + " for hashed session ID=" + hashedSessionId));
                    return true;
                }
            }
            catch (BearerAssertionReplayPreventionServiceException e) {
                throw new ProcessRuntimeException("Error attempting to check for repeated data store access", e);
            }
        }
        return false;
    }

    @Override
    public void deleteAuthnSessions(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws SessionStorageException {
        String hashedSessionId;
        if (params != null) {
            params.remove(KEY_SESSION_GROUP_AND_USER_IDS);
        }
        if ((hashedSessionId = StateMgmtFactory.getHashedPersistentSessionId(req, resp)) != null) {
            this.persistentSessionIdUtil.clearValue(req, resp);
            if (!MgmtFactory.getAuthnSessionPolicyManager().isAnyStoredSessionEnabled()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"deleteAuthnSessions: stored sessions are not enabled");
                }
                return;
            }
            if (this.checkRepeatedDataStoreAccess(hashedSessionId, DATA_STORE_ACCESS_DELETE)) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("deleteAuthnSessions: deleting all stored sessions for hashed session ID " + hashedSessionId));
            }
            this.storageMgr.deleteSessionGroups(Collections.singleton(hashedSessionId));
        }
    }

    @Override
    public void deleteAuthnSessions(Collection<String> sessionGroupIds) throws SessionStorageException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteAuthnSessions: deleting all stored sessions for session group ID's (" + StringUtils.join(sessionGroupIds, (String)", ") + ")"));
        }
        this.storageMgr.deleteSessionGroupsByGroupIds(sessionGroupIds);
    }

    @Override
    public CachedSessionGroupInfo saveAuthnSession(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params, IdpHashableAuthnBean bean, long sessionSeriesId, Collection<String> uniqueUserIds, AuthnSessionContextData contextData) throws SessionStorageException {
        SessionGroupAndUserIds sessionGroupAndUserIds;
        String hashedSessionId = StateMgmtFactory.getHashedPersistentSessionId(req, resp);
        SessionGroupInfo sessionGroupInfo = null;
        Set<Object> existingUserIds = Collections.emptySet();
        if (hashedSessionId != null && (sessionGroupAndUserIds = this.getSessionGroupAndUserIds(hashedSessionId, params, false)) != null) {
            sessionGroupInfo = sessionGroupAndUserIds.getSessionGroupInfo();
            existingUserIds = sessionGroupAndUserIds.getUniqueUserIds();
        }
        if (sessionGroupInfo == null) {
            sessionGroupInfo = this.makeNewSessionGroupInfo(req, resp, params, bean, sessionSeriesId, contextData);
        } else {
            String prevHashedSessionId = sessionGroupInfo.getHashedSessionId();
            String newPrimaryValue = this.persistentSessionIdUtil.newValue();
            String hashedNewValue = this.persistentSessionIdUtil.hashPrimaryValue(newPrimaryValue);
            sessionGroupInfo.setHashedSessionId(hashedNewValue);
            long newExpiryTimeMillis = Math.max(sessionGroupInfo.getExpiryTimeMillis(), AuthnSessionSettings.getSessionExpiryTimeMillis(bean, this.clock.millis()));
            sessionGroupInfo.setExpiryTimeMillis(newExpiryTimeMillis);
            sessionGroupInfo.setContextData(contextData);
            if (log.isDebugEnabled()) {
                log.debug((Object)("saveAuthnSession: updating session group info " + sessionGroupInfo));
            }
            this.storageMgr.updateSessionGroup(sessionGroupInfo.toSessionGroupData(prevHashedSessionId));
            this.persistentSessionIdUtil.setValue(req, resp, newPrimaryValue);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("saveAuthnSession: storing authn session for " + bean.getAuthnSourceKey()));
        }
        bean.setStoredSessionGroupId(sessionGroupInfo.getId());
        this.storageMgr.saveAuthnSessions(Collections.singleton(this.toAuthnSessionData(sessionGroupInfo.getId(), bean)));
        if (params != null) {
            HashSet<String> allUserIds = new HashSet<String>(existingUserIds);
            allUserIds.addAll(uniqueUserIds);
            params.put(KEY_SESSION_GROUP_AND_USER_IDS, new SessionGroupAndUserIds(sessionGroupInfo, allUserIds));
        }
        for (String uniqueUserId : uniqueUserIds) {
            if (existingUserIds.contains(uniqueUserId)) continue;
            this.storageMgr.addUniqueUserId(sessionGroupInfo.getId(), uniqueUserId);
            this.checkReachedMaxSessionGroupsPerUniqueUserId(uniqueUserId, this.getMaxSessionGroupsPerUniqueUserKey(), this.getMaxSessionGroupsToRemove());
        }
        return new CachedSessionGroupInfo(sessionGroupInfo);
    }

    protected void setClock(Clock clock) {
        this.clock = clock;
    }

    protected boolean isSessionValid(IdpHashableAuthnBean bean, long lastActivityTimeMillis) {
        AuthnSessionSettings settings = MgmtFactory.getAuthnSessionPolicyManager().getEffectiveSettings(bean.getAuthnSourceKey(), bean.getDeviceSharingType());
        if (!settings.isEnableSessions() || !settings.isPersistent()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session for " + bean.getAuthnSourceKey() + " is invalid as stored sessions are no longer enabled for the source"));
            }
            return false;
        }
        long currentTimeMillis = this.clock.millis();
        if (!settings.isSessionValid(bean, lastActivityTimeMillis, currentTimeMillis)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session for " + bean.getAuthnSourceKey() + " is no longer valid due to idle timeout, max timeout, or not-on-or-after"));
            }
            return false;
        }
        return true;
    }

    protected SessionGroupAndUserIds getSessionGroupAndUserIds(String hashedSessionId, Map<String, Object> params, boolean updateSessionGroupInfo) throws SessionStorageException {
        SessionGroupAndUserIds result = null;
        if (params != null && (result = (SessionGroupAndUserIds)params.get(KEY_SESSION_GROUP_AND_USER_IDS)) != null) {
            return result;
        }
        SessionGroupAndSessions sessionGroupAndSessions = this.getSessionGroupAndSessions(hashedSessionId, false, params, updateSessionGroupInfo);
        if (sessionGroupAndSessions == null) {
            return null;
        }
        if (!updateSessionGroupInfo) {
            long currentTimeMillis = this.clock.millis();
            long newExpiryTimeMillis = AuthnSessionSettings.getOverallExpiryTimeMillis(sessionGroupAndSessions.getAuthnSessions(), currentTimeMillis);
            sessionGroupAndSessions.getSessionGroupInfo().setExpiryTimeMillis(newExpiryTimeMillis);
            sessionGroupAndSessions.getSessionGroupInfo().setLastActivityTimeMillis(currentTimeMillis);
        }
        return new SessionGroupAndUserIds(sessionGroupAndSessions.getSessionGroupInfo(), sessionGroupAndSessions.getUniqueUserIds());
    }

    protected IdpHashableAuthnBean toBean(AuthnSessionData data) throws SessionStorageException {
        try {
            String json = data.getSessionData();
            if (this.isEncryptSessionAttributes()) {
                json = Obfuscator.deobfuscate(json);
            }
            ObjectMapper mapper = this.makeObjectMapper();
            return (IdpHashableAuthnBean)mapper.readValue(json, IdpHashableAuthnBean.class);
        }
        catch (Exception e) {
            throw new SessionStorageException("Error deserializing authn session", (Throwable)e);
        }
    }

    protected AuthnSessionData toAuthnSessionData(String sessionGroupId, IdpHashableAuthnBean bean) throws SessionStorageException {
        AuthnSessionData result;
        try {
            ObjectMapper mapper = this.makeObjectMapper();
            String serialized = mapper.writeValueAsString((Object)bean);
            if (this.isEncryptSessionAttributes()) {
                serialized = Obfuscator.obfuscate(serialized, true);
            }
            result = new AuthnSessionData(sessionGroupId, bean.getSerializedHash(), serialized);
        }
        catch (Exception e) {
            throw new SessionStorageException("Error serializing authn session", (Throwable)e);
        }
        if (result.getSessionData().length() > this.getMaxAuthnSessionDataSizeBytes()) {
            throw new SessionStorageException("Serialized session attribute payload exceeded the configured maximum of " + this.getMaxAuthnSessionDataSizeBytes() + " bytes");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Serialized session attribute payload for " + bean.getAuthnSourceKey() + " is " + result.getSessionData().length() + " bytes"));
        }
        return result;
    }

    protected int getMaxAuthnSessionDataSizeBytes() {
        return this.configStore.getIntValue("MaxAuthnSessionDataSizeBytes", 32000);
    }

    protected boolean isEncryptSessionAttributes() {
        return this.configStore.getBooleanValue("EncryptSessionAttributes", true);
    }

    private ObjectMapper makeObjectMapper() {
        ObjectMapper result = new ObjectMapper();
        result.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        result.enableDefaultTyping(ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT);
        return result;
    }

    @Override
    public void deleteAuthnSession(String sessionGroupId, String authnBeanSerializedHash) throws SessionStorageException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteAuthnSession: deleting stored session for session group ID '" + sessionGroupId + "' and attribute hash '" + authnBeanSerializedHash + "'"));
        }
        if (!MgmtFactory.getAuthnSessionPolicyManager().isAnyStoredSessionEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"deleteAuthnSession: returning as stored sessions are not enabled");
            }
            return;
        }
        if (StringUtils.isNotBlank((String)sessionGroupId) && StringUtils.isNotBlank((String)authnBeanSerializedHash)) {
            this.storageMgr.deleteAuthnSessions(sessionGroupId, Collections.singletonList(authnBeanSerializedHash));
            if (log.isDebugEnabled()) {
                log.debug((Object)("deleteAuthnSession: successfully removed stored session for session group ID '" + sessionGroupId + "' and attribute hash '" + authnBeanSerializedHash + "'"));
            }
        }
    }

    @Override
    public SessionGroupAndSessions getSessionGroupAndSessions(String sessionGroupId, boolean updateActivityTime) throws SessionStorageException {
        if (sessionGroupId == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getSessionGroupAndSessions: returning null since no session group ID was provided");
            }
            return null;
        }
        if (!MgmtFactory.getAuthnSessionPolicyManager().isAnyStoredSessionEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getSessionGroupAndSessions: returning null as stored sessions are not enabled");
            }
            return null;
        }
        SessionGroupAndSessions result = null;
        if (!this.checkRepeatedDataStoreAccess(sessionGroupId, DATA_STORE_ACCESS_LOOKUP)) {
            result = this.getSessionGroupAndSessions(sessionGroupId, true, null, updateActivityTime);
        }
        return result;
    }

    @Override
    public List<SessionGroupInfo> getSessionGroupsByUniqueUserId(String uniqueUserId) throws SessionStorageException {
        LinkedList<SessionGroupInfo> results = new LinkedList<SessionGroupInfo>();
        if (StringUtils.isEmpty((String)uniqueUserId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getSessionGroupsByUniqueUserId: returning null since no unique user ID was provided");
            }
            return results;
        }
        if (!MgmtFactory.getAuthnSessionPolicyManager().isAnyStoredSessionEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getSessionGroupsByUniqueUserId: returning null as stored sessions are not enabled");
            }
            return results;
        }
        Collection sessionGroupDataList = this.storageMgr.getSessionGroupsByUniqueUserId(uniqueUserId);
        for (SessionGroupData sessionGroupAndSessionsData : sessionGroupDataList) {
            SessionGroupInfo sessionGroupInfo = new SessionGroupInfo(sessionGroupAndSessionsData);
            results.add(sessionGroupInfo);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("getSessionGroupsByUniqueUserId: for unique user key=" + uniqueUserId));
            log.debug((Object)("    returning sessions group ID=" + sessionGroupInfo.getId()));
        }
        return results;
    }

    private SessionGroupAndSessions getSessionGroupAndSessions(String id, boolean useGroupIds, Map<String, Object> params, boolean updateSessionGroupInfo) throws SessionStorageException {
        String sessionIdStr = (useGroupIds ? "session group ID " : "session ID ") + id;
        Collection sessionGroupAndSessionsDataList = useGroupIds ? this.storageMgr.getSessionGroupsAndSessionsByGroupIds(Collections.singleton(id)) : this.storageMgr.getSessionGroupsAndSessions(Collections.singleton(id));
        if (sessionGroupAndSessionsDataList.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getSessionGroupAndSessions: no session groups were found for " + sessionIdStr));
            }
            return null;
        }
        SessionGroupAndSessionsData sessionGroupAndSessionsData = (SessionGroupAndSessionsData)sessionGroupAndSessionsDataList.iterator().next();
        SessionGroupData sessionGroupData = sessionGroupAndSessionsData.getSessionGroupData();
        if (!useGroupIds && !id.equals(sessionGroupData.getHashedSessionId())) {
            throw new SessionStorageException("Session group hashed session ID does not match value used in query");
        }
        HashSet<IdpHashableAuthnBean> beansToReturn = new HashSet<IdpHashableAuthnBean>();
        ArrayList<String> hashesToDelete = new ArrayList<String>();
        Collection authnSessionDataList = sessionGroupAndSessionsData.getAuthnSessions();
        this.convertStorageSessionDataToAuthnBean(beansToReturn, hashesToDelete, authnSessionDataList, sessionGroupData.getLastActivityTimeMillis());
        if (beansToReturn.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getSessionGroupAndSessions: no valid stored sessions exist, deleting session group");
            }
            if (useGroupIds) {
                this.storageMgr.deleteSessionGroupsByGroupIds(Collections.singleton(id));
            } else {
                this.storageMgr.deleteSessionGroups(Collections.singleton(id));
            }
            return null;
        }
        if (!hashesToDelete.isEmpty()) {
            this.storageMgr.deleteAuthnSessions(sessionGroupData.getId(), hashesToDelete);
        }
        SessionGroupInfo sessionGroupInfo = new SessionGroupInfo(sessionGroupData);
        if (updateSessionGroupInfo) {
            long currentTimeMillis = this.clock.millis();
            long newExpiryTimeMillis = AuthnSessionSettings.getOverallExpiryTimeMillis(beansToReturn, currentTimeMillis);
            sessionGroupInfo.setExpiryTimeMillis(newExpiryTimeMillis);
            sessionGroupInfo.setLastActivityTimeMillis(currentTimeMillis);
            if (log.isDebugEnabled()) {
                log.debug((Object)("getSessionGroupAndSessions: updating session group info " + sessionGroupInfo));
            }
            this.storageMgr.updateSessionGroup(sessionGroupInfo.toSessionGroupData(sessionGroupInfo.getHashedSessionId()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSessionGroupAndSessions: returning sessions for authn sources " + beansToReturn.stream().map(IdpHashableAuthnBean::getAuthnSourceKey).collect(Collectors.toList())));
        }
        HashSet<String> uniqueUserIds = new HashSet<String>(sessionGroupAndSessionsData.getUniqueUserIds());
        SessionGroupAndSessions result = new SessionGroupAndSessions(sessionGroupInfo, beansToReturn, uniqueUserIds);
        if (params != null) {
            params.put(KEY_SESSION_GROUP_AND_USER_IDS, new SessionGroupAndUserIds(sessionGroupInfo, uniqueUserIds));
        }
        return result;
    }

    private void convertStorageSessionDataToAuthnBean(Set<IdpHashableAuthnBean> beansToReturn, List<String> hashesToDelete, Collection<AuthnSessionData> authnSessionDataList, long lastActivityTimeMillis) {
        if (authnSessionDataList != null) {
            for (AuthnSessionData authnSessionData : authnSessionDataList) {
                AuthnSessionSettings settings;
                IdpHashableAuthnBean bean = null;
                try {
                    bean = this.toBean(authnSessionData);
                }
                catch (SessionStorageException e) {
                    log.warn((Object)"Unexpected error deserializing session, session will be deleted", (Throwable)e);
                    hashesToDelete.add(authnSessionData.getAttributeHash());
                }
                if (bean == null) continue;
                if (bean.getDeviceSharingType() == null) {
                    bean.setDeviceSharingType(DeviceSharingType.UNSPECIFIED);
                }
                if ((settings = MgmtFactory.getAuthnSessionPolicyManager().getEffectiveSettings(bean.getAuthnSourceKey(), bean.getDeviceSharingType())).isEnableSessions() && settings.isPersistent() && this.isSessionValid(bean, lastActivityTimeMillis)) {
                    beansToReturn.add(bean);
                    continue;
                }
                hashesToDelete.add(bean.getSerializedHash());
            }
        }
    }

    private SessionGroupInfo makeNewSessionGroupInfo(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params, IdpHashableAuthnBean bean, long sessionSeriesId, AuthnSessionContextData contextData) throws SessionStorageException {
        long currentTimeMillis = this.clock.millis();
        SessionGroupInfo result = new SessionGroupInfo();
        String hashedSessionId = StateMgmtFactory.cycleHashedPersistentSessionId(req, resp);
        result.setId(IDGenerator.rndAlphaNumeric(this.configStore.getIntValue("SessionGroupIdLength", 25)));
        result.setHashedSessionId(hashedSessionId);
        result.setExpiryTimeMillis(AuthnSessionSettings.getSessionExpiryTimeMillis(bean, currentTimeMillis));
        result.setLastActivityTimeMillis(currentTimeMillis);
        result.setSessionSeriesId(sessionSeriesId);
        result.setSri(StateMgmtFactory.getSri(req, resp));
        result.setContextData(contextData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("makeNewSessionGroupInfo: storing new session group info " + result));
        }
        this.storageMgr.createSessionGroup(result.toSessionGroupData(null));
        return result;
    }

    private float getIdleTimeoutExtensionThreshold() {
        return (float)this.configStore.getDoubleValue("IdleTimeoutExtensionThreshold", 0.25);
    }

    int getMaxSessionGroupsPerUniqueUserKey() {
        return this.configStore.getIntValue(MAX_SESSION_GROUPS_PER_UNIQUE_USER_KEY, -1);
    }

    int getMaxSessionGroupsToRemove() {
        return this.configStore.getIntValue(MAX_SESSION_GROUPS_TO_REMOVE, 50);
    }

    public void checkReachedMaxSessionGroupsPerUniqueUserId(String uniqueUserId, int maxSessionGroupsAllowed, int maxSessionGroupsToDelete) throws SessionStorageException {
        if (StringUtils.isNotEmpty((String)uniqueUserId) && maxSessionGroupsAllowed > 0) {
            Collection sessionGroupsMatchingUniqueUserId = this.storageMgr.getSessionGroupsByUniqueUserId(uniqueUserId);
            if (sessionGroupsMatchingUniqueUserId.size() > maxSessionGroupsAllowed) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found " + sessionGroupsMatchingUniqueUserId.size() + " session groups for unique user ID '" + uniqueUserId + "'. This exceeds the maximum session groups allowed per user ID: " + maxSessionGroupsAllowed));
                }
                List<String> sessionGroupIdsToDelete = this.determineSessionGroupsToDelete(sessionGroupsMatchingUniqueUserId, maxSessionGroupsAllowed, maxSessionGroupsToDelete);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting the following session group IDs due to exceeding session group limit per user ID: " + StringUtils.join(sessionGroupIdsToDelete, (String)", ")));
                }
                if (sessionGroupIdsToDelete.size() > 0) {
                    this.storageMgr.deleteSessionGroupsByGroupIds(sessionGroupIdsToDelete);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + sessionGroupsMatchingUniqueUserId.size() + " session groups for unique user ID '" + uniqueUserId + "'. This has not exceed the maximum session groups allowed per user ID: " + maxSessionGroupsAllowed));
            }
        }
    }

    List<String> determineSessionGroupsToDelete(Collection<SessionGroupData> sessionGroupsMatchingUniqueUserId, int maxSessionGroupsAllowed, int maxSessionGroupsToDelete) {
        List<Object> sessionGroupsToDelete = new ArrayList();
        if (maxSessionGroupsAllowed > 0 && sessionGroupsMatchingUniqueUserId != null && sessionGroupsMatchingUniqueUserId.size() > 0) {
            int exceedByAmt = sessionGroupsMatchingUniqueUserId.size() - maxSessionGroupsAllowed;
            List sortedSessionGroupsMatchingUniqueUserId = sessionGroupsMatchingUniqueUserId.stream().sorted(Comparator.comparingLong(SessionGroupData::getLastActivityTimeMillis)).collect(Collectors.toList());
            sessionGroupsToDelete = maxSessionGroupsToDelete > 0 && exceedByAmt > maxSessionGroupsToDelete ? sortedSessionGroupsMatchingUniqueUserId.subList(0, maxSessionGroupsToDelete) : sortedSessionGroupsMatchingUniqueUserId.subList(0, exceedByAmt);
        }
        return sessionGroupsToDelete.stream().map(SessionGroupData::getId).collect(Collectors.toList());
    }

    @Override
    public void updateMetadata(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params, AuthnSessionContextData contextData) throws SessionStorageException {
        String hashedSessionId = StateMgmtFactory.getHashedPersistentSessionId(req, resp);
        if (hashedSessionId == null) {
            if (log.isDebugEnabled()) {
                log.trace((Object)"updateMetadata: cannot update context data since no session ID was found in request");
            }
            return;
        }
        if (!MgmtFactory.getAuthnSessionPolicyManager().isAnyStoredSessionEnabled()) {
            if (log.isDebugEnabled()) {
                log.trace((Object)"updateMetadata: nothing to update since stored sessions are not enabled");
            }
            return;
        }
        SessionGroupAndUserIds sessionGroupAndUserIds = this.getSessionGroupAndUserIds(hashedSessionId, params, false);
        SessionGroupInfo sessionGroupInfo = Optional.ofNullable(sessionGroupAndUserIds).map(SessionGroupAndUserIds::getSessionGroupInfo).orElse(null);
        if (sessionGroupInfo != null) {
            sessionGroupInfo.setContextData(contextData);
            this.storageMgr.updateSessionGroup(sessionGroupInfo.toSessionGroupData(hashedSessionId));
        }
    }

    private static class SessionGroupAndUserIds
    implements Serializable {
        private SessionGroupInfo sessionGroupInfo;
        private Set<String> uniqueUserIds;

        public SessionGroupAndUserIds(SessionGroupInfo sessionGroupInfo, Set<String> uniqueUserIds) {
            this.sessionGroupInfo = sessionGroupInfo;
            this.uniqueUserIds = uniqueUserIds;
        }

        public SessionGroupInfo getSessionGroupInfo() {
            return this.sessionGroupInfo;
        }

        public Set<String> getUniqueUserIds() {
            return this.uniqueUserIds;
        }
    }
}

