/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.util;

import com.pingidentity.jgroups.NodeAddress;
import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import org.jgroups.Address;
import org.sourceid.saml20.domain.mgmt.impl.Mode;
import org.sourceid.saml20.service.adminstate.AdminNodeRole;
import org.sourceid.saml20.service.adminstate.SynchronizationState;
import org.sourceid.saml20.service.impl.grouprpc.PreferredNodeGroup;

public class Node
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int index;
    private NodeAddress nodeAddr;
    private Mode mode;
    private String name;
    private String provisionerClusterMode;
    private PreferredNodeGroup idpSessionRegistryNodeGroup;
    private boolean stateTracking;
    private String nodeGroupId;
    private String version;
    private String nodeTags;
    private Date configPublishDate;
    private ReplicationStatus replicationStatus;
    private SynchronizationState synchronizationState;
    private AdminNodeRole consoleRole;
    private Instant consoleRoleLastUpdateDate;

    public Node(int index, Address address, Mode mode, String provisionerClusterMode, String name, PreferredNodeGroup idpSessionRegistryGroup, boolean stateTracking, String nodeGroupId, String version, String nodeTags, Date configPublishDate, ReplicationStatus replicationStatus, SynchronizationState synchronizationState, AdminNodeRole consoleRole, Instant consoleRoleLastUpdateDate) {
        this.index = index;
        this.nodeAddr = new NodeAddress(address);
        this.mode = mode;
        this.name = name;
        this.provisionerClusterMode = provisionerClusterMode;
        this.idpSessionRegistryNodeGroup = idpSessionRegistryGroup;
        this.stateTracking = stateTracking;
        this.nodeGroupId = nodeGroupId;
        this.version = version;
        this.nodeTags = nodeTags;
        this.configPublishDate = configPublishDate == null ? null : new Date(configPublishDate.getTime());
        this.replicationStatus = replicationStatus;
        this.synchronizationState = new SynchronizationState(synchronizationState);
        this.consoleRole = consoleRole;
        this.consoleRoleLastUpdateDate = consoleRoleLastUpdateDate;
    }

    public Address getAddress() {
        return this.nodeAddr.getAddress();
    }

    public Mode getMode() {
        return this.mode;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public boolean isConsole() {
        return Mode.CLUSTERED_CONSOLE == this.getMode();
    }

    public String getProvisionerClusterMode() {
        return this.provisionerClusterMode;
    }

    public PreferredNodeGroup getIdpSessionRegistryNodeGroup() {
        return this.idpSessionRegistryNodeGroup;
    }

    public boolean isStateTracking() {
        return this.stateTracking;
    }

    public String getNodeGroupId() {
        return this.nodeGroupId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getNodeTags() {
        return this.nodeTags;
    }

    public Date getConfigPublishDate() {
        return this.configPublishDate == null ? null : new Date(this.configPublishDate.getTime());
    }

    public ReplicationStatus getReplicationStatus() {
        return this.replicationStatus;
    }

    public SynchronizationState getSynchronizationState() {
        return new SynchronizationState(this.synchronizationState);
    }

    public AdminNodeRole getConsoleRole() {
        return this.consoleRole;
    }

    public boolean isActiveConsole() {
        return AdminNodeRole.ACTIVE == this.consoleRole;
    }

    public Instant getConsoleRoleLastUpdateDate() {
        return this.consoleRoleLastUpdateDate;
    }

    public String toString() {
        Object modeString = this.mode.toString();
        if (this.mode == Mode.CLUSTERED_CONSOLE) {
            modeString = (String)modeString + ", consoleRole=" + this.consoleRole + ", roleLastUpdated=" + this.consoleRoleLastUpdateDate;
        }
        return String.format("Node{idx=%d, addr=%s, %s, provMode=%s, trackState=%b, groupId=%s", this.index, this.nodeAddr, modeString, this.provisionerClusterMode, this.stateTracking, this.nodeGroupId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return this.index == node.index && this.stateTracking == node.stateTracking && Objects.equals(this.nodeAddr, node.nodeAddr) && this.mode == node.mode && Objects.equals(this.name, node.name) && Objects.equals(this.provisionerClusterMode, node.provisionerClusterMode) && Objects.equals(this.idpSessionRegistryNodeGroup, node.idpSessionRegistryNodeGroup) && Objects.equals(this.nodeGroupId, node.nodeGroupId) && Objects.equals(this.version, node.version) && Objects.equals(this.nodeTags, node.nodeTags) && Objects.equals(this.configPublishDate, node.configPublishDate) && Objects.equals((Object)this.replicationStatus, (Object)node.replicationStatus) && Objects.equals(this.synchronizationState, node.synchronizationState) && Objects.equals((Object)this.consoleRole, (Object)node.consoleRole) && Objects.equals(this.consoleRoleLastUpdateDate, node.consoleRoleLastUpdateDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.index, this.nodeAddr, this.mode, this.name, this.provisionerClusterMode, this.idpSessionRegistryNodeGroup, this.stateTracking, this.nodeGroupId, this.version, this.nodeTags, this.configPublishDate, this.replicationStatus, this.synchronizationState, this.consoleRole, this.consoleRoleLastUpdateDate});
    }

    public static enum ReplicationStatus {
        RETRIEVING,
        APPLYING,
        FAILED,
        IDLE;

    }
}

