/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.state;

import com.google.common.base.CharMatcher;
import com.pingidentity.common.util.consistent.ConsistentHashFunction;
import com.pingidentity.common.util.consistent.DigestConsistentHashFunction;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigProps;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;

public class AdaptiveClusteringConfig {
    private static final Log log = LogFactory.getLog(AdaptiveClusteringConfig.class);
    private static final String NODE_GROUP_ID = "node.group.id";
    private int replicationFactor = 3;
    private boolean trackState = true;
    private boolean rebalanceEnabled = true;
    private int rebalanceRpcTimeout = 2000;
    private int virtualNodeCount = 100;
    private int hashSpaceSize = 1000000000;
    private int rebalanceBatchSize = 1000;
    private String nodeGroupId;
    private boolean replicateSessions = false;
    private boolean replicateReferenceTokens = false;
    private boolean replicateReferenceTokensSynchronous = false;
    private boolean replicateAssertionReplayState = false;
    private boolean replicateAccountLockingState = false;
    private boolean replicateTransactionState = false;
    private boolean rebalanceLockRequired = true;
    private ConsistentHashFunction hashFunction;

    public AdaptiveClusteringConfig() {
        ConfigProps props = new ConfigProps("cluster-adaptive.conf");
        this.replicationFactor = props.getInt("replication.factor", 3);
        this.trackState = props.getBoolean("track.state", true);
        this.rebalanceEnabled = props.getBoolean("rebalance.enabled", true);
        this.rebalanceRpcTimeout = props.getInt("rebalance.rpc.timeout", 2000);
        this.rebalanceBatchSize = props.getInt("rebalance.batch.size", 1000);
        this.virtualNodeCount = props.getInt("virtual.nodes", 100);
        this.hashSpaceSize = props.getInt("hash.space.size", 1000000000);
        this.hashFunction = new DigestConsistentHashFunction(HashAlgorithm.SHA256, this.hashSpaceSize);
        this.nodeGroupId = props.getProperty(NODE_GROUP_ID, "");
        this.nodeGroupId = this.nodeGroupId.trim();
        if (CharMatcher.whitespace().matchesAnyOf((CharSequence)this.nodeGroupId)) {
            log.error((Object)"node.group.id cannot contain whitespace. This setting will be ignored.");
            this.nodeGroupId = "";
        }
        this.replicateSessions = props.getBoolean("inter.group.replicate.sessions", true);
        this.replicateReferenceTokens = props.getBoolean("inter.group.replicate.reference.tokens", true);
        this.replicateReferenceTokensSynchronous = props.getBoolean("inter.group.replicate.reference.tokens.synchronous", true);
        this.replicateAssertionReplayState = props.getBoolean("inter.group.replicate.assertion.replay", true);
        this.replicateAccountLockingState = props.getBoolean("inter.group.replicate.account.locking", true);
        this.replicateTransactionState = props.getBoolean("inter.group.replicate.transaction.state", false);
        this.rebalanceLockRequired = props.getBoolean("rebalance.lock.required", true);
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public boolean isStateTracking() {
        return ModeSupport.isEngine() && this.trackState;
    }

    public boolean isRebalanceEnabled() {
        return this.rebalanceEnabled;
    }

    public int getRebalanceRpcTimeout() {
        return this.rebalanceRpcTimeout;
    }

    public int getVirtualNodeCount() {
        return this.virtualNodeCount;
    }

    public int getHashSpaceSize() {
        return this.hashSpaceSize;
    }

    public int getRebalanceBatchSize() {
        return this.rebalanceBatchSize;
    }

    public ConsistentHashFunction getHashFunction() {
        return this.hashFunction;
    }

    public String getNodeGroupId() {
        return this.nodeGroupId;
    }

    public boolean isReplicateSessions() {
        return this.replicateSessions;
    }

    public boolean isReplicateReferenceTokens() {
        return this.replicateReferenceTokens;
    }

    public boolean isReplicateReferenceTokensSynchronous() {
        return this.replicateReferenceTokensSynchronous;
    }

    public boolean isReplicateAssertionReplayState() {
        return this.replicateAssertionReplayState;
    }

    public boolean isReplicateAccountLockingState() {
        return this.replicateAccountLockingState;
    }

    public boolean isReplicateTransactionState() {
        return this.replicateTransactionState;
    }

    public boolean isRebalanceLockRequired() {
        return this.rebalanceLockRequired;
    }
}

