/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.state;

import com.pingidentity.common.util.LogGuard;
import com.pingidentity.common.util.consistent.ConsistentHashFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.websso.servlet.SessionIdUtil;

public class ConsistentHashTracker
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConsistentHashTracker.class);
    private NavigableMap<Integer, List<String>> sortedMap = new TreeMap<Integer, List<String>>();
    private ConsistentHashFunction hashFunction;
    private boolean hashPartitionKeyInLogs = false;
    private boolean hashIdentifierInLogs = false;

    public ConsistentHashTracker(ConsistentHashFunction hashFunction, boolean hashPartitionKeyInLogs, boolean hashIdentifierInLogs) {
        this.hashFunction = hashFunction;
        this.hashPartitionKeyInLogs = hashPartitionKeyInLogs;
        this.hashIdentifierInLogs = hashIdentifierInLogs;
    }

    public void add(String identifier) {
        this.add(identifier, identifier);
    }

    public void add(String partitionKey, String identifier) {
        ArrayList<String> identifiers;
        if (this.hashFunction == null) {
            return;
        }
        int hash = this.hashFunction.calculateHash(partitionKey);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Adding consistent hash mapping, partitionKey=" + this.getPartitionKeyForLog(partitionKey) + ", identifier=" + this.getIdentifierForLog(identifier) + ", hash=" + hash));
        }
        if ((identifiers = (ArrayList<String>)this.sortedMap.get(hash)) == null) {
            identifiers = new ArrayList<String>(2);
            this.sortedMap.put(hash, identifiers);
        }
        if (!identifiers.contains(identifier)) {
            identifiers.add(identifier);
        }
    }

    public void remove(String identifier) {
        this.remove(identifier, identifier);
    }

    public void remove(String partitionKey, String identifier) {
        if (this.hashFunction == null) {
            return;
        }
        int hash = this.hashFunction.calculateHash(partitionKey);
        List identifiers = (List)this.sortedMap.get(hash);
        if (identifiers == null) {
            return;
        }
        identifiers.remove(identifier);
        if (identifiers.isEmpty()) {
            this.sortedMap.remove(hash);
        }
    }

    public Collection<String> getRange(int start, int endExclusive) {
        return this.sortedMap.subMap(start, true, endExclusive, false).values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public boolean isEmpty() {
        return this.sortedMap.isEmpty();
    }

    public int size() {
        return this.sortedMap.size();
    }

    public void clear() {
        this.sortedMap.clear();
    }

    protected int countForHash(int hash) {
        List identifiers = (List)this.sortedMap.get(hash);
        if (identifiers == null) {
            return 0;
        }
        return identifiers.size();
    }

    private String getPartitionKeyForLog(String partitionKey) {
        if (!this.hashPartitionKeyInLogs) {
            return LogGuard.encode(partitionKey);
        }
        return SessionIdUtil.getInstance().hashIdForLog(partitionKey);
    }

    private String getIdentifierForLog(String identifier) {
        if (!this.hashIdentifierInLogs) {
            return LogGuard.encode(identifier);
        }
        return SessionIdUtil.getInstance().hashIdForLog(identifier);
    }
}

