/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.state;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.sdk.DeviceSharingType;
import com.pingidentity.sdk.session.SessionQuotaContext;
import com.pingidentity.session.quotas.SessionQuotaService;
import com.pingidentity.session.quotas.enforcer.QuotaEnforcerResult;
import com.pingidentity.session.quotas.exception.SessionQuotaException;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTimeUtils;
import org.sourceid.common.Util;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.domain.AuthnSessionSettings;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.AuthnSessionPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.protocol.AssertionTypeUtil;
import org.sourceid.saml20.service.AuthnSessionInfo;
import org.sourceid.saml20.service.AuthnSessionInfoImpl;
import org.sourceid.saml20.service.AuthnSessionInfoWithoutBeansImpl;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.BeanFilter;
import org.sourceid.saml20.service.CachedSessionGroupInfo;
import org.sourceid.saml20.service.CachedSessionGroupStatus;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.IdpSessionRegistry;
import org.sourceid.saml20.service.Session;
import org.sourceid.saml20.service.SessionInfoForPartnerSessionsResult;
import org.sourceid.saml20.service.SessionRegistryException;
import org.sourceid.saml20.service.SessionRevocationService;
import org.sourceid.saml20.service.WebSsoSession;
import org.sourceid.saml20.service.session.AuthnSessionContextData;
import org.sourceid.saml20.service.session.SessionGroupAndSessions;
import org.sourceid.saml20.service.session.SessionGroupInfo;
import org.sourceid.saml20.service.session.data.SessionStorageException;
import org.sourceid.saml20.service.util.AuthnSessionContextDataUtil;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.util.UserKeyAttributeUtil;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.util.json.JsonUtils;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.servlet.ExtendedSri;
import org.sourceid.websso.servlet.SessionIdUtil;

public class IdpSessionRegistrySupport {
    public static final String KEY_AUTHN_SESSION_INFO = "ISRS.AuthnSessionInfo";
    public static final String KEY_DEVICE_SHARING_TYPE = "ISRS.DeviceSharingType";
    private static final String INDEX_TYPE = "indexType";
    private static final String OIDC_LOGOUT = "oidcLogout";
    private static final String ISSUER = "issuer";
    private static final String SUBJECT = "subject";
    private static final String SID = "sid";
    private static final Log log = LogFactory.getLog(IdpSessionRegistrySupport.class);
    private static final AssertionTypeUtil ASSERTION_TYPE_UTIL = new AssertionTypeUtil();
    private static SessionIdUtil sessionIdUtil = SessionIdUtil.getInstance();

    public static void registerAssertionIssued(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, IdpHashableAuthnBean[] authnBeans, org.sourceid.saml20.xmlbinding.assertion.AssertionType assertion, String spEntityId, NameIDType unencryptedNameID, boolean maskNameId, String virtualServerId) {
        String sessionIndex = ASSERTION_TYPE_UTIL.getSessionIndex(assertion);
        String id = assertion.getID();
        WebSsoSession s = new WebSsoSession(spEntityId, virtualServerId, id, sessionIndex, unencryptedNameID);
        s.setMaskUserName(maskNameId);
        IdpSessionRegistrySupport.registerSessionForSlo(req, resp, stateParams, authnBeans, s);
    }

    public static void registerAssertionIssued(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, IdpHashableAuthnBean[] authnBeans, AssertionType assertion, String spEntityId, NameIDType unencryptedNameID, boolean maskNameId, String virtualServerId) {
        String id = assertion.getAssertionID();
        WebSsoSession s = new WebSsoSession(spEntityId, virtualServerId, id, null, unencryptedNameID);
        s.setMaskUserName(maskNameId);
        IdpSessionRegistrySupport.registerSessionForSlo(req, resp, stateParams, authnBeans, s);
    }

    public static void registerAuthnBeansForSlo(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, IdpHashableAuthnBean[] authnBeans) {
        IdpSessionRegistrySupport.registerSessionForSlo(req, resp, stateParams, authnBeans, null);
    }

    public static void registerSessionForSlo(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, IdpHashableAuthnBean[] authnBeans, Session session) {
        try {
            IdpSessionRegistry idpSessionRegistry = IdpSessionRegistrySupport.getRegistry();
            boolean isFirst = true;
            for (IdpHashableAuthnBean authnBean : authnBeans) {
                if (authnBean == null) continue;
                if (authnBean.getAuthnSourceKey().getType() == AuthnSourceKey.AuthnSourceType.ADAPTER) {
                    authnBean.setDoLogout(true);
                }
                String[] extendedSessionIds = IdpSessionRegistrySupport.getExtendedSessionIds(req, resp, false);
                IdpHashableAuthnBean authnBeanCopy = IdpHashableAuthnBean.copy(authnBean);
                long sessionSeriesId = IdpSessionRegistrySupport.getSessionSeriesId(req, resp, stateParams);
                idpSessionRegistry.registerSessionIssued(extendedSessionIds[0], extendedSessionIds[1], sessionSeriesId, authnBeanCopy, isFirst ? session : null, Collections.emptySet());
                isFirst = false;
            }
        }
        catch (GeneralServiceException e) {
            throw new ProcessRuntimeException("Unable to register issued assertion/session", e);
        }
    }

    public static void unregisterSession(String assertionId) {
        try {
            IdpSessionRegistrySupport.getRegistry().unregisterSessions(Collections.singleton(assertionId));
        }
        catch (SessionRegistryException e) {
            throw new ProcessRuntimeException("Problem to unregistering issued assertion/session", e);
        }
    }

    public static Map<IdpHashableAuthnBean, Collection<Session>> getIssuedSessions(Collection<IdpHashableAuthnBean> authnBeans) {
        try {
            IdpSessionRegistry idpSessionRegistry = IdpSessionRegistrySupport.getRegistry();
            return idpSessionRegistry.getIssuedSessions(new ArrayList<IdpHashableAuthnBean>(authnBeans));
        }
        catch (GeneralServiceException e) {
            throw new ProcessRuntimeException("Unable to lookup issued assertions/sessions", e);
        }
    }

    public static void unregisterSessions(Collection<String> assertionIds) {
        try {
            IdpSessionRegistrySupport.getRegistry().unregisterSessions(assertionIds);
        }
        catch (GeneralServiceException e) {
            throw new ProcessRuntimeException("Problem to unregistering issued assertion/session", e);
        }
    }

    public static void setBeanInvalidForSso(String extendedSriStr, String authnBeanSerializedHash) throws SessionRegistryException, SessionStorageException {
        ExtendedSri extendedSri = new ExtendedSri(extendedSriStr);
        AuthnSessionInfo authnSessionInfo = IdpSessionRegistrySupport.getAuthnSessionInfoBySri(extendedSriStr, false, true);
        IdpHashableAuthnBean matchingBean = authnSessionInfo.getBeans().stream().filter(idpHashableAuthnBean -> idpHashableAuthnBean.getSerializedHash().equals(authnBeanSerializedHash)).findFirst().orElse(null);
        if (matchingBean != null) {
            IdpSessionRegistrySupport.setBeanInvalidForSso(extendedSri, matchingBean);
        }
    }

    public static void unregisterSessions(IdpHashableAuthnBean bean, Collection<? extends Session> sessions) {
        try {
            if (!sessions.isEmpty()) {
                IdpSessionRegistrySupport.getRegistry().unregisterSessions(bean, sessions);
            }
        }
        catch (GeneralServiceException e) {
            throw new ProcessRuntimeException("Problem unregistering issued sessions", e);
        }
    }

    public static Map<IdpHashableAuthnBean, Collection<Session>> getRegisteredForAssertionIds(String ... assertionIds) {
        try {
            IdpSessionRegistry idpSessionRegistry = IdpSessionRegistrySupport.getRegistry();
            return idpSessionRegistry.getRegisteredByAssertionIds(Arrays.asList(assertionIds));
        }
        catch (GeneralServiceException e) {
            log.error((Object)("Unable to lookup authn for session index(s) " + Arrays.toString(assertionIds)), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static boolean hasSessions(HttpServletRequest req, HttpServletResponse resp) {
        return !IdpSessionRegistrySupport.getRegisteredForSession(req, resp).isEmpty();
    }

    public static Map<IdpHashableAuthnBean, Collection<Session>> getRegisteredForSession(HttpServletRequest req, HttpServletResponse resp) {
        String extendedSessionId = StateMgmtFactory.getExtendedSessionId(req, resp);
        try {
            IdpSessionRegistry idpSessionRegistry = IdpSessionRegistrySupport.getRegistry();
            return idpSessionRegistry.getRegistered(extendedSessionId);
        }
        catch (GeneralServiceException e) {
            log.error((Object)("Unable to lookup authn for extended session id " + extendedSessionId), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static void unregisterAuthnBean(IdpHashableAuthnBean bean) {
        IdpSessionRegistry idpSessionRegistry = IdpSessionRegistrySupport.getRegistry();
        try {
            idpSessionRegistry.unregisterAuthnBean(bean);
        }
        catch (GeneralServiceException e) {
            log.error((Object)("Unable to unregister authn bean " + bean), (Throwable)e);
        }
    }

    public static AuthnSessionSettings getAuthnSessionSettings(AuthnSourceKey source, DeviceSharingType deviceSharingType) {
        if (source.getType() == AuthnSourceKey.AuthnSourceType.LOCAL_IDENTITY) {
            return new AuthnSessionSettings();
        }
        if (deviceSharingType == null) {
            deviceSharingType = DeviceSharingType.UNSPECIFIED;
        }
        return MgmtFactory.getAuthnSessionPolicyManager().getEffectiveSettings(source, deviceSharingType);
    }

    public static void updateLastActivityTime(String extendedSri) throws SessionRegistryException {
        IdpSessionRegistrySupport.getAuthnSessionInfoBySri(extendedSri, true, false);
    }

    public static boolean hasValidAuthnSession(String extendedSri, boolean updateActivityTime) {
        AuthnSessionInfo authnSessionInfo = IdpSessionRegistrySupport.getAuthnSessionInfoBySri(extendedSri, updateActivityTime, false);
        if (updateActivityTime) {
            IdpSessionRegistrySupport.checkUpdateCachedSessionGroupInfos(authnSessionInfo.getSessionGroupStatuses(), extendedSri, null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("hasValidAuthnSession(" + extendedSri + ") returning " + authnSessionInfo.hasAuthnSessions()));
        }
        return authnSessionInfo.hasAuthnSessions();
    }

    public static IdpHashableAuthnBean getRegisteredAuthnSession(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params, AuthnSourceKey source, String requestedUserId, String virtualServerId, AuthnPolicy authnPolicy) {
        if (authnPolicy.reauthenticate()) {
            return null;
        }
        AuthnSessionPolicyManager authnSessionPolicyManager = MgmtFactory.getAuthnSessionPolicyManager();
        Set<IdpHashableAuthnBean> allBeans = IdpSessionRegistrySupport.getAuthnSessions(req, resp, params, source, requestedUserId, virtualServerId, authnPolicy);
        for (IdpHashableAuthnBean bean : allBeans) {
            AuthnSessionSettings authnSessionSettings = authnSessionPolicyManager.getEffectiveSettings(source, bean.getDeviceSharingType());
            if (!authnSessionSettings.isEnableSessions()) continue;
            if (log.isDebugEnabled()) {
                String creationTimestamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date(bean.getCreationTimeMillis()));
                log.debug((Object)("Returning existing session " + bean + " (creationTime=" + creationTimestamp + ") for authn source " + source));
            }
            return bean;
        }
        return null;
    }

    public static Set<IdpHashableAuthnBean> getAuthnSessions(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params, AuthnPolicy authnPolicy) {
        return IdpSessionRegistrySupport.getAuthnSessions(req, resp, params, null, null, null, authnPolicy);
    }

    public static Set<IdpHashableAuthnBean> getAuthnSessions(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params, AuthnSourceKey sourceKey, String requestedUserId, String virtualServerId, AuthnPolicy authnPolicy) {
        HashSet<IdpHashableAuthnBean> tempResult = new HashSet<IdpHashableAuthnBean>();
        Set<IdpHashableAuthnBean> beans = IdpSessionRegistrySupport.getAuthnSessionInfo(req, resp, params).getBeans();
        if (authnPolicy.reauthenticate()) {
            return tempResult;
        }
        for (IdpHashableAuthnBean bean : beans) {
            if (!IdpSessionRegistrySupport.sessionMatches(bean, sourceKey, requestedUserId, virtualServerId, authnPolicy)) continue;
            AuthnSourceKey aSourceKey = bean.getAuthnSourceKey();
            IdpHashableAuthnBean prevSession = tempResult.stream().filter(resultBean -> resultBean.getAuthnSourceKey().equalsIncludeAllFields(aSourceKey) && resultBean.getDeviceSharingType() == bean.getDeviceSharingType()).findFirst().orElse(null);
            if (prevSession != null && bean.getCreationTimeMillis() <= prevSession.getCreationTimeMillis()) continue;
            if (prevSession != null) {
                tempResult.remove(prevSession);
            }
            tempResult.add(bean);
        }
        HashSet<IdpHashableAuthnBean> result = new HashSet<IdpHashableAuthnBean>();
        for (IdpHashableAuthnBean bean : tempResult) {
            result.add(IdpHashableAuthnBean.copy(bean));
        }
        return result;
    }

    public static Set<String> getSrisForIssuerAndSid(String issuer, String sid) {
        String key = IdpSessionRegistrySupport.makeIssuerAndSidKey(issuer, sid);
        return StateMgmtFactory.getInterRequestStateMgmt().getSetAttribute(key);
    }

    public static Set<String> getSrisForIssuerAndSubject(String issuer, String subject) {
        String key = IdpSessionRegistrySupport.makeIssuerAndSubjectKey(issuer, subject);
        return StateMgmtFactory.getInterRequestStateMgmt().getSetAttribute(key);
    }

    public static Set<String> retrieveAndRemoveSris(String issuer, String subject, String sid) {
        Set<String> sris = new HashSet<String>();
        if (subject != null) {
            sris.addAll(IdpSessionRegistrySupport.getSrisForIssuerAndSubject(issuer, subject));
        }
        if (sid != null) {
            Set<String> srisForSid = IdpSessionRegistrySupport.getSrisForIssuerAndSid(issuer, sid);
            if (subject != null) {
                sris.retainAll(srisForSid);
            } else {
                sris = srisForSid;
            }
        }
        if (subject != null) {
            IdpSessionRegistrySupport.removeSrisForIssuerAndSubject(issuer, subject, sris);
        }
        if (sid != null) {
            IdpSessionRegistrySupport.removeSrisForIssuerAndSid(issuer, sid, sris);
        }
        return sris;
    }

    public static Set<String> getIndexKeysForBean(IdpHashableAuthnBean bean) {
        if (!(bean instanceof IdpConnHashableAuthnBean)) {
            return Collections.emptySet();
        }
        HashSet<String> indexKeysForBean = new HashSet<String>();
        IdpConnHashableAuthnBean idpConnBean = (IdpConnHashableAuthnBean)bean;
        IdpConnection idpConn = MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(idpConnBean.getAuthnSourceKey().getId(), false);
        if (idpConn != null && idpConn.getProtocol().equals(Protocol.OIDC) && idpConn.getOidcSettings().isTrackUserSessionsForLogout()) {
            String key;
            if (idpConnBean.getIssuer() != null && idpConnBean.getSubject() != null) {
                key = IdpSessionRegistrySupport.makeIssuerAndSubjectKey(idpConnBean.getIssuer(), idpConnBean.getSubject());
                indexKeysForBean.add(key);
            }
            if (idpConnBean.getIssuer() != null && idpConnBean.getSid() != null) {
                key = IdpSessionRegistrySupport.makeIssuerAndSidKey(idpConnBean.getIssuer(), idpConnBean.getSid());
                indexKeysForBean.add(key);
            }
        }
        return indexKeysForBean;
    }

    private static void setBeanInvalidForSso(ExtendedSri extendedSri, IdpHashableAuthnBean bean) throws SessionRegistryException, SessionStorageException {
        IdpSessionRegistrySupport.getRegistry().setBeanInvalidForSso(extendedSri.getExtendedSri(), bean.getSerializedHash());
        try {
            StateMgmtFactory.getStoredSessionService().deleteAuthnSession(bean.getStoredSessionGroupId(), bean.getSerializedHash());
        }
        catch (SessionStorageException e) {
            IdpAuditLogger.logAuthnSourceSessionDeleted(extendedSri, bean.getAuthnSourceKey(), "User session for authentication source deleted from memory, but unable to remove from persistent session storage");
            throw e;
        }
        IdpAuditLogger.logAuthnSourceSessionDeleted(extendedSri, bean.getAuthnSourceKey(), "User session for authentication source deleted");
    }

    private static void removeSrisForIssuerAndSubject(String issuer, String subject, Collection<String> extendedSris) {
        String key = IdpSessionRegistrySupport.makeIssuerAndSubjectKey(issuer, subject);
        StateMgmtFactory.getInterRequestStateMgmt().removeFromSetAttribute(key, extendedSris, false);
    }

    private static void removeSrisForIssuerAndSid(String issuer, String sid, Collection<String> extendedSris) {
        String key = IdpSessionRegistrySupport.makeIssuerAndSidKey(issuer, sid);
        StateMgmtFactory.getInterRequestStateMgmt().removeFromSetAttribute(key, extendedSris, false);
    }

    private static void checkUpdateOidcLogoutIndexes(Set<String> indexKeysToUpdate, String extendedSri) {
        for (String indexKey : indexKeysToUpdate) {
            StateMgmtFactory.getInterRequestStateMgmt().addToSetAttribute(indexKey, Collections.singleton(extendedSri), false);
        }
    }

    private static String makeIssuerAndSubjectKey(String issuer, String subject) {
        HashMap<String, String> indexFields = new HashMap<String, String>();
        indexFields.put(INDEX_TYPE, OIDC_LOGOUT);
        indexFields.put(ISSUER, issuer);
        indexFields.put(SUBJECT, subject);
        try {
            return JsonUtils.getInstance().writeValueAsString(indexFields);
        }
        catch (JsonProcessingException e) {
            throw new ProcessRuntimeException("Unexpected error serializing index key", e);
        }
    }

    private static String makeIssuerAndSidKey(String issuer, String sid) {
        HashMap<String, String> indexFields = new HashMap<String, String>();
        indexFields.put(INDEX_TYPE, OIDC_LOGOUT);
        indexFields.put(ISSUER, issuer);
        indexFields.put(SID, sid);
        try {
            return JsonUtils.getInstance().writeValueAsString(indexFields);
        }
        catch (JsonProcessingException e) {
            throw new ProcessRuntimeException("Unexpected error serializing index key", e);
        }
    }

    private static boolean sessionMatches(IdpHashableAuthnBean bean, AuthnSourceKey sourceKey, String requestedUserId, String virtualServerId, AuthnPolicy authnPolicy) {
        if (sourceKey != null && !sourceKey.equalsIncludeAllFields(bean.getAuthnSourceKey())) {
            return false;
        }
        AuthnSessionSettings settings = MgmtFactory.getAuthnSessionPolicyManager().getEffectiveSettings(bean.getAuthnSourceKey(), bean.getDeviceSharingType());
        if (!settings.isEnableSessions()) {
            return false;
        }
        if (settings.isAuthnContextSensitive() && !IdpSessionRegistrySupport.sessionMatchesRequestedAuthnContexts(bean, authnPolicy.getRequestAuthnContexts())) {
            return false;
        }
        if (requestedUserId != null && !requestedUserId.equals(bean.getRequestedUserId())) {
            return false;
        }
        if (bean instanceof IdpConnHashableAuthnBean) {
            IdpConnHashableAuthnBean idpConnBean = (IdpConnHashableAuthnBean)bean;
            if (virtualServerId != null && !StringUtils.equals((String)idpConnBean.getVirtualServerId(), (String)virtualServerId)) {
                return false;
            }
        }
        return true;
    }

    public static SessionInfoForPartnerSessionsResult getSessionInfoForPartnerSessions(String partnerEntityId, NameIDType nameId, Collection<String> sessionIndices) {
        try {
            return IdpSessionRegistrySupport.getRegistry().getSessionInfoForPartnerSessions(partnerEntityId, nameId, sessionIndices);
        }
        catch (SessionRegistryException e) {
            throw new ProcessRuntimeException("Unexpected error retrieving session ID's for partner sessions", e);
        }
    }

    public static long getSessionSeriesId(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) {
        if (!MgmtFactory.getAuthnSessionPolicyManager().hasAuthnSessionConfig()) {
            return 0L;
        }
        return IdpSessionRegistrySupport.getAuthnSessionInfo(req, resp, params).getSessionSeriesId();
    }

    public static Map<String, AuthnSessionInfo> getAuthnSessionInfoByUniqueUserKey(String uniqueUserKey) {
        HashMap<String, AuthnSessionInfo> sriToSessionInfos = new HashMap<String, AuthnSessionInfo>();
        Collection<String> srisWithUserKey = IdpSessionRegistrySupport.getSrisForUniqueUserKey(uniqueUserKey);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieved " + srisWithUserKey.size() + " SRIs for unique user key."));
        }
        for (String extendedSri : srisWithUserKey) {
            sriToSessionInfos.put(extendedSri, IdpSessionRegistrySupport.getAuthnSessionInfoBySri(extendedSri, false, true));
        }
        return sriToSessionInfos;
    }

    public static AuthnSessionInfo getAuthnSessionInfoBySri(String extendedSriStr, boolean updateActivityTime, boolean includeBeans) {
        AuthnSessionInfo result;
        AuthnSessionInfo info;
        long lastActivityTimeMillis = 0L;
        ExtendedSri extendedSri = new ExtendedSri(extendedSriStr);
        try {
            info = IdpSessionRegistrySupport.getRegistry().getAuthnSessionInfoBySri(extendedSriStr, updateActivityTime, includeBeans ? BeanFilter.AUTHN_SESSIONS : BeanFilter.NO_BEANS);
        }
        catch (SessionRegistryException e) {
            throw new ProcessRuntimeException("Error getting authn session info", e);
        }
        boolean sessionSeriesMatch = StringUtils.equals((String)extendedSri.getEncodedSeriesId(), (String)ExtendedSri.encodeSeriesId(info.getSessionSeriesId()));
        if (!sessionSeriesMatch && info.hasAuthnSessions() && log.isDebugEnabled()) {
            log.debug((Object)("Stored encoded session series ID " + ExtendedSri.encodeSeriesId(info.getSessionSeriesId()) + " does not match SRI value " + extendedSri.getEncodedSeriesId()));
        }
        Set<IdpHashableAuthnBean> authnSessions = sessionSeriesMatch ? info.getBeans().stream().filter(IdpHashableAuthnBean::isValidForSso).collect(Collectors.toSet()) : Collections.emptySet();
        boolean hasAuthnSessions = sessionSeriesMatch ? info.hasAuthnSessions() : false;
        long sessionSeriesId = info.getSessionSeriesId();
        String persistentSessionGroupId = info.getPersistentSessionGroupId();
        lastActivityTimeMillis = info.getLastActivityTimeMillis();
        ArrayList<CachedSessionGroupInfo> cachedSessionGroupInfos = new ArrayList<CachedSessionGroupInfo>();
        Set<String> uniqueUserKeys = info.getUniqueUserKeys();
        AuthnSessionContextData sessionContextData = info.getSessionContextData();
        if (hasAuthnSessions) {
            if (updateActivityTime) {
                IdpSessionRegistrySupport.checkUpdateCachedSessionGroupInfos(info.getSessionGroupStatuses(), extendedSriStr, null);
            }
        } else {
            long metaDataSessionSeriesId = 0L;
            try {
                SessionGroupAndSessions groupAndSessions = StateMgmtFactory.getStoredSessionService().getSessionGroupAndSessions(extendedSri.getPersistentSessionGroupId(), updateActivityTime);
                if (groupAndSessions != null) {
                    String encodedStoredSessionSessionSeriesId;
                    metaDataSessionSeriesId = IdpSessionRegistrySupport.getSessionSeriesIdFromMetadata(groupAndSessions);
                    String string = encodedStoredSessionSessionSeriesId = metaDataSessionSeriesId == 0L ? null : ExtendedSri.encodeSeriesId(metaDataSessionSeriesId);
                    if (StringUtils.equals((String)extendedSri.getEncodedSeriesId(), (String)encodedStoredSessionSessionSeriesId)) {
                        uniqueUserKeys = groupAndSessions.getUniqueUserIds();
                        authnSessions = groupAndSessions.getAuthnSessions();
                        sessionSeriesId = metaDataSessionSeriesId;
                        persistentSessionGroupId = groupAndSessions.getSessionGroupInfo().getId();
                        lastActivityTimeMillis = groupAndSessions.getSessionGroupInfo().getLastActivityTimeMillis();
                        sessionContextData = groupAndSessions.getSessionGroupInfo().getContextData();
                        cachedSessionGroupInfos.add(new CachedSessionGroupInfo(groupAndSessions.getSessionGroupInfo()));
                    }
                }
            }
            catch (SessionStorageException e) {
                log.error((Object)"Error retrieving stored authn sessions", (Throwable)e);
            }
            if (!authnSessions.isEmpty()) {
                Set<IdpHashableAuthnBean> beansMatchingSriList = authnSessions.stream().filter(bean -> sessionIdUtil.getSriFromPrimaryValue(bean.getPrimarySessionId()).equals(extendedSri.getSri())).collect(Collectors.toSet());
                beansMatchingSriList.forEach(bean -> bean.setDoLogout(false));
                if (!beansMatchingSriList.isEmpty()) {
                    String primarySessionId = ((IdpHashableAuthnBean)beansMatchingSriList.iterator().next()).getPrimarySessionId();
                    String secondaryValue = SessionIdUtil.getInstance().newValue();
                    try {
                        IdpSessionRegistrySupport.getRegistry().registerBeans(null, primarySessionId + secondaryValue, metaDataSessionSeriesId, lastActivityTimeMillis, beansMatchingSriList, cachedSessionGroupInfos, uniqueUserKeys, sessionContextData);
                    }
                    catch (SessionRegistryException e) {
                        throw new ProcessRuntimeException("Error caching stored sessions", e);
                    }
                }
            }
        }
        if (includeBeans) {
            result = new AuthnSessionInfoImpl.Builder().setSessionSeriesId(sessionSeriesId).setBeans(authnSessions).setPersistentSessionGroupId(persistentSessionGroupId).setSessionGroupStatuses(info.getSessionGroupStatuses()).setLastActivityTimeMillis(lastActivityTimeMillis).setUniqueUserKeys(uniqueUserKeys).setSessionContextData(sessionContextData).setIndexKeysToRefresh(Collections.emptySet()).build();
        } else {
            hasAuthnSessions = hasAuthnSessions || !authnSessions.isEmpty();
            result = new AuthnSessionInfoWithoutBeansImpl.Builder().setSessionSeriesId(sessionSeriesId).setHasAuthnSessions(hasAuthnSessions).setPersistentSessionGroupId(persistentSessionGroupId).setSessionGroupStatuses(info.getSessionGroupStatuses()).setLastActivityTimeMillis(lastActivityTimeMillis).setUniqueUserKeys(uniqueUserKeys).setSessionContextData(sessionContextData).setIndexKeysToRefresh(Collections.emptySet()).build();
        }
        IdpSessionRegistrySupport.debugLogSessionInfo(result, extendedSriStr);
        if (updateActivityTime) {
            String extendedSriToAssociate = sessionIdUtil.makeExtendedSriV2WithSri(extendedSri.getSri(), sessionSeriesId, persistentSessionGroupId);
            if (!authnSessions.isEmpty()) {
                IdpSessionRegistrySupport.registerSriToUniqueUserKeys(uniqueUserKeys, extendedSriToAssociate);
            }
            IdpSessionRegistrySupport.checkUpdateOidcLogoutIndexes(info.getIndexKeysToRefresh(), extendedSriToAssociate);
        }
        IdpAuditLogger.setUniqueUserKeyAuditLogFields(uniqueUserKeys);
        return result;
    }

    public static AuthnSessionInfo getAuthnSessionInfoForLogout(String sri) {
        try {
            return IdpSessionRegistrySupport.getRegistry().getAuthnSessionInfoBySri(sri, false, BeanFilter.ALL_BEANS);
        }
        catch (SessionRegistryException e) {
            throw new ProcessRuntimeException("Error getting session info for logout", e);
        }
    }

    private static long getSessionSeriesIdFromMetadata(SessionGroupAndSessions groupAndSessions) {
        return Optional.ofNullable(groupAndSessions.getSessionGroupInfo()).map(SessionGroupInfo::getSessionSeriesId).orElse(0L);
    }

    public static AuthnSessionInfo getAuthnSessionInfo(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) {
        String extendedSessionId = StateMgmtFactory.getExtendedSessionId(req, resp);
        AuthnSessionInfo info = null;
        if (params != null) {
            info = (AuthnSessionInfo)params.get(KEY_AUTHN_SESSION_INFO);
        }
        if (info != null) {
            IdpSessionRegistrySupport.populateSessionAuditLogFields(StateMgmtFactory.getLocalSessionId(req, resp), info);
            return info;
        }
        StateMgmtFactory.getHashedPersistentSessionId(req, resp);
        try {
            info = IdpSessionRegistrySupport.getRegistry().getAuthnSessionInfo(extendedSessionId);
        }
        catch (SessionRegistryException e) {
            throw new ProcessRuntimeException("Error getting authn session info", e);
        }
        Set<IdpHashableAuthnBean> authnSessions = info.getBeans().stream().filter(bean -> bean.isValidForSso()).collect(Collectors.toSet());
        long sessionSeriesId = info.getSessionSeriesId();
        String persistentSessionGroupId = info.getPersistentSessionGroupId();
        ArrayList<CachedSessionGroupInfo> cachedSessionGroupInfos = new ArrayList<CachedSessionGroupInfo>();
        Set<String> uniqueUserKeys = info.getUniqueUserKeys();
        AuthnSessionContextData prevSessionContextData = null;
        AuthnSessionContextData newSessionContextData = AuthnSessionContextDataUtil.createContextData(req);
        boolean isSessionFromSessionStorage = false;
        if (authnSessions.isEmpty()) {
            sessionSeriesId = 0L;
        }
        if (!authnSessions.isEmpty()) {
            IdpSessionRegistrySupport.checkUpdateCachedSessionGroupInfos(info.getSessionGroupStatuses(), StateMgmtFactory.getExtendedSri(req, resp), params);
            prevSessionContextData = info.getSessionContextData();
        } else {
            try {
                SessionGroupAndSessions groupAndSessions = StateMgmtFactory.getStoredSessionService().getSessionGroupAndSessions(req, resp, params);
                if (groupAndSessions != null) {
                    isSessionFromSessionStorage = true;
                    uniqueUserKeys = groupAndSessions.getUniqueUserIds();
                    authnSessions = groupAndSessions.getAuthnSessions();
                    sessionSeriesId = IdpSessionRegistrySupport.getSessionSeriesIdFromMetadata(groupAndSessions);
                    persistentSessionGroupId = groupAndSessions.getSessionGroupInfo().getId();
                    cachedSessionGroupInfos.add(new CachedSessionGroupInfo(groupAndSessions.getSessionGroupInfo()));
                    prevSessionContextData = groupAndSessions.getSessionGroupInfo().getContextData();
                }
            }
            catch (SessionStorageException e) {
                log.error((Object)"Error retrieving stored authn sessions", (Throwable)e);
            }
            if (!authnSessions.isEmpty()) {
                String[] extendedSessionIds = IdpSessionRegistrySupport.getExtendedSessionIds(req, resp, true);
                try {
                    String primarySessionId = StateMgmtFactory.getLocalSessionId(req, resp);
                    authnSessions.stream().forEach(bean -> bean.setPrimarySessionId(primarySessionId));
                    authnSessions.stream().forEach(bean -> bean.setDoLogout(false));
                    IdpSessionRegistrySupport.getRegistry().registerBeans(extendedSessionIds[0], extendedSessionIds[1], sessionSeriesId, 0L, authnSessions, cachedSessionGroupInfos, uniqueUserKeys, newSessionContextData);
                }
                catch (SessionRegistryException e) {
                    throw new ProcessRuntimeException("Error caching stored sessions", e);
                }
            }
        }
        String primarySessionId = StateMgmtFactory.getLocalSessionId(req, resp);
        AuthnSessionInfo result = new AuthnSessionInfoImpl.Builder().setSessionSeriesId(sessionSeriesId).setBeans(authnSessions).setPersistentSessionGroupId(persistentSessionGroupId).setSessionGroupStatuses(info.getSessionGroupStatuses()).setLastActivityTimeMillis(info.getLastActivityTimeMillis()).setUniqueUserKeys(uniqueUserKeys).setSessionContextData(newSessionContextData).setIndexKeysToRefresh(Collections.emptySet()).build();
        IdpSessionRegistrySupport.populateSessionAuditLogFields(primarySessionId, result);
        IdpSessionRegistrySupport.logSessionInfo(primarySessionId, result);
        String extendedSri = sessionIdUtil.makeExtendedSriV2(primarySessionId, sessionSeriesId, persistentSessionGroupId);
        if (!authnSessions.isEmpty()) {
            IdpSessionRegistrySupport.registerSriToUniqueUserKeys(uniqueUserKeys, extendedSri);
            if (prevSessionContextData == null || !prevSessionContextData.equals(newSessionContextData)) {
                if (!isSessionFromSessionStorage) {
                    IdpSessionRegistrySupport.getRegistry().updateSessionContextInfo(extendedSessionId, newSessionContextData);
                }
                try {
                    StateMgmtFactory.getStoredSessionService().updateMetadata(req, resp, params, newSessionContextData);
                }
                catch (SessionStorageException e) {
                    log.error((Object)"Error updating stored authn sessions metadata", (Throwable)e);
                }
            }
        }
        IdpSessionRegistrySupport.checkUpdateOidcLogoutIndexes(info.getIndexKeysToRefresh(), extendedSri);
        if (params != null) {
            params.put(KEY_AUTHN_SESSION_INFO, result);
        }
        return result;
    }

    static void registerSriToUniqueUserKeys(Set<String> uniqueUserKeys, String extendedSriStr) {
        if (uniqueUserKeys != null) {
            for (String userKey : uniqueUserKeys) {
                IdpSessionRegistrySupport.registerSriToUniqueUserKey(extendedSriStr, userKey);
            }
        }
    }

    private static void registerSriToUniqueUserKey(String extendedSri, String uniqueUserKey) {
        Collection<String> srisToPurge = IdpSessionRegistrySupport.getRegistry().registerSriToUniqueUserKey(uniqueUserKey, extendedSri);
        for (String toPurge : srisToPurge) {
            try {
                ExtendedSri toPurgeExtendedSri = new ExtendedSri(toPurge);
                String sri = toPurgeExtendedSri.getSri();
                StateMgmtFactory.getSessionRevocationService().addRevokedSri(sri);
                IdpAuditLogger.logSessionRevocationByUserKey(toPurgeExtendedSri, null, "Purged SRI from user key to SRIs associations.");
            }
            catch (InvalidParameterException invalidParameterException) {
                // empty catch block
            }
            IdpSessionRegistrySupport.getRegistry().unregisterSriFromUniqueUserKey(uniqueUserKey, toPurge);
        }
    }

    private static void populateSessionAuditLogFields(String primarySessionId, AuthnSessionInfo authnSessionInfo) {
        String extendedSri = SessionIdUtil.getInstance().makeExtendedSriV2(primarySessionId, authnSessionInfo.getSessionSeriesId(), authnSessionInfo.getPersistentSessionGroupId());
        IdpSessionRegistrySupport.populateSessionAuditLogFieldsWithSri(extendedSri, authnSessionInfo);
    }

    private static void populateSessionAuditLogFieldsWithSri(String extendedSriStr, AuthnSessionInfo authnSessionInfo) {
        ExtendedSri extendedSri = new ExtendedSri(extendedSriStr);
        AuditLogger.setExtendedSri(extendedSri);
        IdpAuditLogger.setUniqueUserKeyAuditLogFields(authnSessionInfo.getUniqueUserKeys());
    }

    private static void logSessionInfo(String primarySessionId, AuthnSessionInfo authnSessionInfo) {
        IdpSessionRegistrySupport.populateSessionAuditLogFields(primarySessionId, authnSessionInfo);
        String sri = SessionIdUtil.getInstance().makeExtendedSriV2(primarySessionId, authnSessionInfo.getSessionSeriesId(), authnSessionInfo.getPersistentSessionGroupId());
        IdpSessionRegistrySupport.debugLogSessionInfo(authnSessionInfo, sri);
    }

    private static void debugLogSessionInfo(AuthnSessionInfo authnSessionInfo, String sri) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SRI: " + sri));
        }
        if (authnSessionInfo.getPersistentSessionGroupId() != null && log.isDebugEnabled()) {
            log.debug((Object)("Persistent session group ID: " + authnSessionInfo.getPersistentSessionGroupId()));
        }
    }

    private static void checkUpdateCachedSessionGroupInfos(Collection<CachedSessionGroupStatus> sessionGroupStatuses, String extendedSri, Map<String, Object> params) {
        block4: {
            try {
                Collection<CachedSessionGroupInfo> sessionGroupInfos = StateMgmtFactory.getStoredSessionService().checkUpdateCachedSessionGroupInfos(sessionGroupStatuses, params);
                if (sessionGroupInfos.isEmpty()) break block4;
                try {
                    IdpSessionRegistrySupport.getRegistry().updateCachedSessionGroupInfos(extendedSri, sessionGroupInfos);
                }
                catch (SessionRegistryException e) {
                    throw new ProcessRuntimeException("Error updating stored last activity time", e);
                }
            }
            catch (SessionStorageException e) {
                log.error((Object)"Error updating last activity time for stored sessions", (Throwable)e);
            }
        }
    }

    private static void clearAuthnSessionsFromParams(Map<String, Object> params, Set<IdpHashableAuthnBean> invalidBeans) {
        LinkedList cumulativeAuthnBeans;
        AuthnSessionInfo info = (AuthnSessionInfo)params.get(KEY_AUTHN_SESSION_INFO);
        if (info != null) {
            info.getBeans().removeAll(invalidBeans);
        }
        if ((cumulativeAuthnBeans = (LinkedList)params.get("cumulativeAuthnBeans")) != null) {
            for (IdpHashableAuthnBean bean : cumulativeAuthnBeans) {
                if (!invalidBeans.contains(bean)) continue;
                bean.setValidForSso(false);
            }
        }
    }

    private static long getNewSessionSeriesId() {
        return DateTimeUtils.currentTimeMillis() / 1000L;
    }

    public static void checkRegisterAuthnBean(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params, IdpHashableAuthnBean bean, Long notOnOrAfterMillis, boolean checkRegisterForSso, boolean mustRegisterForSlo) throws SessionQuotaException {
        IdpSessionRegistrySupport.getAuthnSessionInfo(req, resp, params);
        boolean isPasswordUpdate = params != null && ("com.pingidentity.pf.passwordreset".equals(params.get("adapterAction")) || "com.pingidentity.pf.change.password".equals(params.get("adapterAction")));
        boolean checkAuthnBeanRegisterForSso = checkRegisterForSso && !isPasswordUpdate;
        AuthenticationBeanRegistrationInfo registrationInfo = IdpSessionRegistrySupport.getAuthenticationBeanRegistrationInfo(req, resp, params, bean, notOnOrAfterMillis, checkAuthnBeanRegisterForSso, mustRegisterForSlo);
        try {
            if (registrationInfo != null) {
                registrationInfo.register(req, resp, params);
            }
        }
        catch (SessionRegistryException e) {
            throw new ProcessRuntimeException("Unexpected error registering authn bean", e);
        }
    }

    public static AuthenticationBeanRegistrationInfo getAuthenticationBeanRegistrationInfo(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params, IdpHashableAuthnBean bean, Long notOnOrAfterMillis, boolean checkRegisterForSso, boolean mustRegisterForSlo) {
        boolean register = false;
        boolean rollExtendedSessionId = false;
        if (notOnOrAfterMillis != null) {
            bean.setNotOnOrAfterMillis(notOnOrAfterMillis);
        }
        if (mustRegisterForSlo) {
            register = true;
            bean.setDoLogout(true);
        } else if ((bean.getAuthnSourceKey().getType().equals((Object)AuthnSourceKey.AuthnSourceType.ADAPTER) || bean.getAuthnSourceKey().getType().equals((Object)AuthnSourceKey.AuthnSourceType.LOCAL_IDENTITY)) && MgmtFactory.getSessionSettingsManager().getSessionSettings().isTrackAdapterSessionsForLogout()) {
            register = true;
            bean.setDoLogout(true);
        } else if (bean instanceof IdpConnHashableAuthnBean) {
            IdpConnHashableAuthnBean idpBean = (IdpConnHashableAuthnBean)bean;
            IdpConnection conn = MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(idpBean.getAuthnSourceKey().getId(), true);
            if (conn.supportsSLO() || conn.getProtocol() == Protocol.OIDC && conn.getOidcSettings().isTrackUserSessionsForLogout()) {
                register = true;
                bean.setDoLogout(true);
            }
        }
        boolean isPersistentSession = false;
        AuthnSessionSettings sourceSettings = IdpSessionRegistrySupport.getAuthnSessionSettings(bean.getAuthnSourceKey(), bean.getDeviceSharingType());
        if (checkRegisterForSso && sourceSettings.isEnableSessions()) {
            register = true;
            rollExtendedSessionId = true;
            bean.setValidForSso(true);
            bean.setOriginalIdleTimeoutMins(sourceSettings.getIdleTimeoutMins());
            if (sourceSettings.isEnableSessions() && sourceSettings.isPersistent()) {
                isPersistentSession = true;
            }
        }
        return register ? new AuthenticationBeanRegistrationInfo(rollExtendedSessionId, bean, isPersistentSession) : null;
    }

    public static void setInvalidForSso(Collection<IdpHashableAuthnBean> beans) {
        HashSet<String> sessionIds = new HashSet<String>();
        for (IdpHashableAuthnBean bean : beans) {
            bean.setValidForSso(false);
            sessionIds.add(bean.getPrimarySessionId());
        }
        IdpSessionRegistrySupport.setSessionBeansInvalidForSso(sessionIds);
    }

    public static void setSessionBeansInvalidForSso(Collection<String> primarySessionIds) {
        try {
            if (!primarySessionIds.isEmpty()) {
                IdpSessionRegistrySupport.getRegistry().setBeansInvalidForSso(primarySessionIds);
            }
        }
        catch (SessionRegistryException e) {
            throw new ProcessRuntimeException("Unexpected error invalidating beans", e);
        }
    }

    public static void setBeansInvalidForLogout(Collection<IdpHashableAuthnBean> beans) {
        try {
            IdpSessionRegistrySupport.getRegistry().setBeansInvalidForLogout(beans);
        }
        catch (SessionRegistryException e) {
            throw new ProcessRuntimeException("Unexpected error setting beans invalid for logout", e);
        }
    }

    public static void checkLogSessionDeleted(HttpServletRequest req, HttpServletResponse resp) {
        AuthnSessionInfo sessionInfo = IdpSessionRegistrySupport.getAuthnSessionInfo(req, resp, null);
        if (sessionInfo.hasAuthnSessions()) {
            IdpAuditLogger.logSessionDeleted();
        }
    }

    public static void checkLogSessionDeleted(String extendedSri, AuthnSessionInfo sessionInfo) {
        IdpSessionRegistrySupport.populateSessionAuditLogFieldsWithSri(extendedSri, sessionInfo);
        if (sessionInfo.hasAuthnSessions()) {
            IdpAuditLogger.logSessionDeleted();
        }
    }

    public static void deleteStoredSessions(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) {
        try {
            StateMgmtFactory.getStoredSessionService().deleteAuthnSessions(req, resp, params);
        }
        catch (SessionStorageException e) {
            log.error((Object)"An error occurred while deleting stored sessions", (Throwable)e);
        }
    }

    public static void deleteStoredSessions(Collection<String> storedSessionGroupIds) {
        try {
            if (!storedSessionGroupIds.isEmpty()) {
                StateMgmtFactory.getStoredSessionService().deleteAuthnSessions(storedSessionGroupIds);
            }
        }
        catch (SessionStorageException e) {
            log.error((Object)"An error occurred while deleting stored sessions", (Throwable)e);
        }
    }

    public static DeviceSharingType getDeviceSharingTypeFromStateParams(Map<String, Object> stateParams) {
        if (stateParams == null) {
            return DeviceSharingType.UNSPECIFIED;
        }
        DeviceSharingType deviceSharingType = (DeviceSharingType)stateParams.get(KEY_DEVICE_SHARING_TYPE);
        if (deviceSharingType == null) {
            return DeviceSharingType.UNSPECIFIED;
        }
        return deviceSharingType;
    }

    public static DeviceSharingType checkAndUpdateDeviceSharingType(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, DeviceSharingType returnedSharingType) {
        DeviceSharingType deviceSharingType = IdpSessionRegistrySupport.getDeviceSharingTypeFromStateParams(stateParams);
        if (returnedSharingType != DeviceSharingType.UNSPECIFIED && returnedSharingType != deviceSharingType) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authentication source set org.sourceid.saml20.adapter.idp.authn.deviceSharingType to " + returnedSharingType));
            }
            deviceSharingType = returnedSharingType;
            stateParams.put(KEY_DEVICE_SHARING_TYPE, deviceSharingType);
            IdpSessionRegistrySupport.pruneAuthnSessions(req, resp, stateParams, deviceSharingType);
        }
        return deviceSharingType;
    }

    private static void pruneAuthnSessions(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, DeviceSharingType deviceSharingType) {
        HashSet<IdpHashableAuthnBean> invalidBeans = new HashSet<IdpHashableAuthnBean>();
        ExtendedSri extendedSri = new ExtendedSri(sessionIdUtil.getExtendedSriV2(req, resp, stateParams));
        AuthnSessionInfo authnSessionInfo = IdpSessionRegistrySupport.getAuthnSessionInfo(req, resp, stateParams);
        HashSet<IdpHashableAuthnBean> allSessions = new HashSet<IdpHashableAuthnBean>(authnSessionInfo.getBeans());
        LinkedList cumulativeAuthnBeans = (LinkedList)stateParams.get("cumulativeAuthnBeans");
        if (cumulativeAuthnBeans != null) {
            allSessions.addAll(cumulativeAuthnBeans.stream().filter(bean -> bean.isValidForSso()).collect(Collectors.toSet()));
        }
        for (IdpHashableAuthnBean bean2 : allSessions) {
            List<AuthnSessionSettings> sessionSettingsList = MgmtFactory.getAuthnSessionPolicyManager().getEffectiveSettings(bean2.getAuthnSourceKey());
            if (IdpSessionRegistrySupport.isBeanValidForDeviceSharingType(sessionSettingsList, bean2, deviceSharingType)) continue;
            try {
                IdpSessionRegistrySupport.setBeanInvalidForSso(extendedSri, bean2);
                invalidBeans.add(bean2);
            }
            catch (SessionRegistryException | SessionStorageException e) {
                log.error((Object)"Unexpected error while pruning authentication sessions", e);
            }
        }
        if (!invalidBeans.isEmpty()) {
            IdpSessionRegistrySupport.clearAuthnSessionsFromParams(stateParams, invalidBeans);
        }
    }

    private static boolean isBeanValidForDeviceSharingType(List<AuthnSessionSettings> sessionSettingsList, IdpHashableAuthnBean bean, DeviceSharingType deviceSharingType) {
        return sessionSettingsList.stream().anyMatch(sessionSettings -> sessionSettings.isEnableSessions() && sessionSettings.getUserDeviceType().matches(bean.getDeviceSharingType()) && sessionSettings.getUserDeviceType().matches(deviceSharingType));
    }

    public static DeviceSharingType getDeviceSharingType(Map<String, Object> authnIdentifiers) {
        String value;
        String string = value = authnIdentifiers != null ? (String)authnIdentifiers.get("org.sourceid.saml20.adapter.idp.authn.deviceSharingType") : null;
        if (value == null) {
            return DeviceSharingType.UNSPECIFIED;
        }
        try {
            return DeviceSharingType.valueOf((String)value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Unexpected value for attribute org.sourceid.saml20.adapter.idp.authn.deviceSharingType: " + value));
            return DeviceSharingType.UNSPECIFIED;
        }
    }

    public static DeviceSharingType getDeviceSharingType(AttributeMap attributeMap) {
        AttributeValue attrValue;
        AttributeValue attributeValue = attrValue = attributeMap != null ? (AttributeValue)attributeMap.get((Object)"org.sourceid.saml20.adapter.idp.authn.deviceSharingType") : null;
        if (attrValue == null) {
            return DeviceSharingType.UNSPECIFIED;
        }
        String attrValueStr = attrValue.getValue();
        if (attrValueStr != null) {
            attrValueStr = attrValueStr.trim().toUpperCase();
        }
        try {
            return DeviceSharingType.valueOf((String)attrValueStr);
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Unexpected value for attribute org.sourceid.saml20.adapter.idp.authn.deviceSharingType: " + attrValueStr));
            return DeviceSharingType.UNSPECIFIED;
        }
    }

    private static boolean sessionMatchesRequestedAuthnContexts(IdpHashableAuthnBean bean, List<String> requestedContexts) {
        String authnCtx;
        if (Util.isEmpty(requestedContexts)) {
            return true;
        }
        AttributeValue authnCtxValue = bean.getAuthnCtx();
        if (authnCtxValue != null && (authnCtx = authnCtxValue.getValue()) != null) {
            return requestedContexts.contains(authnCtx);
        }
        return false;
    }

    private static String[] getExtendedSessionIds(HttpServletRequest req, HttpServletResponse resp, boolean rollExtendedSessionId) {
        String oldExtendedSessionId = sessionIdUtil.getExtendedSessionId(req, resp);
        String newExtendedSessionId = oldExtendedSessionId;
        if (newExtendedSessionId == null || rollExtendedSessionId) {
            newExtendedSessionId = sessionIdUtil.cycleExtendedSessionId(req, resp);
        }
        return new String[]{oldExtendedSessionId, newExtendedSessionId};
    }

    private static IdpSessionRegistry getRegistry() {
        return StateMgmtFactory.getIdpSessionRegistry();
    }

    public static void revokeSessionsByUserKey(String uniqueUserKey, String sriToNotRevokeStr) {
        Collection<String> srisToRevoke = IdpSessionRegistrySupport.getSrisForUniqueUserKey(uniqueUserKey);
        Collection<Object> persistentGroupIdsToRevoke = new HashSet();
        try {
            persistentGroupIdsToRevoke = IdpSessionRegistrySupport.getPersistentSessionGroupIdsForUniqueUserKey(uniqueUserKey);
        }
        catch (SessionStorageException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown while retrieving stored sessions for unique user key= '" + uniqueUserKey + "'"));
            }
            log.error((Object)"Unexpected error while retrieving stored sessions", (Throwable)e);
        }
        if (StringUtils.isNotBlank((String)sriToNotRevokeStr)) {
            try {
                String sriToNotRevoke = new ExtendedSri(sriToNotRevokeStr).getSri();
                srisToRevoke.removeIf(sri -> {
                    try {
                        ExtendedSri extendedSri = new ExtendedSri((String)sri);
                        return sriToNotRevoke.equals(extendedSri.getSri());
                    }
                    catch (InvalidParameterException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Invalid SRI found in the list of SRIs to revoke: " + sri), (Throwable)e);
                        }
                        return false;
                    }
                });
            }
            catch (InvalidParameterException sriToNotRevoke) {
                // empty catch block
            }
        }
        SessionRevocationService sessionRevocationService = StateMgmtFactory.getSessionRevocationService();
        for (String sriToRevoke : srisToRevoke) {
            ExtendedSri extendedSri = new ExtendedSri(sriToRevoke);
            sessionRevocationService.addRevokedSri(extendedSri.getSri());
            String persistentSessionGroupId = extendedSri.getPersistentSessionGroupId();
            if (persistentSessionGroupId != null && persistentGroupIdsToRevoke.contains(persistentSessionGroupId)) {
                sessionRevocationService.addRevokedSri(persistentSessionGroupId);
                try {
                    StateMgmtFactory.getStoredSessionService().deleteAuthnSessions(Collections.singleton(persistentSessionGroupId));
                }
                catch (SessionStorageException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exception thrown while deleting stored sessions for unique user key= '" + uniqueUserKey + "' with persistent group ID='" + extendedSri.getPersistentSessionGroupId() + "'"));
                    }
                    log.error((Object)"Unexpected error while deleting stored sessions", (Throwable)e);
                }
            }
            IdpAuditLogger.logSessionRevocationByUserKey(extendedSri, uniqueUserKey, "Revoked session for user key.");
        }
    }

    public static Collection<String> getSrisForUniqueUserKey(String uniqueUserKey) {
        String delimiter = ".";
        HashSet persistentGroupSessionInfoFromCache = new HashSet();
        Collection<String> sriSet = IdpSessionRegistrySupport.getSessionRegistrySrisForUniqueUserKey(uniqueUserKey);
        sriSet.forEach(sri -> {
            try {
                ExtendedSri extendedSri = new ExtendedSri((String)sri);
                if (StringUtils.isNotBlank((String)extendedSri.getPersistentSessionGroupId()) && StringUtils.isNotBlank((String)extendedSri.getEncodedSeriesId())) {
                    persistentGroupSessionInfoFromCache.add(extendedSri.getEncodedSeriesId() + "." + extendedSri.getPersistentSessionGroupId());
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                // empty catch block
            }
        });
        if (MgmtFactory.getAuthnSessionPolicyManager().isAnyStoredSessionEnabled()) {
            try {
                List<SessionGroupInfo> sessionGroupInfoList = StateMgmtFactory.getStoredSessionService().getSessionGroupsByUniqueUserId(uniqueUserKey);
                for (SessionGroupInfo sessionGroupInfo : sessionGroupInfoList) {
                    String persistentGroupId = sessionGroupInfo.getId();
                    long sessionSeriesId = sessionGroupInfo.getSessionSeriesId();
                    if (persistentGroupSessionInfoFromCache.contains(ExtendedSri.encodeSeriesId(sessionSeriesId) + "." + persistentGroupId)) continue;
                    String sri2 = sessionGroupInfo.getSri();
                    if (sri2 == null) {
                        sri2 = sessionIdUtil.getSriFromPrimaryValue(sessionIdUtil.newValue());
                    }
                    sriSet.add(new ExtendedSri(sri2, sessionIdUtil.getNodeGroupId(), sessionSeriesId, persistentGroupId).getExtendedSri());
                }
            }
            catch (SessionStorageException e) {
                log.error((Object)"Error retrieving persistent session group information by unique user key.");
            }
        }
        return sriSet;
    }

    public static Collection<String> getSessionRegistrySrisForUniqueUserKey(String uniqueUserKey) {
        return IdpSessionRegistrySupport.getRegistry().getSrisForUniqueUserKey(uniqueUserKey);
    }

    public static Collection<String> getPersistentSessionGroupIdsForUniqueUserKey(String uniqueUserKey) throws SessionStorageException {
        HashSet<String> persistentGroupIdSet = new HashSet<String>();
        if (MgmtFactory.getAuthnSessionPolicyManager().isAnyStoredSessionEnabled()) {
            List<SessionGroupInfo> sessionGroupInfoList = StateMgmtFactory.getStoredSessionService().getSessionGroupsByUniqueUserId(uniqueUserKey);
            for (SessionGroupInfo sessionGroupInfo : sessionGroupInfoList) {
                persistentGroupIdSet.add(sessionGroupInfo.getId());
            }
        }
        return persistentGroupIdSet;
    }

    public static class AuthenticationBeanRegistrationInfo
    implements Serializable {
        private boolean rollExtendedSessionId;
        private IdpHashableAuthnBean authenticationBean;
        private boolean isPersistentSession;

        AuthenticationBeanRegistrationInfo(boolean rollExtendedSessionId, IdpHashableAuthnBean authenticationBean, boolean isPersistentSession) {
            this.rollExtendedSessionId = rollExtendedSessionId;
            this.authenticationBean = authenticationBean;
            this.isPersistentSession = isPersistentSession;
        }

        public void register(HttpServletRequest request, HttpServletResponse response, Map<String, Object> params) throws SessionRegistryException, SessionQuotaException {
            SessionQuotaContext context;
            AuthnSessionInfo info = IdpSessionRegistrySupport.getAuthnSessionInfo(request, response, params);
            Set<String> userKeySet = Collections.emptySet();
            if (this.authenticationBean.isValidForSso()) {
                userKeySet = UserKeyAttributeUtil.getUniqueUserKeysFromStateParams(params);
                if (info.getSessionSeriesId() == 0L) {
                    info.setSessionSeriesId(IdpSessionRegistrySupport.getNewSessionSeriesId());
                }
            }
            AuthnSessionContextData sessionContextData = AuthnSessionContextDataUtil.createContextData(request);
            SessionQuotaService service = MgmtFactory.getSessionQuotaService();
            QuotaEnforcerResult result = service.enforceQuota(context = new SessionQuotaContext.Builder().setRequest(request).setResponse(response).setUserKeySet(userKeySet).build());
            if (QuotaEnforcerResult.ResultCode.SUCCESS.equals((Object)result.getResultCode()) && result.isDenyAccess()) {
                throw new SessionQuotaException("Session limit exceeded.");
            }
            ArrayList<CachedSessionGroupInfo> sessionGroupInfos = new ArrayList<CachedSessionGroupInfo>();
            if (this.isPersistentSession) {
                try {
                    sessionGroupInfos.add(StateMgmtFactory.getStoredSessionService().saveAuthnSession(request, response, params, this.authenticationBean, info.getSessionSeriesId(), userKeySet, sessionContextData));
                    info.setPersistentSessionGroupId(this.authenticationBean.getStoredSessionGroupId());
                    IdpSessionRegistrySupport.logSessionInfo(StateMgmtFactory.getLocalSessionId(request, response), info);
                }
                catch (SessionStorageException e) {
                    log.error((Object)"An error occurred while storing a session", (Throwable)e);
                }
            }
            String[] extendedSessionIds = IdpSessionRegistrySupport.getExtendedSessionIds(request, response, this.rollExtendedSessionId);
            IdpHashableAuthnBean copy = IdpHashableAuthnBean.copy(this.authenticationBean);
            IdpAuditLogger.setUniqueUserKeyAuditLogFields(userKeySet);
            IdpAuditLogger.logAuthnSession("Created new authentication session", IdpAuditLogger.AuthnSessionEvent.EVENT_AUTHN_SESSION_CREATED, copy);
            IdpSessionRegistrySupport.getRegistry().registerBeans(extendedSessionIds[0], extendedSessionIds[1], info.getSessionSeriesId(), 0L, Collections.singleton(copy), sessionGroupInfos, userKeySet, sessionContextData);
            String primarySessionId = StateMgmtFactory.getLocalSessionId(request, response);
            String extendedSri = sessionIdUtil.makeExtendedSriV2(primarySessionId, info.getSessionSeriesId(), copy.getStoredSessionGroupId());
            IdpSessionRegistrySupport.registerSriToUniqueUserKeys(userKeySet, extendedSri);
            IdpSessionRegistrySupport.checkUpdateOidcLogoutIndexes(IdpSessionRegistrySupport.getIndexKeysForBean(copy), extendedSri);
            UserKeyAttributeUtil.logSriToUserKeysAssociation(userKeySet, extendedSri);
        }
    }
}

