/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.state;

import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.state.SessionSettings;
import org.sourceid.saml20.state.SizeLimitProps;

public class SessionSettingsManager {
    public static final int DEFAULT_SESSION_REVOCATION_LIFETIME = 1450;
    private static final String FILENAME = "session-mgmt-settings";
    private static final String SESSION_REVOCATION_LIFTEIME = "session-revocation-lifetime";
    private static final String REVOKE_USER_SESSION_ON_LOGOUT = "revoke-user-session-on-logout";
    private static final String TRACK_ADAPTER_SESSIONS_FOR_LOGOUT = "track-adapter-sessions-for-logout";
    private static final String SESSION_REVOCATION_LIFETIME_OFFSET = "session-revocation-lifetime-offset";
    private ConfigStore configStore;
    private SizeLimitProps sizeLimitProps = new SizeLimitProps();

    public SessionSettingsManager() {
        this.configStore = ConfigStoreFarm.getConfig(FILENAME);
    }

    public SessionSettings getSessionSettings() {
        SessionSettings sessionSettings = new SessionSettings(this.getMinSessionRevocationLifetimeMins());
        int lifetime = this.configStore.getIntValue(SESSION_REVOCATION_LIFTEIME, 1450);
        sessionSettings.setSessionRevocationLifetime(lifetime);
        boolean revokeUserSession = this.configStore.getBooleanValue(REVOKE_USER_SESSION_ON_LOGOUT, true);
        sessionSettings.setRevokeUserSessionOnLogout(revokeUserSession);
        boolean trackAdapterSessions = this.configStore.getBooleanValue(TRACK_ADAPTER_SESSIONS_FOR_LOGOUT, false);
        sessionSettings.setTrackAdapterSessionsForLogout(trackAdapterSessions);
        return sessionSettings;
    }

    public void saveSessionSettings(SessionSettings settings) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.configStore.startBatchUpdate();
            this.configStore.setIntValue(SESSION_REVOCATION_LIFTEIME, settings.getSessionRevocationLifetime());
            this.configStore.setBooleanValue(REVOKE_USER_SESSION_ON_LOGOUT, settings.isRevokeUserSessionOnLogout());
            this.configStore.setBooleanValue(TRACK_ADAPTER_SESSIONS_FOR_LOGOUT, settings.isTrackAdapterSessionsForLogout());
            this.configStore.commitBatchUpdate();
            auditLoggerScope.log(AdminAuditLogger.Component.SESSION_POLICIES, AdminAuditLogger.Event.MODIFY, "General session settings");
        }
        MetaDataFactory.getLocalMetaData().reload();
    }

    private int getMinSessionRevocationLifetimeMins() {
        return Math.max(this.sizeLimitProps.getIdpExpiryMins(), this.sizeLimitProps.getIrsmExpiryMinsAttrMap()) + this.configStore.getIntValue(SESSION_REVOCATION_LIFETIME_OFFSET, 10);
    }
}

