/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.util.BaseUrlUtil;

public class AudienceEvaluator {
    private final Log log = LogFactory.getLog(this.getClass());
    private final MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();

    public boolean evalAudience(String myAudienceId, String audience) {
        return this.eval(audience, myAudienceId, this.metadataLocal.getBaseURL());
    }

    boolean eval(String audience, String myAudienceId, URL baseUrl) {
        if (StringUtils.isBlank((String)audience) || StringUtils.isBlank((String)myAudienceId)) {
            return false;
        }
        boolean ok = myAudienceId.equals(audience);
        if (!ok) {
            try {
                URL audienceUrl = new URL(audience);
                String audienceHost = audienceUrl.getHost();
                String currentBaseHost = this.getCurrentBaseUrl(baseUrl);
                ok = currentBaseHost.equals(audienceHost) && audienceUrl.getPath().endsWith(this.metadataLocal.getSaml1xAcsEndpoint());
            }
            catch (MalformedURLException e) {
                this.log.warn((Object)(e.getMessage() + " when checking audience " + audience + " against " + baseUrl));
                ok = false;
            }
        }
        return ok;
    }

    public String getRemark(String[] myAudienceIds) {
        StringBuilder remarks = new StringBuilder();
        if (myAudienceIds != null && myAudienceIds.length != 0) {
            for (String myAudienceId : myAudienceIds) {
                remarks.append(this.getRemark(myAudienceId));
            }
        } else {
            remarks.append("No audience data for evaluation.");
        }
        return remarks.toString();
    }

    public String getRemark(String myAudienceId) {
        StringBuilder remark = new StringBuilder();
        remark.append("Assertion audience condition validation failed, expecting ");
        remark.append(myAudienceId);
        remark.append(" or a SAML v1.x Assertion Consumer Service URL with the same hostname as the base URL (");
        remark.append(BaseUrlUtil.getCurrentBaseUrl(this.metadataLocal.getBaseUrl()));
        remark.append(") in all audience restriction conditions.");
        return remark.toString();
    }

    protected String getCurrentBaseUrl(URL baseUrl) throws MalformedURLException {
        return new URL(BaseUrlUtil.getCurrentBaseUrl(baseUrl.toString())).getHost();
    }
}

