/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class SSOApplicationUrlUtil {
    public static String getSSOUrl(boolean isIdpConnection, boolean isSpConnection, String entityId, String nonCBPOSpAdapterId) {
        StringBuffer url = new StringBuffer();
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        String baseUrl = localSettings.getBaseUrl();
        if (baseUrl.endsWith("/")) {
            baseUrl = StringUtils.substringBeforeLast((String)baseUrl, (String)"/");
        }
        url.append(baseUrl);
        try {
            if (isIdpConnection) {
                boolean isSpAuthnSelectionEnabled = MgmtFactory.getAuthnSelectionConfigManager().isEnableSpAuthnSelection();
                url.append(localSettings.getSpInitiateSsoPath());
                url.append("?");
                if (isSpAuthnSelectionEnabled) {
                    url.append("SpSessionAuthnAdapterId=");
                    if (StringUtils.isNotBlank((String)nonCBPOSpAdapterId)) {
                        url.append(nonCBPOSpAdapterId);
                    } else {
                        url.append("<InsertSpAdapterId>");
                    }
                } else {
                    url.append("PartnerIdpId=");
                    url.append(URLEncoder.encode(entityId, "UTF-8"));
                }
            } else if (isSpConnection) {
                url.append(localSettings.getIdpInitiateSsoPath());
                url.append("?");
                url.append("PartnerSpId=");
                url.append(URLEncoder.encode(entityId, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ProcessRuntimeException("Unable to generate Application SSO URL.", e);
        }
        return url.toString();
    }

    public static boolean displaySpConnectionSsoURL(Protocol protocol, boolean isIdpSSOEnabled) {
        return protocol != Protocol.WSFED && isIdpSSOEnabled;
    }

    public static boolean displayIdpConnectionSsoURL(boolean isSpSSOEnabled, boolean isOidcConnection, int adapterMappingCount, int policyContractMappingCount) {
        boolean spInitEnabled = isSpSSOEnabled || isOidcConnection;
        boolean isSpAuthnSelectionEnabled = MgmtFactory.getAuthnSelectionConfigManager().isEnableSpAuthnSelection();
        if (isSpAuthnSelectionEnabled) {
            return spInitEnabled && adapterMappingCount > 0;
        }
        return spInitEnabled && (adapterMappingCount > 0 || policyContractMappingCount > 0);
    }
}

