/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.services.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.jwk.IssuerSigningKeys;
import com.pingidentity.crypto.jwk.JwkFacilitator;
import com.pingidentity.crypto.jwk.JwkKeyPair;
import com.pingidentity.crypto.jwk.JwkKeyPairBuilder;
import com.pingidentity.crypto.jwk.JwkLifecycleState;
import com.pingidentity.crypto.jwk.JwksAdditionalKeysContent;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sourceid.oauth20.domain.JWKSEndpointManager;
import org.sourceid.oauth20.domain.JWKSEndpointSetting;
import org.sourceid.oauth20.domain.JwksSigningInstanceSettings;
import org.sourceid.oauth20.domain.JwksSigningKeySetsManager;
import org.sourceid.oauth20.domain.OidcJwksSet;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.services.JWKSService;

public class JWKSServiceImpl
implements JWKSService,
AutoReloadable {
    private final JWKSEndpointManager jwksEndpointManager;
    private final JwksSigningKeySetsManager jwksSigningKeySetsManager;
    private final PkCertManager pkCertManager;

    public JWKSServiceImpl(JWKSEndpointManager jwksEndpointManager, JwksSigningKeySetsManager jwksSigningKeySetsManager) {
        this(jwksEndpointManager, jwksSigningKeySetsManager, MgmtFactory.getDsigPkCertManager());
    }

    JWKSServiceImpl(JWKSEndpointManager jwksEndpointManager, JwksSigningKeySetsManager jwksSigningKeySetsManager, PkCertManager pkCertManager) {
        this.jwksEndpointManager = jwksEndpointManager;
        this.jwksSigningKeySetsManager = jwksSigningKeySetsManager;
        this.pkCertManager = pkCertManager;
    }

    @Override
    public List<JwkKeyPair> getStaticSigningKeys() {
        JWKSEndpointSetting setting = this.jwksEndpointManager.getSetting();
        return this.getStaticSigningKeys(setting);
    }

    @Override
    public List<JwkKeyPair> getStaticDecryptionKeys() {
        JwkKeyPair keyPair;
        JWKSEndpointSetting setting = this.jwksEndpointManager.getSetting();
        LinkedList<JwkKeyPair> encryptionKeys = new LinkedList<JwkKeyPair>();
        if (setting.getP256DecryptionActiveId() != null) {
            keyPair = this.getKeyPair(setting.getP256DecryptionActiveId(), setting.isP256DecryptionPublishX5cParameter(), JwkLifecycleState.ACTIVE, setting.getP256DecryptionActiveKeyId());
            encryptionKeys.add(keyPair);
        }
        if (setting.getP384DecryptionActiveId() != null) {
            keyPair = this.getKeyPair(setting.getP384DecryptionActiveId(), setting.isP384DecryptionPublishX5cParameter(), JwkLifecycleState.ACTIVE, setting.getP384DecryptionActiveKeyId());
            encryptionKeys.add(keyPair);
        }
        if (setting.getP521DecryptionActiveId() != null) {
            keyPair = this.getKeyPair(setting.getP521DecryptionActiveId(), setting.isP521DecryptionPublishX5cParameter(), JwkLifecycleState.ACTIVE, setting.getP521DecryptionActiveKeyId());
            encryptionKeys.add(keyPair);
        }
        if (setting.getRsaDecryptionActiveId() != null) {
            keyPair = this.getKeyPair(setting.getRsaDecryptionActiveId(), setting.isRsaDecryptionPublishX5cParameter(), JwkLifecycleState.ACTIVE, setting.getRsaDecryptionActiveKeyId());
            encryptionKeys.add(keyPair);
        }
        if (setting.getP256DecryptionPreviousId() != null) {
            keyPair = this.getKeyPair(setting.getP256DecryptionPreviousId(), setting.isP256DecryptionPublishX5cParameter(), JwkLifecycleState.RETIRED, setting.getP256DecryptionPreviousKeyId());
            encryptionKeys.add(keyPair);
        }
        if (setting.getP384DecryptionPreviousId() != null) {
            keyPair = this.getKeyPair(setting.getP384DecryptionPreviousId(), setting.isP384DecryptionPublishX5cParameter(), JwkLifecycleState.RETIRED, setting.getP384DecryptionPreviousKeyId());
            encryptionKeys.add(keyPair);
        }
        if (setting.getP521DecryptionPreviousId() != null) {
            keyPair = this.getKeyPair(setting.getP521DecryptionPreviousId(), setting.isP521DecryptionPublishX5cParameter(), JwkLifecycleState.RETIRED, setting.getP521DecryptionPreviousKeyId());
            encryptionKeys.add(keyPair);
        }
        if (setting.getRsaDecryptionPreviousId() != null) {
            keyPair = this.getKeyPair(setting.getRsaDecryptionPreviousId(), setting.isRsaDecryptionPublishX5cParameter(), JwkLifecycleState.RETIRED, setting.getRsaDecryptionPreviousKeyId());
            encryptionKeys.add(keyPair);
        }
        return encryptionKeys;
    }

    @Override
    public Optional<JwksAdditionalKeysContent> getStaticAdditionalKeysContent() {
        List<JwksSigningInstanceSettings> allKeySets = this.jwksSigningKeySetsManager.getAllKeySets();
        if (allKeySets == null || allKeySets.isEmpty()) {
            return Optional.empty();
        }
        HashMap<String, String> issuerToKeySetIds = new HashMap<String, String>();
        HashMap<String, IssuerSigningKeys> keySetIdsToSigningKeys = new HashMap<String, IssuerSigningKeys>();
        for (JwksSigningInstanceSettings jwkSetInstance : allKeySets) {
            OidcJwksSet keyset = jwkSetInstance.getOidcJWKSSigningKeySet();
            List<JwkKeyPair> jwkKeyPairs = this.getStaticSigningKeys(keyset);
            boolean requireDuplicateActiveRsa256Jwk = this.requireDuplicateRsa256Jwk(keyset.getRsaAlgTypesActiveCustomKeyIds());
            boolean requireDuplicatePreviousRsa256Jwk = this.requireDuplicateRsa256Jwk(keyset.getRsaAlgTypesPreviousCustomKeyIds());
            IssuerSigningKeys issuerSigningKeys = new IssuerSigningKeys(jwkKeyPairs, requireDuplicateActiveRsa256Jwk, requireDuplicatePreviousRsa256Jwk);
            keySetIdsToSigningKeys.put(jwkSetInstance.getId(), issuerSigningKeys);
            if (jwkSetInstance.getIssuerIds() == null || jwkSetInstance.getIssuerIds().isEmpty()) continue;
            for (String issuer : jwkSetInstance.getIssuerIds()) {
                issuerToKeySetIds.put(issuer, jwkSetInstance.getId());
            }
        }
        return Optional.of(new JwksAdditionalKeysContent(issuerToKeySetIds, keySetIdsToSigningKeys));
    }

    private List<JwkKeyPair> getStaticSigningKeys(OidcJwksSet setting) {
        JwkKeyPair keyPair;
        LinkedList<JwkKeyPair> keys = new LinkedList<JwkKeyPair>();
        if (setting.getP256ActiveId() != null) {
            keyPair = this.getKeyPair(setting.getP256ActiveId(), setting.isP256PublishX5cParameter(), JwkLifecycleState.ACTIVE, setting.getP256ActiveKeyId());
            keys.add(keyPair);
        }
        if (setting.getP384ActiveId() != null) {
            keyPair = this.getKeyPair(setting.getP384ActiveId(), setting.isP384PublishX5cParameter(), JwkLifecycleState.ACTIVE, setting.getP384ActiveKeyId());
            keys.add(keyPair);
        }
        if (setting.getP521ActiveId() != null) {
            keyPair = this.getKeyPair(setting.getP521ActiveId(), setting.isP521PublishX5cParameter(), JwkLifecycleState.ACTIVE, setting.getP521ActiveKeyId());
            keys.add(keyPair);
        }
        if (setting.getRsaActiveId() != null) {
            this.populateRsaKeyPairs(keys, JwkLifecycleState.ACTIVE, setting.getRsaAlgTypesActiveCustomKeyIds(), setting.getRsaActiveId(), setting.getRsaActiveKeyId(), setting.isRsaPublishX5cParameter());
        }
        if (setting.getP256PreviousId() != null) {
            keyPair = this.getKeyPair(setting.getP256PreviousId(), setting.isP256PublishX5cParameter(), JwkLifecycleState.RETIRED, setting.getP256PreviousKeyId());
            keys.add(keyPair);
        }
        if (setting.getP384PreviousId() != null) {
            keyPair = this.getKeyPair(setting.getP384PreviousId(), setting.isP384PublishX5cParameter(), JwkLifecycleState.RETIRED, setting.getP384PreviousKeyId());
            keys.add(keyPair);
        }
        if (setting.getP521PreviousId() != null) {
            keyPair = this.getKeyPair(setting.getP521PreviousId(), setting.isP521PublishX5cParameter(), JwkLifecycleState.RETIRED, setting.getP521PreviousKeyId());
            keys.add(keyPair);
        }
        if (setting.getRsaPreviousId() != null) {
            this.populateRsaKeyPairs(keys, JwkLifecycleState.RETIRED, setting.getRsaAlgTypesPreviousCustomKeyIds(), setting.getRsaPreviousId(), setting.getRsaPreviousKeyId(), setting.isRsaPublishX5cParameter());
        }
        return keys;
    }

    private void populateRsaKeyPairs(List<JwkKeyPair> populatedKeys, JwkLifecycleState jwkLifecycleState, Map<String, String> rsaAlgTypCustomKeyIdMap, String rsaCertId, String defaultRsaKeyId, boolean rsaPublishX5cParameter) {
        if (rsaAlgTypCustomKeyIdMap != null && !rsaAlgTypCustomKeyIdMap.isEmpty()) {
            if (!rsaAlgTypCustomKeyIdMap.keySet().equals(JwkFacilitator.SUPPORTED_RSA_ALG)) {
                JwkKeyPair keyPair = this.getKeyPair(rsaCertId, rsaPublishX5cParameter, jwkLifecycleState, defaultRsaKeyId);
                populatedKeys.add(keyPair);
            }
            for (Map.Entry entry : rsaAlgTypCustomKeyIdMap.entrySet()) {
                JwkKeyPair keyPair = this.getKeyPair(rsaCertId, rsaPublishX5cParameter, jwkLifecycleState, (String)entry.getValue(), (String)entry.getKey());
                populatedKeys.add(keyPair);
            }
        } else {
            JwkKeyPair keyPair = this.getKeyPair(rsaCertId, rsaPublishX5cParameter, jwkLifecycleState, defaultRsaKeyId);
            populatedKeys.add(keyPair);
        }
    }

    private JwkKeyPair getKeyPair(String id, boolean publishX5cParameter, JwkLifecycleState state, String keyId) {
        return this.getKeyPair(id, publishX5cParameter, state, keyId, null);
    }

    private JwkKeyPair getKeyPair(String id, boolean publishX5cParameter, JwkLifecycleState state, String keyId, String alg) {
        PkCert pkCert = this.pkCertManager.getPkCert(id);
        PrivateKey privateKey = pkCert.getPrivateKey();
        PublicKey publicKey = pkCert.getX509Certificate().getPublicKey();
        JwkKeyPairBuilder jwkKeyPairBuilder = new JwkKeyPairBuilder(publicKey, privateKey).setState(state).setKeyId(keyId).setPkCertID(id).setAlg(alg);
        if (publishX5cParameter) {
            jwkKeyPairBuilder.setX509Certificates(pkCert.getChain());
        }
        return jwkKeyPairBuilder.build();
    }

    private boolean requireDuplicateRsa256Jwk(Map<String, String> rsaAlgTypActiveCustomKeyId) {
        boolean requiresDuplicateRsa256Jwk = true;
        if (rsaAlgTypActiveCustomKeyId != null) {
            requiresDuplicateRsa256Jwk = !rsaAlgTypActiveCustomKeyId.containsKey("RS256");
        }
        return requiresDuplicateRsa256Jwk;
    }
}

