/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.servlet;

import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.QuietServletException;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.ResponseTemplateRendererException;
import org.sourceid.servlet.QuietException;

public class ErrorServlet
extends HttpServlet {
    private Log log;
    private ResponseTemplateRenderer renderer;
    private String templateFile;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.templateFile = config.getInitParameter("template");
        this.renderer = ResponseTemplateRenderer.getInstance();
        this.log = LogFactory.getLog(((Object)((Object)this)).getClass());
    }

    protected void doit(HttpServletRequest req, HttpServletResponse resp) {
        String reference = IDGenerator.rndGroupedNumeric(4, 2);
        Object exAttr = req.getAttribute("javax.servlet.error.exception");
        Object msg = req.getAttribute("javax.servlet.error.message");
        if (exAttr instanceof Throwable) {
            Throwable t = (Throwable)exAttr;
            String logMsg = "Top level error (ref#" + reference + "): ";
            StringBuilder sb = new StringBuilder().append(logMsg);
            if (t instanceof QuietException || t instanceof QuietServletException) {
                sb.append(t.getClass().getSimpleName()).append(": ").append(t.getMessage());
                this.log.warn((Object)sb);
            } else {
                sb.append(msg);
                this.log.error((Object)sb, t);
            }
        } else {
            this.log.warn((Object)(msg + "  " + exAttr));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration attributeNames = req.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            Object attribute = req.getAttribute(name);
            String[] ss = name.split("\\.");
            params.put(ss[ss.length - 1], attribute);
        }
        params.put("referenceNumber", reference);
        try {
            resp.setStatus(500);
            this.renderer.render(req, resp, this.templateFile, params);
        }
        catch (ResponseTemplateRendererException e) {
            this.log.error((Object)("Problem rendering error page template " + this.templateFile + " with parms: " + params), (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.doit(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        this.doit(req, resp);
    }
}

