/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.servlet;

import com.pingidentity.common.mgr.HttpUtilities;
import com.pingidentity.common.util.EOLUtil;
import com.pingidentity.common.util.LogGuard;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.servlet.BaseSessionIdUtil;
import org.sourceid.websso.servlet.PersistentSessionIdUtil;
import org.sourceid.websso.servlet.SessionIdUtil;

public class HttpServletRespProxy
extends HttpServletResponseWrapper
implements HttpServletResponse {
    private static Log log = LogFactory.getLog(HttpServletRespProxy.class);
    private static final String KEY_SSO_TRANSACTION_STATE = "SsoTransactionState";
    private Map<String, Runnable> preCommitRunnables = new HashMap<String, Runnable>();
    private Map<String, Cookie> lazyCookies;
    private final HttpUtilities httpUtilities;

    public HttpServletRespProxy(HttpServletResponse resp) {
        this(resp, MgmtFactory.getHttpUtilities());
    }

    public HttpServletRespProxy(HttpServletResponse resp, HttpUtilities httpUtilities) {
        super(resp);
        this.httpUtilities = httpUtilities;
    }

    public void setPreCommitRunnable(Runnable r) {
        this.preCommitRunnables.put(KEY_SSO_TRANSACTION_STATE, r);
    }

    public void setPreCommitRunnable(String key, Runnable r) {
        this.preCommitRunnables.put(key, r);
    }

    public void removePreCommitRunnable(String key) {
        this.preCommitRunnables.remove(key);
    }

    public void addCookie(Cookie cookie) {
        String value = cookie.getValue();
        String name = cookie.getName();
        this.httpUtilities.addPartitionedAttributeToCookie(cookie);
        if (EOLUtil.hasEOLs(value) || EOLUtil.hasEOLs(name)) {
            log.warn((Object)("not adding cookie due to invalid name/value. " + LogGuard.b64Encode(name + " : " + value)));
        } else {
            if (this.lazyCookies == null) {
                this.lazyCookies = new HashMap<String, Cookie>();
            }
            Cookie prevCookie = this.lazyCookies.put(name, cookie);
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding lazy cookie " + this.toStringCookie(cookie) + " replacing " + this.toStringCookie(prevCookie)));
            }
        }
    }

    private void flushCookies() {
        if (this.lazyCookies != null) {
            for (Cookie c : this.lazyCookies.values()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("flush cookies: adding " + this.toStringCookie(c)));
                }
                super.addCookie(c);
            }
            this.lazyCookies.clear();
        }
    }

    public void sendRedirect(String location) throws IOException {
        if (EOLUtil.hasEOLs((String)location)) {
            String msg = "Invalid location for HTTP 302 redirect. ";
            log.warn((Object)(msg + LogGuard.b64Encode((String)location)));
            throw new IOException(msg);
        }
        this.checkPreCommitExe();
        ConfigStore sanitizeFragStore = ConfigStoreFarm.getConfig("sanitize-fragments");
        boolean sanitizeAllRedirects = sanitizeFragStore.getBooleanValue("SanitizeAllRedirects", false);
        if (sanitizeAllRedirects && ((String)location).indexOf(35) == -1) {
            String placeholder = sanitizeFragStore.getStringValue("FragmentPlaceholder", ".");
            location = (String)location + "#" + placeholder;
        }
        try {
            location = new URI((String)location).toASCIIString();
        }
        catch (URISyntaxException e) {
            log.debug((Object)("The redirect location is not a valid URI: " + LogGuard.encode((String)location)), (Throwable)e);
        }
        super.sendRedirect((String)location);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.checkPreCommitExe();
        super.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.checkPreCommitExe();
        super.sendError(sc);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.checkPreCommitExe();
        return super.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        this.checkPreCommitExe();
        return super.getWriter();
    }

    public void flushBuffer() throws IOException {
        this.checkPreCommitExe();
        super.flushBuffer();
    }

    private void checkPreCommitExe() {
        this.executePreCommitExe();
        this.flushCookies();
    }

    private void executePreCommitExe() {
        for (Runnable preCommitRunnable : this.preCommitRunnables.values()) {
            if (preCommitRunnable == null) continue;
            try {
                preCommitRunnable.run();
            }
            catch (Exception e) {
                log.error((Object)"Unexpected error executing pre-commit runnable", (Throwable)e);
            }
        }
        this.preCommitRunnables.clear();
    }

    public static void flushCookies(HttpServletResponse resp) {
        if (resp instanceof HttpServletRespProxy) {
            ((HttpServletRespProxy)resp).flushCookies();
        }
    }

    public static void clearRunnable(HttpServletResponse resp) {
        HttpServletRespProxy.clearRunnable(resp, KEY_SSO_TRANSACTION_STATE);
    }

    public static void clearRunnable(HttpServletResponse resp, String key) {
        if (resp instanceof HttpServletRespProxy) {
            ((HttpServletRespProxy)resp).removePreCommitRunnable(key);
        }
    }

    public static void setRunnable(HttpServletResponse resp, String key, Runnable preCommitRunnable) {
        if (resp instanceof HttpServletRespProxy) {
            ((HttpServletRespProxy)resp).setPreCommitRunnable(key, preCommitRunnable);
        }
    }

    String toStringCookie(Cookie c) {
        if (c == null) {
            return null;
        }
        String cookieName = c.getName();
        Object cookieValue = c.getValue();
        for (BaseSessionIdUtil sessionIdUtil : Arrays.asList(SessionIdUtil.getInstance(), PersistentSessionIdUtil.getInstance())) {
            if (!sessionIdUtil.isSessionCookie(cookieName)) continue;
            cookieValue = "hashedValue:" + sessionIdUtil.hashIdForLog((String)cookieValue);
            break;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Cookie{").append(cookieName).append("=").append((String)cookieValue);
        sb.append("; path=").append(c.getPath()).append("; maxAge=").append(c.getMaxAge());
        sb.append("; domain=").append(c.getDomain()).append("}");
        return sb.toString();
    }

    public static Map<String, Cookie> getLazyCookies(HttpServletResponse response) {
        if (response instanceof HttpServletRespProxy) {
            return Collections.unmodifiableMap(((HttpServletRespProxy)response).lazyCookies);
        }
        return Collections.emptyMap();
    }

    public static void clearLazyCookies(HttpServletResponse response) {
        if (response instanceof HttpServletRespProxy) {
            ((HttpServletRespProxy)response).lazyCookies.clear();
        }
    }

    public static void executePreCommitRunnable(HttpServletResponse response) {
        if (response instanceof HttpServletRespProxy) {
            ((HttpServletRespProxy)response).executePreCommitExe();
        }
    }
}

