/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.servlet.filter;

import com.pingidentity.common.util.EOLUtil;
import com.pingidentity.common.util.PropertyInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.CorsSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class CrossOriginFilter
implements Filter {
    private static final Logger LOG = Log.getLogger(CrossOriginFilter.class);
    private static final String ORIGIN_HEADER = "Origin";
    public static final String ACCESS_CONTROL_REQUEST_METHOD_HEADER = "Access-Control-Request-Method";
    public static final String ACCESS_CONTROL_REQUEST_HEADERS_HEADER = "Access-Control-Request-Headers";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_METHODS_HEADER = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS_HEADER = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_MAX_AGE_HEADER = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS_HEADER = "Access-Control-Expose-Headers";
    private static final List<String> SIMPLE_HTTP_METHODS = Arrays.asList("GET", "POST", "HEAD");
    private List<String> exposedHeaders = new ArrayList<String>();
    private boolean allowCredentials;
    private boolean chainPreflight;
    private static final String ATTR_USING_AUTHZ_ENDPOINT_CORS_SETTINGS = "COF.UsingAuthzEndpointCorsSettings";
    private static final String ATTR_SIMPLE_RESPONSE_HEADERS_APPLIED = "COF.SimpleResponseHeadersApplied";
    private AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();

    public void init(FilterConfig config) throws ServletException {
        this.fetchConfiguration();
    }

    private void fetchConfiguration() {
        this.allowCredentials = true;
        this.chainPreflight = true;
    }

    protected CorsSettings getCorsSettings(ServletRequest request) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        CorsSettings authzServerSettings = this.authzServerManager.getCorsSettings();
        if (!authzServerSettings.getAllowedOriginsList().isEmpty() && this.isCorsEnabledRequest(authzServerSettings.getUrlPatterns(), httpServletRequest)) {
            return authzServerSettings;
        }
        CorsSettings authzEndpointSettings = MgmtFactory.getAuthnApiManager().getCorsSettingsForAuthzEndpoint();
        if (!authzEndpointSettings.getAllowedOriginsList().isEmpty() && this.isCorsEnabledRequest(authzEndpointSettings.getUrlPatterns(), httpServletRequest)) {
            request.setAttribute(ATTR_USING_AUTHZ_ENDPOINT_CORS_SETTINGS, (Object)true);
            return authzEndpointSettings;
        }
        CorsSettings userAuthzEndpointSettings = MgmtFactory.getAuthnApiManager().getCorsSettingsForUserAuthzEndpoint();
        if (!userAuthzEndpointSettings.getAllowedOriginsList().isEmpty() && this.isCorsEnabledRequest(userAuthzEndpointSettings.getUrlPatterns(), httpServletRequest)) {
            return userAuthzEndpointSettings;
        }
        return authzServerSettings;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        CorsSettings corsSettings = this.getCorsSettings(request);
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (corsSettings.getAllowedOriginsList().size() > 0) {
            if (this.isCorsEnabledRequest(corsSettings.getUrlPatterns(), httpServletRequest)) {
                this.handle((HttpServletRequest)request, (HttpServletResponse)response, chain, corsSettings);
            } else if (this.isOptionsRequest(httpServletRequest)) {
                this.sendForbiddenResponse(httpServletResponse);
            } else {
                chain.doFilter(request, response);
            }
        } else {
            this.handleCorsDisabledRequest(request, response, chain);
        }
    }

    public static void clearSimpleResponseHeaders(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, null);
        response.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER, null);
        response.setHeader(ACCESS_CONTROL_EXPOSE_HEADERS_HEADER, null);
        request.removeAttribute(ATTR_SIMPLE_RESPONSE_HEADERS_APPLIED);
    }

    public static boolean isUsingAuthzEndpointCorsSettings(HttpServletRequest request) {
        return request.getAttribute(ATTR_USING_AUTHZ_ENDPOINT_CORS_SETTINGS) != null;
    }

    public static boolean isSimpleResponseHeadersApplied(HttpServletRequest request) {
        return request.getAttribute(ATTR_SIMPLE_RESPONSE_HEADERS_APPLIED) != null;
    }

    protected boolean isCorsEnabledRequest(List<String> urlPatterns, HttpServletRequest httpServletRequest) {
        String requestUri = httpServletRequest.getRequestURI();
        return this.urlPatternMatches(urlPatterns, requestUri);
    }

    protected boolean isOptionsRequest(HttpServletRequest request) {
        return request.getMethod().equals("OPTIONS");
    }

    protected void sendForbiddenResponse(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.reset();
        httpServletResponse.sendError(403);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain, CorsSettings corsSettings) throws IOException, ServletException {
        String origin = request.getHeader(ORIGIN_HEADER);
        if (origin != null && this.isEnabled(request)) {
            if (corsSettings.isAnyOriginAllowed() || this.originMatches(corsSettings.getAllowedOriginsList(), origin)) {
                if (this.shouldLogDebug(origin)) {
                    LOG.debug("Cross-origin request to {} from origin {}", new Object[]{request.getRequestURI(), origin});
                }
                if (this.isSimpleRequest(request)) {
                    if (this.shouldLogDebug(origin)) {
                        LOG.debug("Cross-origin request to {} is a simple cross-origin request", new Object[]{request.getRequestURI()});
                    }
                    this.handleSimpleResponse(request, response, origin, corsSettings);
                } else if (this.isPreflightRequest(request)) {
                    LOG.debug("Cross-origin request to {} is a preflight cross-origin request", new Object[]{request.getRequestURI()});
                    this.handlePreflightResponse(request, response, origin, corsSettings);
                    this.preSuccessHandler(request);
                    if (!this.chainPreflight) return;
                    LOG.debug("Preflight cross-origin request to {} forwarded to application", new Object[]{request.getRequestURI()});
                } else {
                    if (this.shouldLogDebug(origin)) {
                        LOG.debug("Cross-origin request to {} is a non-simple cross-origin request", new Object[]{request.getRequestURI()});
                    }
                    this.handleSimpleResponse(request, response, origin, corsSettings);
                }
            } else if (this.shouldLogDebug(origin)) {
                LOG.debug("Cross-origin request to " + request.getRequestURI() + " with origin " + origin + " does not match allowed origins " + corsSettings.getAllowedOriginsList(), new Object[0]);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean shouldLogDebug(String origin) {
        if (StringUtils.isBlank((CharSequence)PropertyInfo.getAdminBaseUrl())) {
            return true;
        }
        return !origin.contains(PropertyInfo.getAdminBaseUrl());
    }

    protected void preSuccessHandler(HttpServletRequest request) {
    }

    protected boolean isEnabled(HttpServletRequest request) {
        Enumeration connections = request.getHeaders("Connection");
        while (connections.hasMoreElements()) {
            String connection = (String)connections.nextElement();
            if (!"Upgrade".equalsIgnoreCase(connection)) continue;
            Enumeration upgrades = request.getHeaders("Upgrade");
            while (upgrades.hasMoreElements()) {
                String upgrade = (String)upgrades.nextElement();
                if (!"WebSocket".equalsIgnoreCase(upgrade)) continue;
                return false;
            }
        }
        return true;
    }

    protected void handleCorsDisabledRequest(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (this.isOptionsRequest(httpServletRequest)) {
            this.sendForbiddenResponse(httpServletResponse);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean urlPatternMatches(List<String> defaultUrlPatterns, String urlPatternList) {
        String contextPath = PropertyInfo.getContextPath();
        if (StringUtils.isBlank((CharSequence)contextPath) || "/".equals(contextPath.trim())) {
            return this.originMatches(defaultUrlPatterns, urlPatternList);
        }
        ArrayList<String> urlPatterns = new ArrayList<String>();
        for (String url : defaultUrlPatterns) {
            urlPatterns.add(contextPath + url);
        }
        return this.originMatches(urlPatterns, urlPatternList);
    }

    private boolean originMatches(List<String> allowedOrigins, String originList) {
        String[] origins;
        if (originList.trim().length() == 0) {
            return false;
        }
        for (String origin : origins = originList.split(" ")) {
            if (origin.trim().length() == 0) continue;
            for (String allowedOrigin : allowedOrigins) {
                Matcher matcher;
                if (!(allowedOrigin.contains("*") ? (matcher = this.createMatcher(origin, allowedOrigin)).matches() : allowedOrigin.equals(origin))) continue;
                return true;
            }
        }
        return false;
    }

    private Matcher createMatcher(String origin, String allowedOrigin) {
        String regex = this.parseAllowedWildcardOriginToRegex(allowedOrigin);
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(origin);
    }

    private String parseAllowedWildcardOriginToRegex(String allowedOrigin) {
        String regex = allowedOrigin.replace(".", "\\.");
        return regex.replace("*", ".*");
    }

    private boolean isSimpleRequest(HttpServletRequest request) {
        String method = request.getMethod();
        if (SIMPLE_HTTP_METHODS.contains(method)) {
            return request.getHeader(ACCESS_CONTROL_REQUEST_METHOD_HEADER) == null;
        }
        return false;
    }

    private boolean isPreflightRequest(HttpServletRequest request) {
        String method = request.getMethod();
        return "OPTIONS".equalsIgnoreCase(method) && request.getHeader(ACCESS_CONTROL_REQUEST_METHOD_HEADER) != null;
    }

    private void handleSimpleResponse(HttpServletRequest request, HttpServletResponse response, String origin, CorsSettings corsSettings) {
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, EOLUtil.stripEOLs(origin));
        if (!corsSettings.isAnyOriginAllowed()) {
            response.addHeader("Vary", ORIGIN_HEADER);
        }
        if (this.allowCredentials) {
            response.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER, "true");
        }
        if (!this.exposedHeaders.isEmpty()) {
            response.setHeader(ACCESS_CONTROL_EXPOSE_HEADERS_HEADER, this.commify(this.exposedHeaders));
        }
        request.setAttribute(ATTR_SIMPLE_RESPONSE_HEADERS_APPLIED, (Object)true);
    }

    private void handlePreflightResponse(HttpServletRequest request, HttpServletResponse response, String origin, CorsSettings corsSettings) {
        boolean methodAllowed = this.isMethodAllowed(request, corsSettings);
        if (!methodAllowed) {
            return;
        }
        List<String> headersRequested = this.getAccessControlRequestHeaders(request);
        boolean headersAllowed = this.areHeadersAllowed(headersRequested, corsSettings);
        if (!headersAllowed) {
            return;
        }
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, EOLUtil.stripEOLs(origin));
        if (!corsSettings.isAnyOriginAllowed()) {
            response.addHeader("Vary", ORIGIN_HEADER);
        }
        if (this.allowCredentials) {
            response.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER, "true");
        }
        if (corsSettings.getPreflightMaxAge() > 0) {
            response.setHeader(ACCESS_CONTROL_MAX_AGE_HEADER, String.valueOf(corsSettings.getPreflightMaxAge()));
        }
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS_HEADER, this.commify(corsSettings.getAllowedMethods()));
        if (corsSettings.isAnyHeadersAllowed()) {
            response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS_HEADER, this.commify(headersRequested));
        } else {
            response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS_HEADER, this.commify(corsSettings.getAllowedHeaders()));
        }
    }

    private boolean isMethodAllowed(HttpServletRequest request, CorsSettings corsSettings) {
        String accessControlRequestMethod = request.getHeader(ACCESS_CONTROL_REQUEST_METHOD_HEADER);
        LOG.debug("{} is {}", new Object[]{ACCESS_CONTROL_REQUEST_METHOD_HEADER, accessControlRequestMethod});
        boolean result = false;
        if (accessControlRequestMethod != null) {
            result = corsSettings.getAllowedMethods().contains(accessControlRequestMethod);
        }
        LOG.debug("Method {} is" + (result ? "" : " not") + " among allowed methods {}", new Object[]{accessControlRequestMethod, corsSettings.getAllowedMethods()});
        return result;
    }

    private List<String> getAccessControlRequestHeaders(HttpServletRequest request) {
        String[] headers;
        String accessControlRequestHeaders = request.getHeader(ACCESS_CONTROL_REQUEST_HEADERS_HEADER);
        LOG.debug("{} is {}", new Object[]{ACCESS_CONTROL_REQUEST_HEADERS_HEADER, accessControlRequestHeaders});
        if (accessControlRequestHeaders == null) {
            return Collections.emptyList();
        }
        ArrayList<String> requestedHeaders = new ArrayList<String>();
        for (String header : headers = StringUtil.csvSplit((String)accessControlRequestHeaders)) {
            String h = header.trim();
            if (h.length() <= 0) continue;
            requestedHeaders.add(h);
        }
        return requestedHeaders;
    }

    private boolean areHeadersAllowed(List<String> requestedHeaders, CorsSettings corsSettings) {
        if (corsSettings.isAnyHeadersAllowed()) {
            LOG.debug("Any header is allowed", new Object[0]);
            return true;
        }
        boolean result = true;
        for (String requestedHeader : requestedHeaders) {
            boolean headerAllowed = false;
            for (String allowedHeader : corsSettings.getAllowedHeaders()) {
                if (!requestedHeader.equalsIgnoreCase(allowedHeader.trim())) continue;
                headerAllowed = true;
                break;
            }
            if (headerAllowed) continue;
            result = false;
            break;
        }
        LOG.debug("Headers [{}] are" + (result ? "" : " not") + " among allowed headers {}", new Object[]{requestedHeaders, corsSettings.getAllowedHeaders()});
        return result;
    }

    private String commify(List<String> strings) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strings.size(); ++i) {
            if (i > 0) {
                builder.append(",");
            }
            String string = strings.get(i);
            builder.append(string);
        }
        return builder.toString();
    }

    public void destroy() {
        this.allowCredentials = false;
    }
}

