/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.servlet.filter;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.servlet.filter.AbstractHttpFilter;
import org.sourceid.util.log.internal.HttpRequestLoggingUtil;

public class HttpRequestHeaderFilter
extends AbstractHttpFilter {
    private static final Log LOG = LogFactory.getLog(HttpRequestHeaderFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpRequestLoggingUtil.init(request);
            if (LOG.isTraceEnabled()) {
                StringBuilder logMsg = new StringBuilder();
                this.constructHeaderLogMsg(request, logMsg);
                if (logMsg.length() > 0) {
                    LOG.trace((Object)(System.lineSeparator() + logMsg));
                }
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            HttpRequestLoggingUtil.cleanup();
        }
    }

    private void constructHeaderLogMsg(HttpServletRequest request, StringBuilder logMsg) {
        Enumeration headerNames = request.getHeaderNames();
        logMsg.append(request.getMethod()).append(" ").append(request.getRequestURI()).append(" ").append(request.getProtocol()).append(System.lineSeparator());
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            logMsg.append(headerName).append(": ").append(HttpRequestLoggingUtil.getHttpHeaderValue(headerName)).append(System.lineSeparator());
        }
    }
}

