/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.servlet.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.servlet.filter.AbstractHttpFilter;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.util.log.internal.TransactionIdSupport;

public class HttpRequestIdFilter
extends AbstractHttpFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            this.storeRequestIdInThreadContext(request);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            this.storeIdsInRequestAttributes(request);
        }
        finally {
            TrackingIdSupport.clearRequestIdInThreadContext();
        }
    }

    private void storeRequestIdInThreadContext(HttpServletRequest request) {
        MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();
        String headerName = metadataLocal.getRequestHeaderNameForCorrelationId();
        TrackingIdSupport.setRequestIdInThreadContext(request.getHeader(headerName));
    }

    private void storeIdsInRequestAttributes(HttpServletRequest request) {
        request.setAttribute("trackingid", (Object)TrackingIdSupport.getTrackingId());
        request.setAttribute("transactionid", (Object)TransactionIdSupport.getTransactionId());
        request.setAttribute("httprequestid", (Object)TrackingIdSupport.getRequestId());
    }
}

