/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.servlet.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.servlet.filter.AbstractHttpFilter;

public class NoCacheFilter
extends AbstractHttpFilter {
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_HTML_8859_1 = "text/html; charset=iso-8859-1";
    public static final String TEXT_PLAIN_8859_1 = "text/plain; charset=iso-8859-1";
    public static final String TEXT_XML_8859_1 = "text/xml; charset=iso-8859-1";
    public static final String TEXT_HTML_UTF_8 = "text/html; charset=utf-8";
    public static final String TEXT_PLAIN_UTF_8 = "text/plain; charset=utf-8";
    public static final String TEXT_XML_UTF_8 = "text/xml; charset=utf-8";

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request.getRequestURI().endsWith("favicon.ico")) {
            response.sendError(404);
        } else {
            NoCacheFilter.setNoCacheHeaders(response);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public static void setNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache, no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType(TEXT_HTML_UTF_8);
    }
}

