/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.servlet.filter;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.saml20.profiles.sp.UrlMatchingService;

public class ResponseHeaderHelper {
    private static final Log log = LogFactory.getLog(ResponseHeaderHelper.class);
    private static final String HEADER_VALUE = "value";
    private static final String INCLUDE_PATTERNS = "include-patterns";
    private static final String EXCLUDE_PATTERNS = "exclude-patterns";
    private static final String PATTERNS_DELIMITER = ";";
    private final UrlMatchingService urlMatchingService;
    private final String configFileName;

    public ResponseHeaderHelper(UrlMatchingService urlMatchingService, String configFileName) {
        this.urlMatchingService = urlMatchingService;
        this.configFileName = configFileName;
    }

    public static ResponseHeaderHelper getInstance(String configFileName) {
        return new ResponseHeaderHelper(GlobalRegistry.getService(UrlMatchingService.class), configFileName);
    }

    public final void setResponseHeaders(HttpServletRequest request, HttpServletResponse response, ConfigStore configStore) {
        try {
            for (String responseHeader : configStore.getKeys()) {
                Map headerValues;
                if (!configStore.isMapValue(responseHeader) || (headerValues = configStore.getMapValue(responseHeader)) == null) continue;
                String url = request.getContextPath() + request.getServletPath() + StringUtils.defaultString((String)request.getPathInfo());
                if (headerValues.containsKey(INCLUDE_PATTERNS) && headerValues.containsKey(EXCLUDE_PATTERNS)) {
                    log.warn((Object)"include-patterns and exclude-patterns are both specified, include-patterns will be ignored.");
                }
                if (headerValues.containsKey(EXCLUDE_PATTERNS)) {
                    if (this.headerMatch((String)headerValues.get(EXCLUDE_PATTERNS), url)) continue;
                    this.setHeader(response, responseHeader, (String)headerValues.get(HEADER_VALUE));
                    continue;
                }
                if (!headerValues.containsKey(INCLUDE_PATTERNS) || !this.headerMatch((String)headerValues.get(INCLUDE_PATTERNS), url)) continue;
                this.setHeader(response, responseHeader, (String)headerValues.get(HEADER_VALUE));
            }
        }
        catch (NoSuchValueException e) {
            log.warn((Object)("Invalid response header defined in pingfederate/server/default/data/config-store/" + this.configFileName));
        }
    }

    private void setHeader(HttpServletResponse response, String responseHeader, String value) {
        if ("X-Frame-Options".equals(responseHeader) && "DENY".equals(value)) {
            value = "SAMEORIGIN";
        }
        response.setHeader(responseHeader, value);
    }

    boolean headerMatch(String patterns, String url) {
        if (patterns != null) {
            for (String pattern : patterns.split(PATTERNS_DELIMITER)) {
                if (!this.urlMatchingService.isValidUrlPattern(pattern = pattern.trim())) {
                    log.warn((Object)("Invalid pattern defined in pingfederate/server/default/data/config-store/" + this.configFileName + ": " + pattern));
                    return false;
                }
                if (!this.urlMatchingService.isMatch(pattern, url)) continue;
                return true;
            }
        }
        return false;
    }
}

