/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.token.jwt;

import com.pingidentity.crypto.BcFipsConcatKeyDerivationFunctionWithSha256;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class JWTKeyDerivationUtil {
    private static Map<String, Integer> encryptionAlgoKeySize = new HashMap<String, Integer>();
    private static Map<String, Integer> symmetricEncryptionAlgoKeySize = new HashMap<String, Integer>();

    public static SecretKey derive(String eventIdentifier, byte[] key, String algName) {
        int keyDataLength = JWTKeyDerivationUtil.getKeySize(algName);
        byte[] derivedKeyMaterial = JWTKeyDerivationUtil.concatKdf(key, keyDataLength, eventIdentifier.getBytes(StandardCharsets.UTF_8));
        return new SecretKeySpec(derivedKeyMaterial, algName);
    }

    public static int getKeySize(String encryptionAlgorithmName) {
        if (encryptionAlgoKeySize.containsKey(encryptionAlgorithmName)) {
            return encryptionAlgoKeySize.get(encryptionAlgorithmName);
        }
        return -1;
    }

    public static int getSymmetricEncryptionAlgKeySize(String encryptionAlgorithmName) {
        if (symmetricEncryptionAlgoKeySize.containsKey(encryptionAlgorithmName)) {
            return symmetricEncryptionAlgoKeySize.get(encryptionAlgorithmName);
        }
        return -1;
    }

    private static byte[] concatKdf(byte[] sharedSecret, int keyDataLen, byte[] otherInfo) {
        return new BcFipsConcatKeyDerivationFunctionWithSha256().kdf(sharedSecret, keyDataLen, otherInfo);
    }

    static {
        encryptionAlgoKeySize.put("A128CBC-HS256", 256);
        encryptionAlgoKeySize.put("A192CBC-HS384", 384);
        encryptionAlgoKeySize.put("A256CBC-HS512", 512);
        encryptionAlgoKeySize.put("A128GCM", 128);
        encryptionAlgoKeySize.put("A192GCM", 192);
        encryptionAlgoKeySize.put("A256GCM", 256);
        symmetricEncryptionAlgoKeySize.put("A128KW", 128);
        symmetricEncryptionAlgoKeySize.put("A192KW", 192);
        symmetricEncryptionAlgoKeySize.put("A256KW", 256);
        symmetricEncryptionAlgoKeySize.put("A128GCMKW", 128);
        symmetricEncryptionAlgoKeySize.put("A192GCMKW", 192);
        symmetricEncryptionAlgoKeySize.put("A256GCMKW", 256);
    }
}

