/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.token.jwt;

import com.pingidentity.common.util.Obfuscator;
import org.sourceid.token.PFInternalTokenSetting;
import org.sourceid.token.jwt.SystemKey;

public class PFInternalJwtTokenSettings
implements PFInternalTokenSetting {
    private String algorithmType;
    private SystemKey pendingKey;
    private SystemKey currentKey;
    private SystemKey previousKey;
    private byte[] currentSecret;

    public PFInternalJwtTokenSettings(String algType, SystemKey currentKey, SystemKey previousKey, SystemKey pendingKey) {
        this.algorithmType = algType;
        this.init(currentKey, previousKey, pendingKey);
    }

    private void init(SystemKey currentKey, SystemKey previousKey, SystemKey pendingKey) {
        this.currentKey = currentKey;
        this.previousKey = previousKey;
        this.pendingKey = pendingKey;
        if (this.currentKey != null) {
            this.currentSecret = this.getReversedKey(this.currentKey.getKey());
        }
    }

    public PFInternalJwtTokenSettings(SystemKey currentKey, SystemKey previousKey, SystemKey pendingKey) {
        this.init(currentKey, previousKey, pendingKey);
    }

    @Override
    public String getAlgorithmType() {
        return this.algorithmType;
    }

    @Override
    public SystemKey getPendingKey() {
        return this.pendingKey;
    }

    @Override
    public SystemKey getCurrentKey() {
        return this.currentKey;
    }

    @Override
    public SystemKey getPreviousKey() {
        return this.previousKey;
    }

    @Override
    public byte[] getReversedKey(String key) {
        return Obfuscator.deobfuscateBinary(key);
    }

    @Override
    public byte[] getCurrentSecret() {
        return (byte[])this.currentSecret.clone();
    }

    @Override
    public PFInternalJwtTokenSettings rotate(SystemKey newPendingKey) {
        SystemKey newCurrent = new SystemKey(this.pendingKey.getKey(), this.pendingKey.getCreationDate());
        SystemKey newPrevious = new SystemKey(this.currentKey.getKey(), this.currentKey.getCreationDate());
        PFInternalJwtTokenSettings rotatedSetting = new PFInternalJwtTokenSettings(newCurrent, newPrevious, newPendingKey);
        return rotatedSetting;
    }
}

