/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.token.jwt;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jose4j.jwt.JwtClaims;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.token.PFInternalTokenTranslator;

public class PFSimpleTokenTranslator
implements PFInternalTokenTranslator<String, AttributeValue> {
    private String tokenType;

    public PFSimpleTokenTranslator(String tokenType) {
        this.tokenType = tokenType;
    }

    @Override
    public JwtClaims translate(Map<String, AttributeValue> attributes) {
        JwtClaims result = new JwtClaims();
        for (Map.Entry<String, AttributeValue> attributeEntry : attributes.entrySet()) {
            AttributeValue val = attributeEntry.getValue();
            if (val.isMultiValue()) {
                result.setClaim(attributeEntry.getKey(), (Object)Lists.newArrayList((Iterable)val.getAllObjectValues()));
                continue;
            }
            result.setClaim(attributeEntry.getKey(), val.getObjectValue());
        }
        return result;
    }

    @Override
    public Map<String, AttributeValue> translate(JwtClaims claims) {
        HashMap<String, AttributeValue> result = new HashMap<String, AttributeValue>();
        for (String claimName : claims.getClaimNames()) {
            Object val = claims.getClaimValue(claimName);
            AttributeValue attrValue = val instanceof Collection ? AttrValueSupport.make((Collection)((Collection)val)) : AttrValueSupport.make((Object)val);
            result.put(claimName, attrValue);
        }
        return result;
    }

    @Override
    public String getEventType() {
        return this.tokenType;
    }
}

