/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.token.jwt;

import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.JoseException;
import org.sourceid.token.PFInternalTokenGenerator;
import org.sourceid.token.jwt.InternalTokenJwtHelper;
import org.sourceid.token.jwt.PFInternalTokenException;
import org.sourceid.token.jwt.SystemKeyState;
import org.sourceid.token.jwt.TokenInfo;

abstract class SimpleTokenGenerator
implements PFInternalTokenGenerator<String, Object> {
    private final InternalTokenJwtHelper internalTokenJwtHelper = new InternalTokenJwtHelper();

    SimpleTokenGenerator() {
    }

    protected abstract String getEventType();

    protected abstract int getExpirationTimeInMinutes();

    @Override
    public String encrypt(Map<String, Object> attributes) throws PFInternalTokenException {
        JwtClaims jwtClaims = new JwtClaims();
        if (MapUtils.isNotEmpty(attributes)) {
            attributes.forEach((arg_0, arg_1) -> ((JwtClaims)jwtClaims).setClaim(arg_0, arg_1));
        }
        jwtClaims.setIssuedAtToNow();
        jwtClaims.setExpirationTimeMinutesInTheFuture((float)this.getExpirationTimeInMinutes());
        return this.internalTokenJwtHelper.encryptParams(this.getEventType(), jwtClaims);
    }

    @Override
    public Map<String, Object> decrypt(String token) throws PFInternalTokenException {
        return this.decryptWithInfo(token).getAttributes();
    }

    @Override
    public TokenInfo<String, Object> decryptWithInfo(String token) throws PFInternalTokenException {
        try {
            JsonWebStructure jsonToken = JsonWebStructure.fromCompactSerialization((String)token);
            String algName = jsonToken.getHeader("enc");
            MutableObject keyUsedState = new MutableObject();
            JwtClaims claims = this.internalTokenJwtHelper.getJwtClaims(token, this.getEventType(), algName, (MutableObject<SystemKeyState>)keyUsedState);
            return new TokenInfo<String, Object>(claims.getClaimsMap(), (SystemKeyState)((Object)keyUsedState.getValue()));
        }
        catch (InvalidJwtException e) {
            if (e.hasErrorCode(1)) {
                PFInternalTokenException exception = new PFInternalTokenException((Exception)((Object)e));
                exception.setError(1);
                throw exception;
            }
            throw new PFInternalTokenException((Exception)((Object)e));
        }
        catch (JoseException e) {
            throw new PFInternalTokenException((Exception)((Object)e));
        }
    }

    @Override
    public Map<String, Object> getClaimsFromExpiredJwt(PFInternalTokenException exception) throws PFInternalTokenException {
        if (!(exception.getCause() instanceof InvalidJwtException)) {
            throw exception;
        }
        InvalidJwtException jwtException = (InvalidJwtException)exception.getCause();
        if (jwtException.getErrorDetails().size() != 1 || !jwtException.hasErrorCode(1)) {
            throw new PFInternalTokenException("Unable to get claims. Reasons other than expired token exists.", (Exception)((Object)jwtException));
        }
        return Optional.ofNullable(jwtException.getJwtContext()).map(JwtContext::getJwtClaims).orElse(new JwtClaims()).getClaimsMap();
    }
}

