/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util;

import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.util.log.AttributeMap;

public class AuthenticationContextUtil {
    private static final Logger log = LogManager.getLogger(AuthenticationContextUtil.class);

    private AuthenticationContextUtil() {
    }

    public static void performLocalToRemoteMapping(IdpConnection idpConn, String[] authnCtxClassRefs) {
        for (int i = 0; i < authnCtxClassRefs.length; ++i) {
            String mappedValue;
            String requestedAuthnContext = StringUtils.defaultString((String)authnCtxClassRefs[i]).trim();
            if (StringUtils.equals((String)requestedAuthnContext, (String)(mappedValue = idpConn.getAuthnContextLocalToRemoteMapping(requestedAuthnContext)))) continue;
            authnCtxClassRefs[i] = mappedValue;
            if (!log.isDebugEnabled()) continue;
            log.debug("Replaced Authn Context value from [" + requestedAuthnContext + "] to [" + mappedValue + "]");
        }
    }

    public static void performRemoteToLocalMapping(IdpConnection idpConnection, AttributeMap assertionAttributes, AttributeValue authnCtxAttributeValue, String authnCtxKey) {
        String mappedAuthnCtx;
        String authnCtx = StringUtils.defaultString((String)authnCtxAttributeValue.getValue()).trim();
        if (!StringUtils.equals((String)authnCtx, (String)(mappedAuthnCtx = idpConnection.getAuthnContextRemoteToLocalMapping(authnCtx)))) {
            AttributeValue mappedAuthnCtxAttributeValue = new AttributeValue(mappedAuthnCtx);
            assertionAttributes.put(authnCtxKey, mappedAuthnCtxAttributeValue);
            if (log.isDebugEnabled()) {
                log.debug("Replaced Requested Authn Context value from [" + authnCtx + "] to [" + mappedAuthnCtx + "]");
            }
        }
    }
}

