/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util;

import com.pingidentity.common.util.access.ExecutionContext;
import com.pingidentity.common.util.access.ExecutionContextManager;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.issuer.domain.OAuthIssuer;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.VirtualHostNamesManager;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.util.log.internal.HttpRequestLoggingUtil;

public class BaseUrlUtil {
    private static final MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    private static final VirtualHostNamesManager virtualHostNamesMgr = MgmtFactory.getVirtualHostNamesMgr();
    private static final OAuthIssuerUtils oAuthIssuerUtils = OAuthIssuerUtils.getInstance();

    private BaseUrlUtil() {
    }

    public static String getCurrentBaseUrl(String location) {
        if (BaseUrlUtil.getRequestFromContext() == null) {
            return location;
        }
        return BaseUrlUtil.getCurrentBaseUrl(location, HttpRequestLoggingUtil.getRequest().getServerName());
    }

    public static String getCurrentBaseUrl(String location, String requestedHostName) {
        String base = localMetaData.getBaseUrl();
        try {
            URL baseUrl = new URL(base);
            URL locationUrl = new URL(location);
            String baseHostName = baseUrl.getHost();
            HttpServletRequest request = BaseUrlUtil.getRequestFromContext();
            OAuthIssuer oAuthIssuer = oAuthIssuerUtils.getOAuthIssuerFromRequest(request);
            if (!requestedHostName.equals(baseHostName) && (virtualHostNamesMgr.getHostNameSet().contains(requestedHostName) || oAuthIssuer != null && requestedHostName.equals(oAuthIssuer.getHost()))) {
                int serverPort = request != null ? BaseUrlUtil.getPort(request) : locationUrl.getPort();
                return new URL(locationUrl.getProtocol(), requestedHostName, serverPort, locationUrl.getFile()).toString();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return location;
    }

    public static int getPort(HttpServletRequest request) {
        if ("http".equals(request.getScheme()) && request.getServerPort() == 80 || "https".equals(request.getScheme()) && request.getServerPort() == 443) {
            return -1;
        }
        return request.getServerPort();
    }

    private static HttpServletRequest getRequestFromContext() {
        ExecutionContext executionContext = ExecutionContextManager.getCurrentExecutionContext();
        if (executionContext == null || executionContext == ExecutionContext.RUNTIME) {
            return HttpRequestLoggingUtil.getRequest();
        }
        return null;
    }
}

