/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.util.ExternalizationException;

public final class ExternalizationEncoder {
    public static final byte TYPE_NULL = 0;
    public static final byte TYPE_BYTE = 1;
    public static final byte TYPE_SHORT = 2;
    public static final byte TYPE_INT = 3;
    public static final byte TYPE_LONG = 4;
    public static final byte TYPE_BOOL = 5;
    public static final byte TYPE_STRING = 6;
    public static final byte TYPE_ENUM = 7;
    public static final byte TYPE_STR_STR_MAP = 8;
    public static final byte TYPE_STR_OBJ_MAP = 9;
    public static final byte TYPE_STR_SET = 10;
    public static final byte TYPE_OBJECT = 11;
    public static final byte TYPE_LARGE_OBJECT = 12;
    private static final byte VALUE_FALSE = 0;
    private static final byte VALUE_TRUE = 1;
    private static String MSG_UNEXPECTED_TYPE = "Unexpected data type";

    public static void writeNull(DataOutput out) throws IOException {
        out.writeByte(0);
    }

    public static void writeByte(DataOutput out, byte data) throws IOException {
        out.writeByte(1);
        out.writeByte(data);
    }

    public static byte readByte(DataInput in) throws IOException {
        byte type = in.readByte();
        if (type != 1) {
            throw new ExternalizationException(MSG_UNEXPECTED_TYPE);
        }
        return in.readByte();
    }

    public static void writeShort(DataOutput out, short data) throws IOException {
        out.writeByte(2);
        out.writeShort(data);
    }

    public static short readShort(DataInput in) throws IOException {
        byte type = in.readByte();
        if (type != 2) {
            throw new ExternalizationException(MSG_UNEXPECTED_TYPE);
        }
        short value = in.readShort();
        return value;
    }

    public static void writeInt(DataOutput out, int data) throws IOException {
        out.writeByte(3);
        out.writeInt(data);
    }

    public static int readInt(DataInput in) throws IOException {
        byte type = in.readByte();
        if (type != 3) {
            throw new ExternalizationException(MSG_UNEXPECTED_TYPE);
        }
        int value = in.readInt();
        return value;
    }

    public static void writeLong(DataOutput out, long data) throws IOException {
        out.writeByte(4);
        out.writeLong(data);
    }

    public static long readLong(DataInput in) throws IOException {
        byte type = in.readByte();
        if (type != 4) {
            throw new ExternalizationException(MSG_UNEXPECTED_TYPE);
        }
        long value = in.readLong();
        return value;
    }

    public static void writeBoolean(DataOutput out, Boolean value) throws IOException {
        if (value == null) {
            out.writeByte(0);
        } else {
            out.writeByte(5);
            if (value == Boolean.FALSE) {
                out.writeByte(0);
            }
            if (value == Boolean.TRUE) {
                out.writeByte(1);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Boolean readBoolean(DataInput in) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (type != 5) throw new ExternalizationException(MSG_UNEXPECTED_TYPE);
        byte val = in.readByte();
        if (val == 1) {
            return Boolean.TRUE;
        }
        if (val != 0) throw new ExternalizationException("Invalid encoded value for boolean");
        return Boolean.FALSE;
    }

    public static void writeString(DataOutput out, String data) throws IOException {
        if (data == null) {
            out.writeByte(0);
        } else {
            out.writeByte(6);
            out.writeUTF(data);
        }
    }

    public static String readString(DataInput in) throws IOException {
        String retV;
        byte type = in.readByte();
        if (type == 0) {
            retV = null;
        } else if (type == 6) {
            retV = in.readUTF();
        } else {
            throw new ExternalizationException(MSG_UNEXPECTED_TYPE);
        }
        return retV;
    }

    public static <T extends Enum<?>> void writeEnum(DataOutput out, Class<T> enumClass, T value) throws IOException {
        T[] constants = enumClass.getEnumConstants();
        if (constants == null) {
            throw new IllegalArgumentException("enumClass is not an enumeration declaring class");
        }
        if (constants.length > 255) {
            throw new IllegalArgumentException("enumerations with over 255 members are not supported");
        }
        if (value == null) {
            out.writeByte(0);
        } else {
            out.writeByte(7);
            out.writeByte(value.ordinal());
        }
    }

    public static <T extends Enum<?>> T readEnum(DataInput in, Class<? extends T> enumClass) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (type == 7) {
            byte value = in.readByte();
            if ((value & 0xFF) == 255) {
                return null;
            }
            Enum[] values = (Enum[])enumClass.getEnumConstants();
            if (value >= values.length) {
                throw new StreamCorruptedException("higher than max enumerated value");
            }
            return (T)values[value];
        }
        throw new ExternalizationException(MSG_UNEXPECTED_TYPE);
    }

    public static void writeStringStringMap(DataOutput out, Map<String, String> value) throws IOException {
        if (value == null) {
            out.writeByte(0);
        } else {
            out.writeByte(8);
            out.writeInt(value.size());
            for (Map.Entry<String, String> entry : value.entrySet()) {
                out.writeUTF(entry.getKey());
                ExternalizationEncoder.writeString(out, entry.getValue());
            }
        }
    }

    public static HashMap<String, String> readStringStringMap(DataInput in) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (type == 8) {
            int count = in.readInt();
            HashMap<String, String> result = new HashMap<String, String>(count);
            for (int i = 0; i < count; ++i) {
                String key = in.readUTF();
                String value = ExternalizationEncoder.readString(in);
                result.put(key, value);
            }
            return result;
        }
        throw new ExternalizationException(MSG_UNEXPECTED_TYPE);
    }

    public static void writeStringObjectMap(ObjectOutput out, Map<String, Object> value) throws IOException {
        if (value == null) {
            out.writeByte(0);
        } else {
            out.writeByte(9);
            out.writeInt(value.size());
            for (Map.Entry<String, Object> entry : value.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }
    }

    public static HashMap<String, Object> readStringObjectMap(ObjectInput in) throws IOException, ClassNotFoundException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (type == 9) {
            int count = in.readInt();
            HashMap<String, Object> result = new HashMap<String, Object>(count);
            for (int i = 0; i < count; ++i) {
                String key = in.readUTF();
                Object value = in.readObject();
                result.put(key, value);
            }
            return result;
        }
        throw new ExternalizationException(MSG_UNEXPECTED_TYPE);
    }

    public static void writeStringSet(DataOutput out, Set<String> value) throws IOException {
        if (value == null) {
            out.writeByte(0);
        } else {
            out.writeByte(10);
            out.writeInt(value.size());
            for (String entry : value) {
                out.writeUTF(entry);
            }
        }
    }

    public static HashSet<String> readStringSet(DataInput in) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (type == 10) {
            int count = in.readInt();
            HashSet<String> result = new HashSet<String>(count);
            for (int i = 0; i < count; ++i) {
                result.add(in.readUTF());
            }
            return result;
        }
        throw new ExternalizationException(MSG_UNEXPECTED_TYPE);
    }

    public static void writeXmlObject(DataOutput out, XmlObject xmlObj) throws IOException {
        if (xmlObj != null) {
            Class xmlClass = xmlObj.schemaType().getJavaClass();
            String xmlText = xmlObj.xmlText(XmlBeansUtil.getXmlOptions());
            if (xmlText.length() > 16384) {
                out.writeByte(12);
                out.writeUTF(xmlClass.getName());
                byte[] b = xmlText.getBytes("utf-8");
                out.writeInt(b.length);
                out.write(b);
            } else {
                out.writeByte(11);
                out.writeUTF(xmlClass.getName());
                out.writeUTF(xmlText);
            }
        } else {
            out.writeByte(0);
        }
    }

    public static XmlObject readXmlObject(DataInput in) throws IOException {
        XmlObject retV;
        byte type = in.readByte();
        if (type == 0) {
            retV = null;
        } else if (type == 11 || type == 12) {
            String xmlText;
            String className = in.readUTF();
            if (type == 12) {
                int utflen = in.readInt();
                byte[] bytearr = new byte[utflen];
                in.readFully(bytearr);
                xmlText = new String(bytearr, "UTF-8");
            } else {
                xmlText = in.readUTF();
            }
            try {
                Class<?> beanClass = Class.forName(className);
                XmlOptions opts = new XmlOptions().setDocumentType(XmlBeans.typeForClass(beanClass));
                retV = XmlBeans.getContextTypeLoader().parse(xmlText, null, opts);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            catch (XmlException e) {
                throw new IOException(e);
            }
        } else {
            throw new ExternalizationException(MSG_UNEXPECTED_TYPE);
        }
        return retV;
    }
}

