/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.util.ObjectMapperFactory;

public class JsonPointerExpressionEvaluator {
    private static final Log log = LogFactory.getLog(JsonPointerExpressionEvaluator.class);

    public static Object evaluateJsonPointer(String jsonDataString, String searchExpression) {
        log.debug((Object)("Evaluating expression: " + searchExpression));
        JsonNode result = null;
        if (StringUtils.isEmpty((String)jsonDataString)) {
            log.debug((Object)"Invalid json data, returning null");
            return null;
        }
        if (StringUtils.isEmpty((String)searchExpression)) {
            log.debug((Object)"Invalid JSON Pointer expression, returning null");
            return null;
        }
        ObjectMapper mapper = ObjectMapperFactory.buildObjectMapper();
        try {
            JsonNode root = mapper.readTree(jsonDataString);
            result = root.at(searchExpression);
            if (result instanceof MissingNode || result instanceof NullNode) {
                log.debug((Object)("Could not find value from JSON response for expression: [" + searchExpression + "]"));
                result = null;
            }
        }
        catch (IOException e) {
            log.debug((Object)("Error encountered while processing expression: [" + searchExpression + "]"));
        }
        if (result != null) {
            log.debug((Object)"Successfully found value(s).");
            log.trace((Object)("Retrieved result: [" + result + "]"));
        } else {
            log.debug((Object)"Could not find any values matching JSON Pointer expression.");
        }
        return result;
    }

    public static AttributeValue convertToAttributeValue(Object value, ObjectMapper mapper) {
        AttributeValue attributeValue;
        try {
            if (value instanceof MissingNode || value instanceof NullNode) {
                attributeValue = null;
            } else if (value instanceof Map) {
                attributeValue = AttrValueSupport.make((Object)value);
            } else if (value instanceof List) {
                attributeValue = AttrValueSupport.make((Collection)((List)value), (boolean)false);
            } else if (value instanceof ObjectNode) {
                attributeValue = AttrValueSupport.make((Object)value);
            } else if (value instanceof ArrayNode) {
                List asList = (List)mapper.readValue(value.toString(), (TypeReference)new TypeReference<List<Object>>(){});
                attributeValue = AttrValueSupport.make((Collection)asList, (boolean)false);
            } else {
                attributeValue = value instanceof TextNode ? AttrValueSupport.make((Object)((TextNode)value).textValue()) : (value instanceof NumericNode ? AttrValueSupport.make((Object)((NumericNode)value).numberValue()) : (value instanceof BooleanNode ? AttrValueSupport.make((Object)((BooleanNode)value).booleanValue()) : AttrValueSupport.make((Object)value.toString())));
            }
        }
        catch (IOException e) {
            log.error((Object)("Encountered error processing attribute: " + e.getMessage()));
            attributeValue = null;
        }
        return attributeValue;
    }

    public static Map<String, AttributeValue> convertToMapOfAttributeValues(Map<String, Object> attributesMap) {
        HashMap<String, AttributeValue> mapOfAttributeValues = new HashMap<String, AttributeValue>();
        ObjectMapper mapper = new ObjectMapper();
        for (Map.Entry<String, Object> entry : attributesMap.entrySet()) {
            AttributeValue attributeValue;
            String key = entry.getKey();
            Object value = entry.getValue();
            log.trace((Object)("Parsing key: " + key + "\nvalue: " + value));
            if (value == null || (attributeValue = JsonPointerExpressionEvaluator.convertToAttributeValue(value, mapper)) == null) continue;
            mapOfAttributeValues.put(key, attributeValue);
        }
        return mapOfAttributeValues;
    }

    public static Map<String, Object> convertToObjectMap(Map<String, AttributeValue> from) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Map.Entry<String, AttributeValue> entry : from.entrySet()) {
            try {
                ret.put(entry.getKey(), entry.getValue());
            }
            catch (ClassCastException cce) {
                log.error((Object)"Unable to cast an entry's value to Object.");
            }
        }
        return ret;
    }
}

