/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;

public class UriValidationUtil {
    private static final Log log = LogFactory.getLog(UriValidationUtil.class);
    private static final Pattern UP_NAVIGATION_PATTERN = Pattern.compile("[/\\\\]\\.\\.([/\\\\]|\\Z)");

    public static boolean compareUrisEqual(String first, String second) {
        if (StringUtils.equals((String)first, (String)second)) {
            return true;
        }
        try {
            URI firstUri = new URI(first);
            URI secondUri = new URI(second);
            return secondUri.equals(firstUri);
        }
        catch (NullPointerException | URISyntaxException e) {
            return false;
        }
    }

    public static boolean compareAsUris(String uri, List<String> uriList, boolean bypassQueryValidation, boolean bypassFragmentValidation) {
        for (String uriInList : uriList) {
            if (!UriValidationUtil.compareAsUris(uri, uriInList, bypassQueryValidation, bypassFragmentValidation)) continue;
            return true;
        }
        return false;
    }

    public static boolean compareAsUris(String uri, String uriToMatchWith, boolean bypassQueryValidation, boolean bypassFragmentValidation) {
        try {
            URI firstUri = new URI(uri);
            URI secondUri = new URI(uriToMatchWith);
            if (UriValidationUtil.pathContainsUpNavigation(firstUri)) {
                return false;
            }
            if (UriValidationUtil.uriWildcardMatch(firstUri, secondUri, bypassQueryValidation, bypassFragmentValidation)) {
                return true;
            }
            if (secondUri.equals(firstUri)) {
                return true;
            }
        }
        catch (NullPointerException | URISyntaxException e) {
            return false;
        }
        return false;
    }

    public static boolean pathContainsUpNavigation(URI uri) {
        Matcher m;
        String path = uri.getPath();
        if (path != null && (m = UP_NAVIGATION_PATTERN.matcher(path)).find()) {
            log.debug((Object)("Redirect URI contains up-navigation and is disallowed: '" + uri + "'"));
            return true;
        }
        return false;
    }

    private static boolean uriWildcardMatch(URI firstUri, URI secondUri, boolean bypassQueryValidation, boolean bypassFragmentValidation) {
        if (!firstUri.getScheme().equalsIgnoreCase(secondUri.getScheme())) {
            return false;
        }
        if (secondUri.isOpaque()) {
            String secondSchemaSpecificPart;
            if (!firstUri.isOpaque()) {
                return false;
            }
            String firstSchemaSpecificPart = StringUtils.defaultString((String)firstUri.getSchemeSpecificPart());
            if (!Util.wildCardMatch(firstSchemaSpecificPart, secondSchemaSpecificPart = StringUtils.defaultString((String)secondUri.getSchemeSpecificPart()), true)) {
                return false;
            }
        } else {
            String firstAuthority = StringUtils.defaultString((String)firstUri.getRawAuthority());
            String secondAuthority = StringUtils.defaultString((String)secondUri.getRawAuthority());
            if (firstAuthority.contains("@") && secondAuthority.contains("*")) {
                log.debug((Object)"Redirect URI contains user info and is disallowed.");
                return false;
            }
            if (!Util.wildCardMatch(firstAuthority, secondAuthority, true)) {
                return false;
            }
            if (!Util.wildCardMatch(StringUtils.defaultString((String)firstUri.getRawPath()), StringUtils.defaultString((String)secondUri.getRawPath()), true)) {
                return false;
            }
            String path = StringUtils.defaultString((String)secondUri.getPath());
            if (path.endsWith("*") && secondUri.getQuery() == null && secondUri.getFragment() == null) {
                return true;
            }
            if (!bypassQueryValidation && !Util.wildCardMatch(StringUtils.defaultString((String)firstUri.getQuery()), StringUtils.defaultString((String)secondUri.getQuery()), true)) {
                return false;
            }
        }
        return bypassFragmentValidation || Util.wildCardMatch(StringUtils.defaultString((String)firstUri.getFragment()), StringUtils.defaultString((String)secondUri.getFragment()), true);
    }
}

