/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.sourceid.util.ObjectMapperFactory;

public final class JsonUtils {
    private static final JsonUtils INSTANCE = new JsonUtils();
    private final ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapper();

    public static JsonUtils getInstance() {
        return INSTANCE;
    }

    private JsonUtils() {
    }

    public JsonNode readTree(String input) throws JsonProcessingException {
        Objects.requireNonNull(input, "input");
        return this.objectMapper.readTree(input);
    }

    public Map<String, Object> toMap(JsonNode jsonNode) {
        return (Map)this.objectMapper.convertValue((Object)jsonNode, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public List toList(JsonNode jsonNode) {
        return (List)this.objectMapper.convertValue((Object)jsonNode, List.class);
    }

    public Map<String, Object> readToMap(String input) throws JsonProcessingException {
        Objects.requireNonNull(input, "input");
        JsonNode jsonNode = this.objectMapper.readTree(input);
        return this.toMap(jsonNode);
    }

    public Map<String, Object> readToMap(Reader input) throws IOException {
        Objects.requireNonNull(input, "input");
        JsonNode jsonNode = this.objectMapper.readTree(input);
        return this.toMap(jsonNode);
    }

    public List readToList(String input) throws JsonProcessingException {
        Objects.requireNonNull(input, "input");
        JsonNode jsonNode = this.objectMapper.readTree(input);
        return this.toList(jsonNode);
    }

    public String writeValueAsString(Object value) throws JsonProcessingException {
        Objects.requireNonNull(value, "value");
        return this.objectMapper.writeValueAsString(value);
    }
}

