/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.license;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.sourceid.common.Util;
import org.sourceid.util.license.LicenseConnectionGroup;
import org.sourceid.util.license.LicenseFeature;
import org.sourceid.util.license.PingLicense;

public class DisplayableLicense {
    static final int ONE = 1;
    PingLicense license;
    private static final String UNLIMITED = "unlimited";

    DisplayableLicense(PingLicense l) {
        this.license = l;
    }

    public String getDetailInfo() {
        if (this.license.licenseFileExists()) {
            StringBuilder details = new StringBuilder().append("License Edition: ").append(this.getType());
            details.append(Util.LINE_BREAK).append("License ID: ").append(this.getID());
            details.append(Util.LINE_BREAK).append("Issue Date: ").append(this.getIssueDate());
            details.append(Util.LINE_BREAK).append("Product: ").append(this.getProduct());
            details.append(Util.LINE_BREAK).append("Version: ").append(this.getVersion());
            details.append(Util.LINE_BREAK).append("Issued To: ").append(this.getName());
            details.append(Util.LINE_BREAK).append("Org: ").append(this.getOrganization());
            details.append(Util.LINE_BREAK).append("Node Limit: ").append(this.getNodeLimit());
            details.append(Util.LINE_BREAK).append("Connection Limit: ").append(this.getConnectionLimit());
            if (this.hasConnectionLimitDetailsAttribute()) {
                details.append(Util.LINE_BREAK).append("Connection Group Details: ").append(this.getConnectionGroupList());
            }
            details.append(Util.LINE_BREAK).append("Expiration Date: ").append(this.getExpirationDate());
            List<LicenseFeature> others = this.license.getOtherFeatures();
            for (LicenseFeature feature : others) {
                details.append(Util.LINE_BREAK).append(feature);
            }
            return details.toString();
        }
        return "No license file.";
    }

    public String getDaysLeft(Date from) {
        Date expirationDate = this.license.getExpirationDate();
        return this.calculateDaysLeft(from, expirationDate);
    }

    public String getFirstGrpDaysLeft(Date from) {
        Date expirationDate = this.license.getFirstGroupExpirationDate();
        return this.calculateDaysLeft(from, expirationDate);
    }

    private String calculateDaysLeft(Date from, Date expirationDate) {
        if (expirationDate == null) {
            return UNLIMITED;
        }
        long daysLeft = 0L;
        long diffInMs = expirationDate.getTime() - from.getTime();
        if (diffInMs > 0L && (daysLeft = Math.round((double)diffInMs / 8.64E7)) == NumberUtils.LONG_ZERO) {
            return "<1";
        }
        return DisplayableLicense.formatNumber(daysLeft);
    }

    public String getNodeLimit() {
        return this.toText(this.license.getNodeLimit());
    }

    public String getConnectionLimit() {
        return this.toText(this.license.getConnectionLimit());
    }

    public String getExpirationDate() {
        return this.maskNull(this.license.getExpirationDate(), "none");
    }

    public String getFirstGrpExpirationDate() {
        return this.maskNull(this.license.getFirstGroupExpirationDate(), "none");
    }

    public String getType() {
        return this.maskNull(this.license.getType());
    }

    public String getEnforcementType() {
        return this.maskNull(this.license.getEnforcementType());
    }

    public String getName() {
        return this.maskNull(this.license.getName());
    }

    public boolean isNameDefined() {
        return StringUtils.isNotBlank((String)this.license.getName());
    }

    public String getVersion() {
        return this.maskNull(this.license.getVersion());
    }

    public String getProduct() {
        return this.maskNull(this.license.getProduct());
    }

    public String getID() {
        return this.maskNull(this.license.getID());
    }

    public String getOrganization() {
        return this.maskNull(this.license.getOrganization());
    }

    public boolean isOrganizationDefined() {
        return StringUtils.isNotBlank((String)this.license.getOrganization());
    }

    public String getIssueDate() {
        return this.maskNull(this.license.getIssueDate());
    }

    private String maskNull(Date d) {
        return this.maskNull(d, "none");
    }

    private String maskNull(Date d, String mask) {
        if (d != null) {
            DateFormat fmt = DateFormat.getDateInstance(3);
            mask = fmt.format(d);
        }
        return this.maskNull(mask);
    }

    private String maskNull(String s) {
        return s == null ? "unspecified" : s;
    }

    private String toText(Number n) {
        String text = UNLIMITED;
        if (n != null) {
            text = DisplayableLicense.formatNumber(n);
        }
        return text;
    }

    static String formatNumber(Number n) {
        return NumberFormat.getInstance().format(n);
    }

    public String toString() {
        return this.getDetailInfo();
    }

    public boolean hasConnectionLimitDetailsAttribute() {
        return this.license.hasConnectionLimitDetailsAttribute();
    }

    public List<LicenseConnectionGroup> getConnectionGroupList() {
        ArrayList<LicenseConnectionGroup> list = new ArrayList<LicenseConnectionGroup>();
        Map<String, LicenseConnectionGroup> map = this.license.getConnectionLimitDetails();
        if (map != null && !map.isEmpty()) {
            for (LicenseConnectionGroup grp : map.values()) {
                list.add(grp);
            }
            Collections.sort(list);
        }
        return list;
    }
}

