/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.license;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LicenseConnectionGroup
implements Comparable<LicenseConnectionGroup> {
    private String groupName;
    private int connectionLimit;
    private Date effectiveDate;
    private Date expirationDate;
    private Date stopDate;

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public int getConnectionLimit() {
        return this.connectionLimit;
    }

    public void setConnectionLimit(int connectionLimit) {
        this.connectionLimit = connectionLimit;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public String getEffectiveDateDisplay() {
        String displayDate = "unspecified";
        if (this.effectiveDate != null) {
            DateFormat fmt = DateFormat.getDateInstance(3);
            displayDate = fmt.format(this.effectiveDate);
        }
        return displayDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public String getExpirationDateDisplay() {
        String displayDate = "unspecified";
        if (this.expirationDate != null) {
            DateFormat fmt = DateFormat.getDateInstance(3);
            displayDate = fmt.format(this.expirationDate);
        }
        return displayDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Date getStopDate() {
        return this.stopDate;
    }

    public void setStopDate(Date stopDate) {
        this.stopDate = stopDate;
    }

    public String toString() {
        SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-MM-dd");
        return this.groupName + " " + this.connectionLimit + " " + dateParser.format(this.effectiveDate) + " " + dateParser.format(this.expirationDate);
    }

    @Override
    public int compareTo(LicenseConnectionGroup group2) {
        int retV = 0;
        retV = this.getEffectiveDate().before(group2.getEffectiveDate()) ? -1 : (this.getEffectiveDate().equals(group2.getEffectiveDate()) ? 0 : 1);
        return retV;
    }

    public boolean isNotEffective() {
        boolean retV = false;
        Date now = new Date();
        if (this.effectiveDate != null && now.before(this.effectiveDate)) {
            retV = true;
        }
        return retV;
    }

    public boolean isExpired() {
        boolean retV = false;
        Date now = new Date();
        if (this.expirationDate != null && now.after(this.expirationDate)) {
            retV = true;
        }
        return retV;
    }

    public boolean isOK() {
        boolean retV = false;
        Date now = new Date();
        if (this.effectiveDate != null && !now.before(this.effectiveDate) && this.expirationDate != null && !now.after(this.expirationDate)) {
            retV = true;
        }
        return retV;
    }
}

