/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.license;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.a2a.domain.Source2TargetMapping;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.license.LicenseConnectionGroup;
import org.sourceid.util.license.LicenseObject;
import org.sourceid.util.license.PingLicense;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class LicenseConnectionGroupManager {
    private static LicenseConnectionGroupManager instance = new LicenseConnectionGroupManager();

    private LicenseConnectionGroupManager() {
    }

    public static LicenseConnectionGroupManager getInstance() {
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void okToProvideService(LicenseObject licenseObject, PingLicense lic) {
        boolean ok = false;
        if (lic == null) throw new ProcessRuntimeException("There is no available license");
        String groupName = licenseObject.getLicenseConnectionGroupAssignment();
        if (StringUtils.isNotBlank((String)groupName)) {
            Map<String, LicenseConnectionGroup> connectionGroups = lic.getConnectionLimitDetails();
            LicenseConnectionGroup licConnGroup = connectionGroups.get(groupName);
            if (licConnGroup == null) throw new ProcessRuntimeException("License does not provide service for the group: " + groupName);
            Date now = new Date();
            if (!now.after(licConnGroup.getEffectiveDate())) throw new ProcessRuntimeException("The license group '" + groupName + "' has expired");
            if (!now.before(licConnGroup.getStopDate())) throw new ProcessRuntimeException("The license group '" + groupName + "' has expired");
            if (this.getUsedConnectionCount(groupName) <= licConnGroup.getConnectionLimit()) {
                return;
            }
            boolean bl = ok = false;
            if (!ok) {
                throw new ProcessRuntimeException("The license group '" + groupName + "' has exceeded its connection limit");
            }
        } else if (licenseObject instanceof Direct2SpAdapterMapping) {
            if (!((Source2TargetMapping)licenseObject).isCountForLicense()) {
                return;
            }
            boolean bl = false;
            ok = bl;
        }
        if (ok) return;
        throw new ProcessRuntimeException("Connection/mapping doesn't have a license group assigned");
    }

    public List<LicenseConnectionGroup> getAvailableLicenseGroups(LicenseObject licenseObject, PingLicense lic, int neededNumOfLicConns) {
        ArrayList<LicenseConnectionGroup> list = new ArrayList<LicenseConnectionGroup>();
        if (lic == null || lic.getConnectionLimit() == null) {
            return list;
        }
        HashMap<String, Integer> allocated = new HashMap<String, Integer>();
        ConnectionBase connection = null;
        Source2TargetMapping source2TargetMapping = null;
        if (licenseObject instanceof ConnectionBase) {
            connection = (ConnectionBase)licenseObject;
        } else if (licenseObject instanceof Source2TargetMapping) {
            source2TargetMapping = (Source2TargetMapping)licenseObject;
        }
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        Collection<ConnectionBase> conns = connectionManager.getAllConnections();
        if (conns != null) {
            for (ConnectionBase connectionBase : conns) {
                if (connectionBase.getLicenseConnectionGroupAssignment() == null || connection != null && connectionBase.getEncodedEntityId().equals(connection.getEncodedEntityId()) && connectionBase.getRoleType().equals((Object)connection.getRoleType())) continue;
                Integer used = this.countNeededLicenseConnections(connectionBase);
                String group = connectionBase.getLicenseConnectionGroupAssignment();
                if (allocated.get(group) != null) {
                    used = used + (Integer)allocated.get(group);
                }
                allocated.put(group, used);
            }
        }
        Collection adapter2AdapterMappings = MgmtFactory.getAdapter2AdapterManager().getMappings();
        for (Object mapping : adapter2AdapterMappings) {
            this.checkAndIncrementUsedGroup(source2TargetMapping, (Source2TargetMapping)mapping, allocated);
        }
        Collection collection = MgmtFactory.getApc2SpAdapterManager().getMappings();
        for (Object mapping : collection) {
            this.checkAndIncrementUsedGroup(source2TargetMapping, (Source2TargetMapping)mapping, allocated);
        }
        Collection token2TokenMappings = MgmtFactory.getToken2TokenManager().getMappings();
        for (Source2TargetMapping mapping : token2TokenMappings) {
            this.checkAndIncrementUsedGroup(source2TargetMapping, mapping, allocated);
        }
        Date now = new Date();
        Map<String, LicenseConnectionGroup> connectionGroups = lic.getConnectionLimitDetails();
        for (LicenseConnectionGroup licGrp : connectionGroups.values()) {
            String groupName = licGrp.getGroupName();
            int used = 0;
            if (allocated.get(groupName) != null) {
                used = (Integer)allocated.get(groupName);
            }
            if (licGrp.getConnectionLimit() < used + neededNumOfLicConns || !now.before(licGrp.getExpirationDate())) continue;
            list.add(licGrp);
        }
        return list;
    }

    private void checkAndIncrementUsedGroup(Source2TargetMapping source2TargetMapping, Source2TargetMapping mapping, Map<String, Integer> allocated) {
        if (!(mapping.getLicenseConnectionGroupAssignment() == null || source2TargetMapping != null && source2TargetMapping.getSourceId().equals(mapping.getSourceId()) && source2TargetMapping.getTargetId().equals(mapping.getTargetId()))) {
            Integer used = 1;
            String group = mapping.getLicenseConnectionGroupAssignment();
            if (allocated.get(group) != null) {
                used = used + allocated.get(group);
            }
            allocated.put(group, used);
        }
    }

    private int countNeededLicenseConnections(ConnectionBase con) {
        int count = 0;
        if (con.isBrowserSsoProfileConfigured()) {
            ++count;
        }
        if (con.doesWsTrustSettingsExist()) {
            ++count;
        }
        return count;
    }

    public int getUsedConnectionCount() {
        return this.getUsedConnectionCount(null);
    }

    private int getUsedConnectionCount(String groupName) {
        int used = 0;
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        Collection<ConnectionBase> conns = connectionManager.getAllConnections();
        if (conns != null) {
            for (ConnectionBase connectionBase : conns) {
                String connGroupAssignment = connectionBase.getLicenseConnectionGroupAssignment();
                if ((groupName != null || connGroupAssignment == null) && (groupName == null || !groupName.equals(connGroupAssignment))) continue;
                used += this.countNeededLicenseConnections(connectionBase);
            }
        }
        Collection adapter2AdapterMappings = MgmtFactory.getAdapter2AdapterManager().getMappings();
        for (Object mapping : adapter2AdapterMappings) {
            used = this.checkAndIncrementUsedGroup(groupName, (Source2TargetMapping)mapping, used);
        }
        Collection collection = MgmtFactory.getApc2SpAdapterManager().getMappings();
        for (Source2TargetMapping mapping : collection) {
            used = this.checkAndIncrementUsedGroup(groupName, mapping, used);
        }
        Collection token2TokenMappings = MgmtFactory.getToken2TokenManager().getMappings();
        for (Source2TargetMapping mapping : token2TokenMappings) {
            used = this.checkAndIncrementUsedGroup(groupName, mapping, used);
        }
        return used;
    }

    private int checkAndIncrementUsedGroup(String groupName, Source2TargetMapping mapping, int used) {
        String groupAssignment = mapping.getLicenseConnectionGroupAssignment();
        if (groupName == null && groupAssignment != null || groupName != null && groupName.equals(groupAssignment)) {
            ++used;
        }
        return used;
    }
}

