/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.license;

import java.util.Calendar;
import java.util.Date;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.util.license.Logger;
import org.sourceid.util.license.NotificationSupport;
import org.sourceid.util.license.PingLicense;
import org.sourceid.util.license.Status;
import org.sourceid.util.license.Synchronizer;

public class NotificationEvaluator {
    private static int LOG_INTERVAL_DAYS = 7;
    private static int EMAIL_INTERVAL_DAYS = 7;
    private static final int MIN = 1;
    private static final int MAX = 30;
    private static final long NON_LEAD_OFFSET = 660000L;
    private static final String DELIM = ":";
    private NotificationSupport notificationSupport;

    NotificationEvaluator() {
        ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
        LOG_INTERVAL_DAYS = config.getIntValue("LogIntervalDays", LOG_INTERVAL_DAYS);
        LOG_INTERVAL_DAYS = LOG_INTERVAL_DAYS < 1 ? 1 : LOG_INTERVAL_DAYS;
        LOG_INTERVAL_DAYS = LOG_INTERVAL_DAYS > 30 ? 30 : LOG_INTERVAL_DAYS;
        EMAIL_INTERVAL_DAYS = config.getIntValue("EmailIntervalDays", EMAIL_INTERVAL_DAYS);
        EMAIL_INTERVAL_DAYS = EMAIL_INTERVAL_DAYS < 1 ? 1 : EMAIL_INTERVAL_DAYS;
        EMAIL_INTERVAL_DAYS = EMAIL_INTERVAL_DAYS > 30 ? 30 : EMAIL_INTERVAL_DAYS;
        this.notificationSupport = new NotificationSupport();
    }

    public NotificationEvaluator(Logger logger) {
        this();
        this.notificationSupport = new NotificationSupport(logger);
    }

    public void evalNotifs(Status status, PingLicense license, Date now) {
        if (status != null && status.sendNotification()) {
            Date nextLogDate;
            Synchronizer synchronizer = Synchronizer.getSynchronizer();
            String key = this.makeKey(license, status);
            if (license.isSendNotifications()) {
                Date nextNotifDate = synchronizer.getNextNotificationDate(key, now);
                boolean isLead = synchronizer.isLead();
                Date date = nextNotifDate = isLead ? nextNotifDate : new Date(nextNotifDate.getTime() + 660000L);
                if (now.after(nextNotifDate)) {
                    this.notificationSupport.send(license, now, status);
                    Date next = this.nextDate(now, EMAIL_INTERVAL_DAYS);
                    synchronizer.registerNotificationSent(key, next);
                }
            }
            if (now.after(nextLogDate = synchronizer.getNextLogDate(key))) {
                this.notificationSupport.log(license, now, status);
                Date next = this.nextDate(now, LOG_INTERVAL_DAYS);
                synchronizer.registerLogLogged(key, next);
            }
        }
    }

    private String makeKey(PingLicense license, Status status) {
        return license.getID() + DELIM + status;
    }

    private Date nextDate(Date now, int daysAhead) {
        Calendar next = Calendar.getInstance();
        next.setTime(now);
        next.add(6, daysAhead);
        return next.getTime();
    }
}

