/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.license;

import java.util.Calendar;
import java.util.Date;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.util.license.Data;
import org.sourceid.util.license.PingLicense;
import org.sourceid.util.license.Status;

public class StatusEvaluator {
    static int WARN_COUNT_PERCENT = 75;
    static int GRACE_DAYS = 0;
    static int WARN_DAYS;
    ConfigStore persistance = ConfigStoreFarm.getConfig(Data.class);
    private static final int MIN_DAYS = 1;
    private static final int MAX_GRACE_DAYS;
    private static final int MAX_WARN_DAYS;
    static final int GRACE_NOT_STARTED = -1;

    StatusEvaluator() {
        ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
        GRACE_DAYS = config.getIntValue("GraceDays", GRACE_DAYS);
        GRACE_DAYS = GRACE_DAYS > MAX_GRACE_DAYS ? MAX_GRACE_DAYS : GRACE_DAYS;
        GRACE_DAYS = GRACE_DAYS < 1 ? 1 : GRACE_DAYS;
        WARN_DAYS = config.getIntValue("WarnDays", WARN_DAYS);
        WARN_DAYS = WARN_DAYS > MAX_WARN_DAYS ? MAX_WARN_DAYS : WARN_DAYS;
        WARN_DAYS = WARN_DAYS < 1 ? 1 : WARN_DAYS;
        WARN_COUNT_PERCENT = config.getIntValue("WarnPct", WARN_COUNT_PERCENT);
        WARN_COUNT_PERCENT = WARN_COUNT_PERCENT > 99 ? 99 : WARN_COUNT_PERCENT;
        WARN_COUNT_PERCENT = WARN_COUNT_PERCENT < 1 ? 1 : WARN_COUNT_PERCENT;
    }

    Status getStatus(PingLicense license, Date now) {
        Date violationDate;
        Status status = Status.OK;
        Date warnStartDate = this.getWarnDate(now);
        if (license.isExpiredWithRespectTo(warnStartDate)) {
            status = Status.WARN;
        }
        String graceStartedKey = license.getFingerPrint();
        long graceStarted = this.persistance.getLongValue(graceStartedKey, -1L);
        if (license.isExpiredWithRespectTo(now)) {
            if (-1L == graceStarted || graceStarted > now.getTime()) {
                Date exDate = license.getExpirationDate();
                graceStarted = now.getTime();
                if (exDate != null && exDate.before(now)) {
                    graceStarted = exDate.getTime();
                }
                this.persistance.setLongValue(graceStartedKey, graceStarted);
            }
            status = Status.GRACE;
        }
        if ((violationDate = this.getViolationDate(graceStarted, license)) != null && now.after(violationDate)) {
            status = Status.VIOLATION;
        }
        if (status == Status.OK && license.isAnyGroupExpiredWithRespectTo(now)) {
            status = Status.GROUP_GRACE;
        }
        if (status == Status.OK && license.isAnyGroupExpiredWithRespectTo(warnStartDate)) {
            status = Status.GROUP_WARN;
        }
        return status;
    }

    public Date getViolationDate(long graceStartMills, PingLicense license) {
        boolean graceNotStarted;
        boolean stopSvc = license.isStopService();
        boolean bl = graceNotStarted = graceStartMills == -1L;
        return stopSvc ? (graceNotStarted ? null : this.convertDate(new Date(graceStartMills), this.getGracePeriodInDays(license))) : null;
    }

    private int getGracePeriodInDays(PingLicense license) {
        int gracePeriodInDays = GRACE_DAYS;
        Long gracePeriodInLic = license.getGracePeriod();
        if (gracePeriodInLic != null) {
            gracePeriodInDays = gracePeriodInLic.intValue();
        }
        return gracePeriodInDays;
    }

    public Date getWarnDate(Date now) {
        return this.convertDate(now, WARN_DAYS);
    }

    public Date convertDate(Date date, int daysToAdd) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, daysToAdd);
        return calendar.getTime();
    }

    static {
        MAX_GRACE_DAYS = WARN_DAYS = 60;
        MAX_WARN_DAYS = MAX_GRACE_DAYS * 2;
    }
}

