/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.license;

import com.pingidentity.jgroups.DistributedMap;
import com.pingidentity.jgroups.MuxRpcDispatcherMgr;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.mgmt.impl.Mode;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;

public class Synchronizer {
    final Log log = LogFactory.getLog(this.getClass());
    private Map<Object, Object> dataSyncMap;
    private Map<String, Date> logDateMap;
    private ConfigStore persistence = ConfigStoreFarm.getConfig(this.getClass());
    private static String DATE_PATTERN = "yyyy-MM-dd";
    private static final Synchronizer synchronizer = new Synchronizer();
    static final double HOURS_AFTER_MIDNIGHT = 9.5;
    private static final long AFTER_MIDNIGHT = 34200000L;

    private Synchronizer() {
        if (ModeSupport.getMode() != Mode.STANDALONE) {
            MuxRpcDispatcherMgr muxRpcDispatcherMgr = MuxRpcDispatcherMgr.getMgr();
            this.dataSyncMap = muxRpcDispatcherMgr.getDistributedMap();
        }
        if (this.dataSyncMap == null) {
            this.dataSyncMap = new ConcurrentHashMap<Object, Object>();
        }
        this.logDateMap = new ConcurrentHashMap<String, Date>();
    }

    public static Synchronizer getSynchronizer() {
        return synchronizer;
    }

    public Set<String> getKeys() {
        HashSet<String> result = new HashSet<String>();
        for (Object key : this.dataSyncMap.keySet()) {
            if (!(key instanceof String)) continue;
            result.add((String)key);
        }
        result.addAll(this.persistence.getKeys());
        return result;
    }

    public void removeEntry(String key) {
        if (this.dataSyncMap.containsKey(key)) {
            this.dataSyncMap.remove(key);
        }
        this.persistence.clearValue(key);
    }

    public void removeAllEntries() {
        this.flushDistributedCache();
        this.purgePersistence();
    }

    public void flushDistributedCache() {
        this.dataSyncMap.clear();
    }

    public void purgePersistence() {
        for (String key : this.persistence.getKeys()) {
            this.persistence.clearValue(key);
        }
    }

    public void registerLogLogged(String key, Date nextLog) {
        this.logDateMap.put(key, nextLog);
    }

    public Date getNextLogDate(String key) {
        Date date = this.logDateMap.get(key);
        return date != null ? date : new Date(0L);
    }

    public void registerNotificationSent(String key, boolean writeDistributedCache) {
        if (writeDistributedCache) {
            this.dataSyncMap.put(key, key);
        }
        this.persistence.setStringValue(key, key);
    }

    public boolean isNotificationSent(String key, boolean checkDistributedCache) {
        if (checkDistributedCache && this.dataSyncMap.containsKey(key)) {
            return true;
        }
        return this.persistence.getStringValue(key, null) != null;
    }

    public void registerNotificationSent(String key, Date nextSend) {
        SimpleDateFormat dateParser = new SimpleDateFormat(DATE_PATTERN);
        String val = dateParser.format(nextSend);
        this.dataSyncMap.put(key, val);
        this.persistence.setStringValue(key, val);
    }

    public Date getNextNotificationDate(String key, Date now) {
        Object memDateObj = this.dataSyncMap.get(key);
        String memoryDateStr = memDateObj instanceof String ? (String)memDateObj : null;
        String fileDateStr = this.persistence.getStringValue(key, null);
        Date date = this.getDate(memoryDateStr, fileDateStr, now);
        return new Date(date.getTime() + 34200000L);
    }

    private Date getDate(String s1, String s2, Date now) {
        Date d2;
        Date d1 = this.getDate(s1, now);
        return d1.after(d2 = this.getDate(s2, now)) ? d1 : d2;
    }

    private Date getDate(String dateStr, Date now) {
        if (dateStr != null) {
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(DATE_PATTERN);
                return dateParser.parse(dateStr);
            }
            catch (ParseException e) {
                this.log.warn((Object)("Can't parse date from " + dateStr + ". " + e));
            }
        }
        Calendar c = Calendar.getInstance();
        c.setTime(now);
        c.set(11, 0);
        return c.getTime();
    }

    public String getIP() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            return localHost.getHostAddress();
        }
        catch (UnknownHostException e) {
            this.log.warn((Object)("Can't get local ip: " + e));
            return "Unknown";
        }
    }

    public boolean isLead() {
        return !(this.dataSyncMap instanceof DistributedMap) || ((DistributedMap)((Object)this.dataSyncMap)).isLeadDog();
    }
}

