/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.log.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.WsTrustFederatedWspSettings;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.util.log.internal.AttrMaskingXmlObjFactory;
import org.sourceid.util.log.internal.Constants;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.wstrust.model.WsTrustInMessageContext;

public class AttrMaskingXmlObjFactoryIn
extends AttrMaskingXmlObjFactory<InMessageContext> {
    private static final String S1RESP = "{urn:oasis:names:tc:SAML:1.0:protocol}Response";
    private static final String S2RESP = "{urn:oasis:names:tc:SAML:2.0:protocol}Response";
    private static final String S2ARTRESP = "{urn:oasis:names:tc:SAML:2.0:protocol}ArtifactResponse";
    private static final String RSTR = "{http://schemas.xmlsoap.org/ws/2005/02/trust}RequestSecurityTokenResponse";
    private static final String SOAP11 = "{http://schemas.xmlsoap.org/soap/envelope/}Envelope";
    private static final String SOAP12 = "{http://www.w3.org/2003/05/soap-envelope}Envelope";
    private static final Set<String> ATTR_HOLDERS = new HashSet<String>(Arrays.asList("{urn:oasis:names:tc:SAML:1.0:protocol}Response", "{urn:oasis:names:tc:SAML:2.0:protocol}Response", "{urn:oasis:names:tc:SAML:2.0:protocol}ArtifactResponse", "{http://schemas.xmlsoap.org/ws/2005/02/trust}RequestSecurityTokenResponse", "{http://schemas.xmlsoap.org/soap/envelope/}Envelope", "{http://www.w3.org/2003/05/soap-envelope}Envelope"));
    private static final String SAML2_ATTR_QUERY_REQ = "{urn:oasis:names:tc:SAML:2.0:protocol}AttributeQuery";

    @Override
    Set<String> getMaskedNames(InMessageContext inMsgCtx) {
        String entityId;
        Set<String> maskedAttrNames = Constants.EMPTY;
        Role roleType = inMsgCtx.getRoleType();
        String inDocName = this.getDocName(inMsgCtx);
        if (roleType == Role.IDP && ATTR_HOLDERS.contains(inDocName) && (entityId = inMsgCtx.getEntityId()) != null) {
            IdpConnection idp = MetadataSupport.getIdpConnection(entityId);
            WsTrustFederatedWspSettings wsTrustSettings = idp.getWsTrustSettings();
            if (inMsgCtx instanceof WsTrustInMessageContext && wsTrustSettings != null) {
                maskedAttrNames = wsTrustSettings.getAttributeContract().getMaskedAttributeNames();
            } else {
                maskedAttrNames = idp.getMaskedAttributeNames();
                String outDocName = this.getDocName(inMsgCtx.getOriginalRequest());
                if (SAML2_ATTR_QUERY_REQ.equals(outDocName)) {
                    boolean maskAll = idp.getAttributeAuthority().isMaskAttributeValues();
                    maskedAttrNames = maskAll ? Constants.FULL_SET : Constants.EMPTY;
                }
            }
        }
        return maskedAttrNames;
    }

    private String getDocName(BaseMessageContext ctx) {
        XmlObject xmlObject;
        if (ctx != null && (xmlObject = ctx.getXmlObject()) != null) {
            return xmlObject.schemaType().getDocumentElementName().toString();
        }
        return null;
    }
}

