/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.log.internal;

import com.pingidentity.common.util.Base64URL;
import com.pingidentity.pingcommons.crypto.IDGenerator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.websso.AuditLogger;

public class TrackingIdSupport {
    public static final String CROSS_REFERENCE_MESSAGE_TAG = "[cross-reference-message]";
    public static final String CROSS_REFERENCE_ENTITY_ID_TAG = "entityid:";
    public static final String CROSS_REFERENCE_SUBJECT_TAG = "subject:";
    public static final String CROSS_REFERENCE_SESSION_TAG = "PFSessionXRefID:";
    public static final String TRACKING_ID_TAG = "tid:";
    public static final String AT_TRACKING_ID_TAG = "atid:";
    public static final String MDC_TRACKING_ID_KEY = "trackingid";
    public static final String MDC_HTTP_REQUEST_ID_KEY = "httprequestid";
    public static final int REQUEST_ID_MAX_CHARACTERS = 50;
    private static final String httpRequestIdRegex = "[a-zA-Z0-9\\-/]+";
    private static final Pattern httpRequestIdPattern = Pattern.compile("[a-zA-Z0-9\\-/]+");
    private static final Log log = LogFactory.getLog(TrackingIdSupport.class);

    public static void addReference(String id) {
        log.debug((Object)("[cross-reference-message] PFSessionXRefID:" + id));
    }

    public static void createUserCrossReference() {
        log.debug((Object)("[cross-reference-message] entityid:" + ThreadContext.get((String)AuditLogger.MDC_KEY.PARTNER_ID.toString()) + " subject:" + ThreadContext.get((String)AuditLogger.MDC_KEY.SUBJECT.toString())));
    }

    public static String generateTrackingId(HttpServletRequest request, HttpServletResponse response) {
        Object trackingId = "";
        if (request != null && response != null) {
            String sessionId = StateMgmtFactory.getLocalSessionId(request, response);
            byte[] bytes = HashUtil.hashToBytes((String)sessionId, (HashAlgorithm)HashAlgorithm.SHA1);
            trackingId = TRACKING_ID_TAG + Base64URL.encodeToString((byte[])bytes);
        }
        return trackingId;
    }

    public static String generateAtTrackingIdForPA(String accessTokenValue) {
        byte[] bytes = HashUtil.hashToBytes((String)accessTokenValue, (HashAlgorithm)HashAlgorithm.SHA1);
        return AT_TRACKING_ID_TAG + Base64URL.encodeToString((byte[])bytes);
    }

    public static String getTrackingId() {
        return ThreadContext.get((String)MDC_TRACKING_ID_KEY);
    }

    public static void setTrackingIdInThreadContext(HttpServletRequest request, HttpServletResponse response) {
        ThreadContext.put((String)MDC_TRACKING_ID_KEY, (String)TrackingIdSupport.generateTrackingId(request, response));
    }

    public static void clearTrackingIdInThreadContext() {
        ThreadContext.remove((String)MDC_TRACKING_ID_KEY);
    }

    public static String getRequestId() {
        return ThreadContext.get((String)MDC_HTTP_REQUEST_ID_KEY);
    }

    public static void setRequestIdInThreadContext(String id) {
        if (StringUtils.isBlank((String)id)) {
            id = IDGenerator.rndAlphaNumeric((int)25);
            if (log.isDebugEnabled()) {
                log.debug((Object)("The incoming request does not contain a unique identifier. Assigning auto-generated request ID: " + id));
            }
        } else if (id.length() > 50) {
            id = IDGenerator.rndAlphaNumeric((int)25);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("The incoming request contains a unique identifier with more than %d characters.", 50));
                log.debug((Object)("Discarding the value provided in the request and assigning auto-generated request ID: " + id));
            }
        } else if (!TrackingIdSupport.isRequestIdValid(id)) {
            id = IDGenerator.rndAlphaNumeric((int)25);
            if (log.isDebugEnabled()) {
                log.debug((Object)"The incoming request contains a unique identifier with illegal special characters. Only alphanumeric characters, hyphens, and forward slashes are allowed.");
                log.debug((Object)("Discarding the value provided in the request and assigning auto-generated request ID: " + id));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("The incoming request contains a unique identifier with request ID: " + id));
        }
        ThreadContext.put((String)MDC_HTTP_REQUEST_ID_KEY, (String)id);
    }

    public static void clearRequestIdInThreadContext() {
        ThreadContext.remove((String)MDC_HTTP_REQUEST_ID_KEY);
    }

    static boolean isRequestIdValid(String id) {
        Matcher matcher = httpRequestIdPattern.matcher(id);
        return matcher.matches();
    }
}

