/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.log.internal;

import com.pingidentity.pingcommons.crypto.IDGenerator;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.saml20.state.State;

public final class TransactionIdSupport {
    private static final Log LOG = LogFactory.getLog(TransactionIdSupport.class);
    private static final int TRANSACTION_ID_LENGTH = 25;
    public static final String MDC_HTTP_TRANSACTION_ID_KEY = "transactionid";
    public static final String STATE_PARAM_TRANSACTION_ID = "TIS.TransactionId";

    private TransactionIdSupport() {
        throw new UnsupportedOperationException("Cannot create a new instance");
    }

    public static void addTransactionIdToStateIfNeeded(State state) {
        Objects.requireNonNull(state, "state");
        if (state.getParameters() == null) {
            state.setParameters(new HashMap<String, Object>());
        }
        if (state.getParameters().containsKey(STATE_PARAM_TRANSACTION_ID)) {
            return;
        }
        state.getParameters().put(STATE_PARAM_TRANSACTION_ID, TransactionIdSupport.getTransactionId());
    }

    public static void restoreTransactionIdFromStateIfPresent(State state) {
        if (state == null || state.getParameters() == null || !state.getParameters().containsKey(STATE_PARAM_TRANSACTION_ID)) {
            return;
        }
        Object transactionIdObj = state.getParameters().get(STATE_PARAM_TRANSACTION_ID);
        if (transactionIdObj instanceof String) {
            String id = (String)transactionIdObj;
            ThreadContext.put((String)MDC_HTTP_TRANSACTION_ID_KEY, (String)id);
        } else {
            LOG.warn((Object)"The Transaction ID present in the state is not a String, moving on without restoring");
        }
    }

    public static void createTransactionId() {
        String id = IDGenerator.rndAlphaNumeric((int)25);
        ThreadContext.put((String)MDC_HTTP_TRANSACTION_ID_KEY, (String)id);
    }

    public static String getTransactionId() {
        return ThreadContext.get((String)MDC_HTTP_TRANSACTION_ID_KEY);
    }

    public static void setTransactionId(String transactionId) {
        ThreadContext.put((String)MDC_HTTP_TRANSACTION_ID_KEY, (String)transactionId);
    }
}

